/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.config;

import com.intellij.DynamicBundle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.ui.components.JBTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.NullableConsumer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.service.project.wizard.GradleParentProjectForm;
import org.jetbrains.plugins.grails.config.GrailsModuleBuilder;
import org.jetbrains.plugins.grails.ui.GrailsSDKHomeForm;
import org.jetbrains.plugins.grails.util.version.Version;

public class GrailsOptionsWizardStep
extends ModuleWizardStep {
    @NotNull
    private final WizardContext myContext;
    @NotNull
    private final GrailsModuleBuilder myBuilder;
    @NotNull
    private final GradleParentProjectForm myParentProjectForm;
    private final GrailsSDKHomeForm mySelectSDKHomeForm;
    private JPanel myRootPanel;
    private JPanel myParentProjectPanel;
    private JPanel mySDKPanel;
    private JBLabel myOptionsLabel;
    private JBTextField myOptions;
    private JBRadioButton myCreateApp;
    private JBRadioButton myCreatePlugin;
    private JPanel myOptionsPanel;

    public GrailsOptionsWizardStep(@NotNull WizardContext context, @NotNull GrailsModuleBuilder builder) {
        if (context == null) {
            GrailsOptionsWizardStep.$$$reportNull$$$0(0);
        }
        if (builder == null) {
            GrailsOptionsWizardStep.$$$reportNull$$$0(1);
        }
        this.myContext = context;
        this.myBuilder = builder;
        NullableConsumer nullableConsumer = data -> this.updateComponents();
        this.$$$setupUI$$$();
        this.myParentProjectForm = new GradleParentProjectForm(context, nullableConsumer);
        this.mySelectSDKHomeForm = new GrailsSDKHomeForm();
        this.mySelectSDKHomeForm.setChangedCallback(this::updateComponents);
        this.mySelectSDKHomeForm.setPath(PropertiesComponent.getInstance().getValue("grails.last.selected.sdk.home"));
        this.myParentProjectPanel.add(this.myParentProjectForm.getComponent());
        this.mySDKPanel.add(this.mySelectSDKHomeForm.getComponent());
        this.myOptionsLabel.setLabelFor((Component)this.myOptions);
    }

    public JComponent getComponent() {
        return this.myRootPanel;
    }

    public void updateDataModel() {
        this.myBuilder.setGrailsSDKHome(this.mySelectSDKHomeForm.getSelectedSdk());
        this.myBuilder.setParentProject(this.myParentProjectForm.getParentProject());
        this.myBuilder.setCreateChoice(this.getCreationChoice());
        this.myBuilder.setOptions(this.myOptions.getText());
        this.myBuilder.setCreatingNewProject(this.myContext.isCreatingNewProject());
    }

    public boolean validate() throws ConfigurationException {
        return this.mySelectSDKHomeForm.validate();
    }

    public void disposeUIResources() {
        Disposer.dispose((Disposable)this.myParentProjectForm);
    }

    private void updateComponents() {
        this.myParentProjectForm.updateComponents();
        this.myOptionsPanel.setVisible(this.mySelectSDKHomeForm.validate() && this.mySelectSDKHomeForm.getSelectedSdk().getVersion().isAtLeast(Version.GRAILS_3_0));
    }

    @NotNull
    private String getCreationChoice() {
        if (this.myCreateApp.isSelected()) {
            return "create-app";
        }
        if (this.myCreatePlugin.isSelected()) {
            return "create-plugin";
        }
        throw new AssertionError((Object)"No selection");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "builder";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/grails/config/GrailsOptionsWizardStep";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBTextField jBTextField;
        JBLabel jBLabel;
        JPanel jPanel;
        JBRadioButton jBRadioButton;
        JBRadioButton jBRadioButton2;
        JPanel jPanel2;
        JPanel jPanel3;
        JPanel jPanel4;
        this.myRootPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 6, 0, 6), -1, -1, false, false));
        this.mySDKPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel3, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myParentProjectPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel2, new GridConstraints(1, 0, 1, 2, 0, 3, 2, 2, null, null, null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(5, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/GrailsBundle", GrailsOptionsWizardStep.class).getString("wizard.form.lable.create"));
        jPanel4.add((Component)jBLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCreateApp = jBRadioButton2 = new JBRadioButton();
        jBRadioButton2.setSelected(true);
        this.$$$loadButtonText$$$((AbstractButton)jBRadioButton2, DynamicBundle.getBundle((String)"messages/GrailsBundle", GrailsOptionsWizardStep.class).getString("wizard.form.checkbox.create.app"));
        jPanel4.add((Component)jBRadioButton2, new GridConstraints(2, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCreatePlugin = jBRadioButton = new JBRadioButton();
        this.$$$loadButtonText$$$((AbstractButton)jBRadioButton, DynamicBundle.getBundle((String)"messages/GrailsBundle", GrailsOptionsWizardStep.class).getString("wizard.form.checkbox.create.plugin"));
        jPanel4.add((Component)jBRadioButton, new GridConstraints(3, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myOptionsPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel, new GridConstraints(4, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myOptionsLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/GrailsBundle", GrailsOptionsWizardStep.class).getString("wizard.form.label.options"));
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myOptions = jBTextField = new JBTextField();
        jPanel.add((Component)jBTextField, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        jBLabel2.setAnchor((JComponent)jBLabel);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)jBRadioButton2);
        buttonGroup.add((AbstractButton)jBRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

