/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.config;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.javaee.ui.JavaeeLegacyWizardUnlock;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.function.Consumer;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.GrailsBundle;
import org.jetbrains.plugins.grails.GroovyMvcIcons;
import org.jetbrains.plugins.grails.config.GrailsGradleAwareModuleBuilder;
import org.jetbrains.plugins.grails.config.GrailsOptionsWizardStep;
import org.jetbrains.plugins.grails.runner.GrailsCommandExecutor;
import org.jetbrains.plugins.grails.runner.GrailsConsole;
import org.jetbrains.plugins.grails.runner.GrailsInstallationExecutor;
import org.jetbrains.plugins.grails.sdk.GrailsSDK;
import org.jetbrains.plugins.grails.sdk.GrailsSDKManager;
import org.jetbrains.plugins.grails.util.version.Version;
import org.jetbrains.plugins.groovy.mvc.MvcCommand;

public class GrailsModuleBuilder
extends GrailsGradleAwareModuleBuilder {
    private static final Logger LOG = Logger.getInstance(GrailsModuleBuilder.class);
    private GrailsSDK myGrailsSDK;
    @NotNull
    private String myCreationChoice = "create-app";
    @Nullable
    private String myOptions;

    public boolean isAvailable() {
        return JavaeeLegacyWizardUnlock.isAvailable();
    }

    public boolean isSuitableSdkType(SdkTypeId sdkType) {
        return sdkType instanceof JavaSdkType && !((JavaSdkType)sdkType).isDependent();
    }

    public void setupRootModel(@NotNull ModifiableRootModel modifiableRootModel) throws ConfigurationException {
        if (modifiableRootModel == null) {
            GrailsModuleBuilder.$$$reportNull$$$0(0);
        }
        if (this.myJdk != null) {
            modifiableRootModel.setSdk(this.myJdk);
        } else {
            modifiableRootModel.inheritSdk();
        }
        if (this.doAddContentEntry(modifiableRootModel) == null) {
            throw new ConfigurationException(GrailsBundle.message("module.builder.cannot.setup.root.path.error", new Object[0]));
        }
    }

    @Override
    protected void setupModule(@NotNull Module module) throws ConfigurationException {
        if (module == null) {
            GrailsModuleBuilder.$$$reportNull$$$0(1);
        }
        super.setupModule(module);
        Project project = module.getProject();
        StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(() -> {
            try {
                if (module.isDisposed()) {
                    return;
                }
                GrailsConsole.getInstance(project);
                this.doSetupModule(module);
            }
            catch (Exception e) {
                LOG.debug((Throwable)e);
                GrailsConsole.NOTIFICATION_GROUP.createNotification(GrailsBundle.message("notification.title.failed.to.create.grails.app.structure", new Object[0]), String.valueOf(e.getMessage()), NotificationType.WARNING).notify(project);
            }
        });
    }

    @Nullable
    public ModuleWizardStep getCustomOptionsStep(WizardContext context, Disposable parentDisposable) {
        return new GrailsOptionsWizardStep(context, this);
    }

    public ModuleType getModuleType() {
        return StdModuleTypes.JAVA;
    }

    @NonNls
    public String getBuilderId() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getPresentableName() {
        return GrailsBundle.message("library.name", new Object[0]);
    }

    public String getDescription() {
        return GrailsBundle.message("module.description.grails.application.module.builder", new Object[0]);
    }

    public Icon getNodeIcon() {
        return GroovyMvcIcons.Grails;
    }

    public String getParentGroup() {
        return "Groovy";
    }

    public void setGrailsSDKHome(GrailsSDK grailsSDK) {
        this.myGrailsSDK = grailsSDK;
    }

    public void setCreateChoice(@NotNull String creationChoice) {
        if (creationChoice == null) {
            GrailsModuleBuilder.$$$reportNull$$$0(2);
        }
        this.myCreationChoice = creationChoice;
    }

    public void setOptions(@Nullable String options) {
        this.myOptions = StringUtil.isEmptyOrSpaces((String)options) ? null : options;
    }

    private void doSetupModule(@NotNull Module module) throws ExecutionException {
        if (module == null) {
            GrailsModuleBuilder.$$$reportNull$$$0(3);
        }
        Project project = module.getProject();
        VirtualFile rootModuleContent = this.getModuleRoot(module);
        GrailsSDKManager.getInstance(project).setGrailsSDK(rootModuleContent.getPath(), this.myGrailsSDK.getPath());
        GeneralCommandLine parameters = this.getCreationCommandLine(module);
        Consumer<Module> linker = this.myGrailsSDK.getVersion().isAtLeast(Version.GRAILS_3_0) ? this::linkModule : null;
        Runnable onDone = () -> {
            LOG.debug("Grails application structure created for module: " + module);
            if (linker != null) {
                linker.accept(module);
            }
        };
        GrailsConsole.executeProcess(project, parameters, onDone, false, new String[0]);
    }

    @NotNull
    private GeneralCommandLine getCreationCommandLine(@NotNull Module module) throws ExecutionException {
        Sdk sdk;
        if (module == null) {
            GrailsModuleBuilder.$$$reportNull$$$0(4);
        }
        Project project = module.getProject();
        VirtualFile root = this.getModuleRoot(module);
        MvcCommand command = new MvcCommand(this.myCreationChoice, root.getName(), "--inplace");
        if (this.myOptions != null) {
            ContainerUtil.addAll(command.getArgs(), (Object[])this.myOptions.split(" "));
        }
        Sdk sdk2 = sdk = this.getModuleJdk() == null ? ProjectRootManager.getInstance((Project)project).getProjectSdk() : this.getModuleJdk();
        if (sdk == null) {
            throw new ExecutionException(ExecutionBundle.message((String)"no.jdk.for.module.error.message", (Object[])new Object[]{module.getName()}));
        }
        JavaParameters params = this.getExecutor().createJavaParameters(sdk, this.myGrailsSDK, command);
        params.setWorkingDirectory(root.getPath());
        params.setDefaultCharset(project);
        GeneralCommandLine parameters = params.toCommandLine();
        LOG.debug(parameters.getCommandLineString());
        GeneralCommandLine generalCommandLine = parameters;
        if (generalCommandLine == null) {
            GrailsModuleBuilder.$$$reportNull$$$0(5);
        }
        return generalCommandLine;
    }

    @NotNull
    private GrailsInstallationExecutor getExecutor() throws ExecutionException {
        for (GrailsCommandExecutor executor : (GrailsCommandExecutor[])GrailsCommandExecutor.EP_NAME.getExtensions()) {
            GrailsInstallationExecutor installationExecutor;
            if (!(executor instanceof GrailsInstallationExecutor) || !(installationExecutor = (GrailsInstallationExecutor)((Object)executor)).isApplicable(this.myGrailsSDK)) continue;
            GrailsInstallationExecutor grailsInstallationExecutor = installationExecutor;
            if (grailsInstallationExecutor == null) {
                GrailsModuleBuilder.$$$reportNull$$$0(6);
            }
            return grailsInstallationExecutor;
        }
        throw new ExecutionException(GrailsBundle.message("dialog.message.cannot.create.application.with.grails.sdk", this.myGrailsSDK.getPath()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifiableRootModel";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "creationChoice";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/grails/config/GrailsModuleBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/grails/config/GrailsModuleBuilder";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCreationCommandLine";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecutor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setupRootModel";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setupModule";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setCreateChoice";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doSetupModule";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getCreationCommandLine";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

