/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.config;

import com.intellij.execution.ExecutionException;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.importing.ImportSpecBuilder;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.PathKt;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.project.wizard.AbstractGradleModuleBuilder;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.grails.GrailsBundle;
import org.jetbrains.plugins.grails.runner.GrailsConsole;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0004J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0004J\u0010\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0014R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0003\u0010\u0005\"\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/plugins/grails/config/GrailsGradleAwareModuleBuilder;", "Lcom/intellij/ide/util/projectWizard/ModuleBuilder;", "()V", "isCreatingNewProject", "", "()Z", "setCreatingNewProject", "(Z)V", "parentProject", "Lcom/intellij/openapi/externalSystem/model/project/ProjectData;", "getParentProject", "()Lcom/intellij/openapi/externalSystem/model/project/ProjectData;", "setParentProject", "(Lcom/intellij/openapi/externalSystem/model/project/ProjectData;)V", "getModuleRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "module", "Lcom/intellij/openapi/module/Module;", "linkGradleProject", "", "fresh", "rootProjectPath", "Ljava/nio/file/Path;", "project", "Lcom/intellij/openapi/project/Project;", "linkModule", "setupModule", "Companion", "intellij.groovy.grails"})
public abstract class GrailsGradleAwareModuleBuilder
extends ModuleBuilder {
    @Nullable
    private ProjectData parentProject;
    private boolean isCreatingNewProject;
    @NotNull
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    @Nullable
    public final ProjectData getParentProject() {
        return this.parentProject;
    }

    public final void setParentProject(@Nullable ProjectData projectData) {
        this.parentProject = projectData;
    }

    public final boolean isCreatingNewProject() {
        return this.isCreatingNewProject;
    }

    public final void setCreatingNewProject(boolean bl) {
        this.isCreatingNewProject = bl;
    }

    protected void setupModule(@NotNull Module module) throws ConfigurationException {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        super.setupModule(module);
        if (this.isCreatingNewProject) {
            module.getProject().putUserData(ExternalSystemDataKeys.NEWLY_CREATED_PROJECT, (Object)Boolean.TRUE);
        }
    }

    protected final void linkModule(@NotNull Module module) {
        Object object;
        VirtualFile root;
        Project project;
        block6: {
            Path path;
            block5: {
                Intrinsics.checkNotNullParameter((Object)module, (String)"module");
                Project project2 = module.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"module.project");
                project = project2;
                root = this.getModuleRoot(module);
                object = this.parentProject;
                if (object == null || (object = object.getLinkedExternalProjectPath()) == null) break block5;
                Object object2 = object;
                boolean bl = false;
                boolean bl2 = false;
                Object it = object2;
                boolean bl3 = false;
                object = Paths.get((String)it, new String[0]);
                if (object != null) break block6;
            }
            if (this.isCreatingNewProject) {
                Project project3 = module.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"module.project");
                String string = project3.getBasePath();
                Intrinsics.checkNotNull((Object)string);
                path = Paths.get(string, new String[0]);
            } else {
                path = root.toNioPath();
            }
            object = path;
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"if (isCreatingNewProject\u2026!!) else root.toNioPath()");
        }
        Object rootProjectPath = object;
        boolean fresh = this.isCreatingNewProject || this.parentProject == null;
        ApplicationManager.getApplication().runWriteAction(new Runnable((Path)rootProjectPath, root, project, module, fresh){
            final /* synthetic */ Path $rootProjectPath;
            final /* synthetic */ VirtualFile $root;
            final /* synthetic */ Project $project;
            final /* synthetic */ Module $module;
            final /* synthetic */ boolean $fresh;

            public final void run() {
                try {
                    AbstractGradleModuleBuilder.setupGradleSettingsFile((Path)this.$rootProjectPath, (VirtualFile)this.$root, (String)this.$project.getName(), (String)this.$module.getName(), (boolean)this.$fresh, (boolean)false);
                    GrailsGradleAwareModuleBuilder.Companion.getLOG().debug("'settings.gradle' file set up for module: " + this.$module);
                }
                catch (ConfigurationException e) {
                    GrailsGradleAwareModuleBuilder.Companion.getLOG().debug((Throwable)e);
                    String string = GrailsBundle.message("failed.to.create.settings.gradle.notification.title", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GrailsBundle.message(\"fa\u2026adle.notification.title\")");
                    String string2 = e.getMessage();
                    if (string2 == null) {
                        string2 = "";
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"e.message ?: \"\"");
                    GrailsConsole.NOTIFICATION_GROUP.createNotification(string, string2, NotificationType.WARNING).notify(this.$project);
                }
            }
            {
                this.$rootProjectPath = path;
                this.$root = virtualFile;
                this.$project = project;
                this.$module = module;
                this.$fresh = bl;
            }
        });
        this.linkGradleProject(fresh, (Path)rootProjectPath, project);
    }

    private final void linkGradleProject(boolean fresh, Path rootProjectPath, Project project) {
        if (fresh) {
            GradleProjectSettings gradleSettings = new GradleProjectSettings();
            gradleSettings.setDistributionType(DistributionType.DEFAULT_WRAPPED);
            gradleSettings.setExternalProjectPath(PathKt.getSystemIndependentPath((Path)rootProjectPath));
            ExternalSystemApiUtil.getSettings((Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID).linkProject((ExternalProjectSettings)gradleSettings);
            LOG.debug("Project '" + project + "' linked with " + gradleSettings);
        }
        if (!this.isCreatingNewProject) {
            FileDocumentManager.getInstance().saveAllDocuments();
            LOG.debug("Starting refreshing the project: " + rootProjectPath);
        }
        ExternalSystemUtil.refreshProject((String)PathKt.getSystemIndependentPath((Path)rootProjectPath), (ImportSpecBuilder)new ImportSpecBuilder(project, GradleConstants.SYSTEM_ID));
    }

    @NotNull
    protected final VirtualFile getModuleRoot(@NotNull Module module) throws ExecutionException {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
        Intrinsics.checkNotNullExpressionValue((Object)moduleRootManager, (String)"ModuleRootManager.getInstance(module)");
        VirtualFile[] roots = moduleRootManager.getContentRoots();
        if (roots.length == 1) {
            VirtualFile virtualFile = roots[0];
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"roots[0]");
            return virtualFile;
        }
        throw (Throwable)new ExecutionException(GrailsBundle.message("dialog.message.no.module.root", new Object[0]));
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GrailsGradleAwareModuleBuilder.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/grails/config/GrailsGradleAwareModuleBuilder$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.groovy.grails"})
    public static final class Companion {
        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

