/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.config;

import com.intellij.execution.configurations.JavaParameters;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Consumer;
import com.intellij.util.PathsList;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.grails.config.GrailsConfigUtils;
import org.jetbrains.plugins.grails.config.GrailsModuleStructureUtil;
import org.jetbrains.plugins.grails.config.GrailsSettingSynchronizer;
import org.jetbrains.plugins.grails.config.GrailsSettingsService;
import org.jetbrains.plugins.grails.structure.GrailsApplicationManager;
import org.jetbrains.plugins.grails.structure.OldGrailsApplication;
import org.jetbrains.plugins.grails.util.GrailsFacetProvider;
import org.jetbrains.plugins.grails.util.GrailsNameUtils;
import org.jetbrains.plugins.grails.util.GrailsUtils;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyNamesUtil;
import org.jetbrains.plugins.groovy.mvc.MvcModuleStructureSynchronizer;
import org.jetbrains.plugins.groovy.mvc.MvcModuleStructureUtil;
import org.jetbrains.plugins.groovy.mvc.MvcPathMacros;
import org.jetbrains.plugins.groovy.mvc.MvcProjectStructure;

public final class GrailsFramework {
    private static final Logger LOG = Logger.getInstance(GrailsFramework.class);
    public static final Key<Boolean> UPDATE_IN_PROGRESS = Key.create((String)"grails.updateInProgress");
    public static final MultiMap<JpsModuleSourceRootType<?>, String> GRAILS_SOURCE_FOLDERS = new MultiMap();
    private static final String PLUGINS_MODULE_SUFFIX = "-grailsPlugins";
    private static final String GLOBAL_PLUGINS_MODULE_NAME = "GrailsGlobalPlugins";
    private static final GrailsFramework INSTANCE;
    @NonNls
    public static final String GROOVY_STARTER_CONF = "/conf/groovy-starter.conf";

    @NotNull
    public static GrailsFramework getInstance() {
        GrailsFramework grailsFramework = INSTANCE;
        if (grailsFramework == null) {
            GrailsFramework.$$$reportNull$$$0(0);
        }
        return grailsFramework;
    }

    public boolean hasSupport(@NotNull Module module) {
        if (module == null) {
            GrailsFramework.$$$reportNull$$$0(1);
        }
        return !this.isAuxModule(module) && GrailsApplicationManager.findApplication(module) != null;
    }

    @NotNull
    public String getApplicationDirectoryName() {
        return "grails-app";
    }

    public void syncSdkAndLibrariesInPluginsModule(@NotNull Module module) {
        Module pluginsModule;
        if (module == null) {
            GrailsFramework.$$$reportNull$$$0(2);
        }
        if ((pluginsModule = this.findCommonPluginsModule(module)) != null) {
            MvcModuleStructureUtil.syncAuxModuleSdk(module, pluginsModule, this);
        }
        for (Module auxModule : GrailsModuleStructureUtil.getAllCustomPluginModules(module)) {
            MvcModuleStructureUtil.syncAuxModuleSdk(module, auxModule, this);
        }
    }

    public void upgradeFramework(@NotNull Module module) {
        if (module == null) {
            GrailsFramework.$$$reportNull$$$0(3);
        }
        if (this.findAppRoot(module) != null && !GrailsModuleStructureUtil.isIdeaGeneratedCustomPluginModule(module)) {
            GrailsModuleStructureUtil.upgradeGrails(module, false);
        }
    }

    @Nullable
    public File getCommonPluginsDir(@NotNull Module module) {
        if (module == null) {
            GrailsFramework.$$$reportNull$$$0(4);
        }
        return this.toAbsoluteFile(module, GrailsSettingsService.getProjectPluginsDir(module));
    }

    public static void forceSynchronizationSetting(final @NotNull Module module) {
        if (module == null) {
            GrailsFramework.$$$reportNull$$$0(5);
        }
        new GrailsSettingSynchronizer(module){

            @Override
            protected void onDone(boolean isSettingChanged, boolean isExtractingSettingsRan) {
                super.onDone(isSettingChanged, isExtractingSettingsRan);
                GrailsFramework.getInstance().updateProjectStructure(module);
            }
        }.syncGrailsSettings(true);
    }

    private void syncModules(final Project project) {
        ArrayList<Module> grailsModules = new ArrayList<Module>();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            if (!this.hasSupport(module)) continue;
            grailsModules.add(module);
            boolean f = new GrailsSettingSynchronizer(module){

                @Override
                protected void onDone(boolean isSettingChanged, boolean isExtractingSettingsRan) {
                    super.onDone(isSettingChanged, isExtractingSettingsRan);
                    boolean stillGrailsModule = GrailsFramework.getInstance().hasSupport(this.myModule);
                    assert (isExtractingSettingsRan || stillGrailsModule);
                    if (isSettingChanged && stillGrailsModule && MvcModuleStructureUtil.isEnabledStructureUpdate()) {
                        WriteAction.run(() -> {
                            VirtualFile root = GrailsFramework.this.findAppRoot(this.myModule);
                            assert (root != null);
                            project.putUserData(UPDATE_IN_PROGRESS, (Object)true);
                            MvcModuleStructureUtil.updateModuleStructure(this.myModule, GrailsFramework.this.createProjectStructure(this.myModule, false), root);
                            project.putUserData(UPDATE_IN_PROGRESS, null);
                        });
                    }
                    if (isExtractingSettingsRan) {
                        GrailsFramework.this.syncModules(project);
                    }
                }
            }.syncGrailsSettings(false);
            if (f) continue;
            return;
        }
        if (MvcModuleStructureUtil.isEnabledStructureUpdate()) {
            project.putUserData(UPDATE_IN_PROGRESS, (Object)true);
            this.configureAuxModules(grailsModules);
            project.putUserData(UPDATE_IN_PROGRESS, null);
        }
    }

    private void configureAuxModules(ArrayList<Module> grailsModules) {
        if (grailsModules.isEmpty()) {
            return;
        }
        Project project = grailsModules.get(0).getProject();
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        WriteAction.run(() -> {
            MultiMap backInplacePluginDependencies = new MultiMap();
            MultiMap inplacePluginDependencies = new MultiMap();
            for (Module module : grailsModules.toArray(Module.EMPTY_ARRAY)) {
                Map<String, VirtualFile> locations = GrailsFramework.getCustomPluginLocations(module, true);
                for (Map.Entry<String, VirtualFile> entry : locations.entrySet()) {
                    VirtualFile pluginRoot = entry.getValue();
                    Module pluginModule = fileIndex.getModuleForFile(pluginRoot);
                    if (pluginModule != null && Comparing.equal((Object)fileIndex.getContentRootForFile(pluginRoot), (Object)pluginRoot)) {
                        if (pluginModule == module || this.isAuxModule(pluginModule)) {
                            continue;
                        }
                    } else {
                        String pluginModuleName = GrailsModuleStructureUtil.generateInplacePluginModuleName(GrailsNameUtils.toPluginName(entry.getKey()));
                        pluginModule = MvcModuleStructureUtil.createAuxiliaryModule(module, pluginModuleName, this);
                        MvcModuleStructureUtil.updateModuleStructure(pluginModule, this.createProjectStructure(pluginModule, false), pluginRoot);
                        grailsModules.add(pluginModule);
                    }
                    inplacePluginDependencies.putValue((Object)module, (Object)pluginModule);
                    backInplacePluginDependencies.putValue((Object)pluginModule, (Object)module);
                }
            }
            ArrayList<Module> correctCommonPluginModules = new ArrayList<Module>();
            for (Module module : grailsModules) {
                Module commonPluginModule;
                assert (!this.isAuxModule(module));
                assert (!module.isDisposed());
                if (backInplacePluginDependencies.get((Object)module).isEmpty() && (commonPluginModule = MvcModuleStructureUtil.updateAuxiliaryPluginsModuleRoots(module, this)) != null) {
                    Set<Module> dependenciesTransitive = GrailsModuleStructureUtil.getAllCustomPluginModules(module);
                    for (Module m : grailsModules) {
                        if (m == module) continue;
                        if (dependenciesTransitive.contains(m)) {
                            MvcModuleStructureUtil.ensureDependency(m, commonPluginModule, false);
                            continue;
                        }
                        MvcModuleStructureUtil.removeDependency(m, commonPluginModule);
                    }
                    correctCommonPluginModules.add(commonPluginModule);
                    VirtualFile[] pluginSourcesRoots = ModuleRootManager.getInstance((Module)commonPluginModule).getSourceRoots();
                    ModuleRootModificationUtil.updateModel((Module)module, modifiableModel -> {
                        ArrayList<Consumer<ContentEntry>> actions = new ArrayList<Consumer<ContentEntry>>();
                        SmartList sourceRoots = new SmartList((Object[])modifiableModel.getSourceRoots());
                        for (VirtualFile virtualFile : pluginSourcesRoots) {
                            MvcModuleStructureUtil.removeSrcFolderFromRoots(virtualFile, actions, (Collection<VirtualFile>)sourceRoots);
                        }
                        for (VirtualFile virtualFile : modifiableModel.getContentEntries()) {
                            for (Consumer consumer : actions) {
                                consumer.consume((Object)virtualFile);
                            }
                        }
                    });
                }
                for (Module m : grailsModules) {
                    if (m == module) continue;
                    if (inplacePluginDependencies.get((Object)module).contains(m)) {
                        MvcModuleStructureUtil.ensureDependency(module, m, true);
                        continue;
                    }
                    if (!GrailsUtils.isGrailsPluginModule(m)) continue;
                    MvcModuleStructureUtil.removeDependency(module, m);
                }
            }
            MvcModuleStructureUtil.updateGlobalPluginModule(project, GrailsFramework.getInstance());
            for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                if (!this.isCommonPluginsModule(module) || correctCommonPluginModules.contains(module)) continue;
                MvcModuleStructureUtil.removeAuxiliaryModule(module);
            }
        });
    }

    public void updateProjectStructure(@NotNull Module someModule) {
        Project project;
        if (someModule == null) {
            GrailsFramework.$$$reportNull$$$0(6);
        }
        if (GrailsSettingSynchronizer.isUpdateSettingRunning(project = someModule.getProject())) {
            return;
        }
        if (MvcModuleStructureUtil.isEnabledStructureUpdate()) {
            Module[] modules = ModuleManager.getInstance((Project)project).getModules();
            WriteAction.run(() -> {
                for (Module module : modules) {
                    VirtualFile root;
                    if (!this.hasSupport(module) || (root = this.findAppRoot(module)) == null) continue;
                    project.putUserData(UPDATE_IN_PROGRESS, (Object)true);
                    MvcModuleStructureUtil.updateModuleStructure(module, this.createProjectStructure(module, false), root);
                    project.putUserData(UPDATE_IN_PROGRESS, null);
                }
            });
        }
        this.syncModules(project);
    }

    public VirtualFile getSdkRoot(@Nullable Module module) {
        return GrailsConfigUtils.getSDKInstallPath(module);
    }

    public String getUserLibraryName() {
        return "Grails User Library";
    }

    private List<File> getImplicitClasspathRootsInner(Module module) {
        Library library;
        ArrayList<File> toExclude = new ArrayList<File>();
        VirtualFile sdkRoot = this.getSdkRoot(module);
        if (sdkRoot != null) {
            toExclude.add(VfsUtilCore.virtualToIoFile((VirtualFile)sdkRoot));
        }
        ContainerUtil.addIfNotNull(toExclude, (Object)this.getCommonPluginsDir(module));
        VirtualFile appRoot = this.findAppRoot(module);
        if (appRoot != null) {
            VirtualFile libDir;
            VirtualFile pluginDir = appRoot.findChild("plugins");
            if (pluginDir != null) {
                toExclude.add(VfsUtilCore.virtualToIoFile((VirtualFile)pluginDir));
            }
            if ((libDir = appRoot.findChild("lib")) != null) {
                toExclude.add(VfsUtilCore.virtualToIoFile((VirtualFile)libDir));
            }
        }
        if ((library = MvcModuleStructureUtil.findUserLibrary(module, this.getUserLibraryName())) != null) {
            for (VirtualFile file : library.getFiles(OrderRootType.CLASSES)) {
                toExclude.add(VfsUtilCore.virtualToIoFile((VirtualFile)VfsUtil.getLocalFile((VirtualFile)file)));
            }
        }
        return toExclude;
    }

    private List<File> getImplicitClasspathRoots(@NotNull Module module) {
        if (module == null) {
            GrailsFramework.$$$reportNull$$$0(7);
        }
        List<File> toExclude = this.getImplicitClasspathRootsInner(module);
        ContainerUtil.addIfNotNull(toExclude, (Object)GrailsFramework.getInstance().getSdkWorkDir(module));
        for (Module customPluginModule : GrailsModuleStructureUtil.getAllCustomPluginModules(module)) {
            VirtualFile libDir;
            VirtualFile appRoot;
            VirtualFile compilerOutputTestPath;
            CompilerModuleExtension extension = (CompilerModuleExtension)ModuleRootManager.getInstance((Module)customPluginModule).getModuleExtension(CompilerModuleExtension.class);
            VirtualFile compilerOutputPath = extension.getCompilerOutputPath();
            if (compilerOutputPath != null) {
                toExclude.add(VfsUtilCore.virtualToIoFile((VirtualFile)compilerOutputPath));
            }
            if ((compilerOutputTestPath = extension.getCompilerOutputPath()) != null) {
                toExclude.add(VfsUtilCore.virtualToIoFile((VirtualFile)compilerOutputTestPath));
            }
            if ((appRoot = this.findAppRoot(customPluginModule)) == null || (libDir = appRoot.findChild("lib")) == null) continue;
            toExclude.add(VfsUtilCore.virtualToIoFile((VirtualFile)libDir));
        }
        return toExclude;
    }

    private String getCommonPluginSuffix() {
        return PLUGINS_MODULE_SUFFIX;
    }

    public String getGlobalPluginsModuleName() {
        return GLOBAL_PLUGINS_MODULE_NAME;
    }

    public boolean isSDKLibrary(Library library) {
        return GrailsConfigUtils.getInstance().isSDKLibrary(library);
    }

    public MvcProjectStructure createProjectStructure(@NotNull Module module, boolean auxModule) {
        if (module == null) {
            GrailsFramework.$$$reportNull$$$0(8);
        }
        return new GrailsProjectStructure(module, auxModule);
    }

    public static Map<String, VirtualFile> getCustomPluginLocations(@NotNull Module module, boolean refresh) {
        Map<String, String> customPluginLocations;
        if (module == null) {
            GrailsFramework.$$$reportNull$$$0(9);
        }
        if ((customPluginLocations = GrailsSettingsService.getGrailsSettings((Module)module).customPluginLocations).isEmpty()) {
            return Collections.emptyMap();
        }
        VirtualFile root = GrailsUtils.findGrailsAppRoot(module);
        assert (root != null);
        HashMap<String, VirtualFile> res = new HashMap<String, VirtualFile>();
        for (Map.Entry<String, String> entry : customPluginLocations.entrySet()) {
            VirtualFile pluginRoot;
            if (FileUtil.isAbsolute((String)entry.getValue())) {
                if (refresh) {
                    ApplicationManager.getApplication().assertIsDispatchThread();
                    pluginRoot = LocalFileSystem.getInstance().refreshAndFindFileByPath(entry.getValue());
                } else {
                    pluginRoot = LocalFileSystem.getInstance().findFileByPath(entry.getValue());
                }
            } else {
                pluginRoot = VfsUtilCore.findRelativeFile((String)entry.getValue(), (VirtualFile)root);
            }
            if (pluginRoot == null) continue;
            res.put(GrailsNameUtils.toPluginName(entry.getKey()), pluginRoot);
        }
        return res;
    }

    private static boolean equalsIgnoreFirstCase(@NotNull String s1, @Nullable String s2) {
        if (s1 == null) {
            GrailsFramework.$$$reportNull$$$0(10);
        }
        if (s2 == null) {
            return false;
        }
        int length = s1.length();
        if (length != s2.length()) {
            return false;
        }
        if (length <= 1) {
            return s1.equalsIgnoreCase(s2);
        }
        return Character.toUpperCase(s1.charAt(0)) == Character.toUpperCase(s2.charAt(0)) && s1.substring(1).equals(s2.substring(1));
    }

    @Nullable
    public VirtualFile findPluginRoot(@NotNull Module module, String pluginName, boolean canHasVersion) {
        int idx;
        if (module == null) {
            GrailsFramework.$$$reportNull$$$0(11);
        }
        String withoutVersion = GrailsNameUtils.toPluginName(pluginName);
        String withVersion = null;
        if (canHasVersion && (idx = pluginName.lastIndexOf(45)) != -1) {
            withVersion = GrailsNameUtils.toPluginName(pluginName.substring(0, idx));
        }
        for (VirtualFile root : this.getAllPluginRoots(module, false)) {
            String name = GrailsUtils.extractGrailsPluginName(root);
            if (name == null || !GrailsFramework.equalsIgnoreFirstCase(name, withoutVersion) && !GrailsFramework.equalsIgnoreFirstCase(name, withVersion)) continue;
            return root;
        }
        return null;
    }

    public Collection<VirtualFile> getAllPluginRoots(@NotNull Module module, boolean refresh) {
        if (module == null) {
            GrailsFramework.$$$reportNull$$$0(12);
        }
        HashMap<String, VirtualFile> map2 = new HashMap<String, VirtualFile>();
        this.collectCommonPluginRoots(map2, module, refresh);
        ArrayList<VirtualFile> res = new ArrayList<VirtualFile>();
        res.addAll(map2.values());
        res.addAll(GrailsFramework.getCustomPluginLocations(module, refresh).values());
        return res;
    }

    public File getGlobalPluginsDir(@NotNull Module module) {
        if (module == null) {
            GrailsFramework.$$$reportNull$$$0(13);
        }
        return this.toAbsoluteFile(module, GrailsSettingsService.getGlobalPluginsDir(module));
    }

    @Nullable
    public File getSdkWorkDir(@NotNull Module module) {
        if (module == null) {
            GrailsFramework.$$$reportNull$$$0(14);
        }
        return this.toAbsoluteFile(module, GrailsSettingsService.getGrailsWorkDir(module));
    }

    @Nullable
    private File toAbsoluteFile(@NotNull Module module, @Nullable String path) {
        if (module == null) {
            GrailsFramework.$$$reportNull$$$0(15);
        }
        if (path == null) {
            return null;
        }
        File res = new File(path);
        if (res.isAbsolute()) {
            return res;
        }
        VirtualFile root = this.findAppRoot(module);
        if (root == null) {
            return null;
        }
        return new File(VfsUtilCore.virtualToIoFile((VirtualFile)root), path);
    }

    public static String getUserHomeGrails() {
        return MvcPathMacros.getSdkWorkDirParent("grails");
    }

    @Nullable
    public VirtualFile findAppDirectory(@Nullable Module module) {
        VirtualFile[] contentRoots;
        VirtualFile[] ancestors;
        if (module == null || this.isCommonPluginsModule(module)) {
            return null;
        }
        OldGrailsApplication oldApplication = GrailsApplicationManager.findApplication(module);
        if (oldApplication != null) {
            return oldApplication.getAppRoot();
        }
        if (ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)module) && (ancestors = VfsUtil.getCommonAncestors((VirtualFile[])(contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots()))).length == 1) {
            return ancestors[0].findChild(this.getApplicationDirectoryName());
        }
        String appDirName = this.getApplicationDirectoryName();
        for (VirtualFile root : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
            VirtualFile res = root.findChild(appDirName);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    public boolean isAuxModule(@NotNull Module module) {
        if (module == null) {
            GrailsFramework.$$$reportNull$$$0(16);
        }
        return this.isCommonPluginsModule(module) || this.isGlobalPluginModule(module);
    }

    public boolean isCommonPluginsModule(@NotNull Module module) {
        if (module == null) {
            GrailsFramework.$$$reportNull$$$0(17);
        }
        return module.getName().endsWith(this.getCommonPluginSuffix());
    }

    @Nullable
    public VirtualFile findAppRoot(@Nullable Module module) {
        if (module == null || module.isDisposed()) {
            return null;
        }
        String appDirName = this.getApplicationDirectoryName();
        for (VirtualFile root : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
            if (!root.isInLocalFileSystem() || root.findChild(appDirName) == null) continue;
            return root;
        }
        return null;
    }

    @Nullable
    public VirtualFile findAppRoot(@Nullable PsiElement element) {
        VirtualFile appDirectory = this.findAppDirectory(element);
        return appDirectory == null ? null : appDirectory.getParent();
    }

    @Nullable
    public VirtualFile findAppDirectory(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        PsiFile containingFile = element.getContainingFile().getOriginalFile();
        VirtualFile file = containingFile.getVirtualFile();
        if (file == null) {
            return null;
        }
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)containingFile.getProject()).getFileIndex();
        VirtualFile root = index.getContentRootForFile(file);
        if (root == null) {
            return null;
        }
        return root.findChild(this.getApplicationDirectoryName());
    }

    private PathsList removeFrameworkStuff(Module module, List<VirtualFile> rootFiles) {
        List<File> toExclude = this.getImplicitClasspathRoots(module);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Before removing framework stuff: " + rootFiles);
            LOG.debug("Implicit roots:" + toExclude);
        }
        PathsList scriptClassPath = new PathsList();
        block0: for (VirtualFile file : rootFiles) {
            for (File excluded : toExclude) {
                if (!VfsUtilCore.isAncestor((File)excluded, (File)VfsUtilCore.virtualToIoFile((VirtualFile)file), (boolean)false)) continue;
                continue block0;
            }
            scriptClassPath.add(file);
        }
        return scriptClassPath;
    }

    public PathsList getApplicationClassPath(Module module) {
        ArrayList<VirtualFile> classPath = new ArrayList<VirtualFile>(OrderEnumerator.orderEntries((Module)module).recursively().withoutSdk().getPathsList().getVirtualFiles());
        GrailsFramework.retainOnlyJarsAndDirectories(classPath);
        GrailsFramework.removeModuleOutput(module, classPath);
        Module pluginsModule = this.findCommonPluginsModule(module);
        if (pluginsModule != null) {
            GrailsFramework.removeModuleOutput(pluginsModule, classPath);
        }
        return this.removeFrameworkStuff(module, classPath);
    }

    private static void retainOnlyJarsAndDirectories(List<VirtualFile> woSdk) {
        Iterator<VirtualFile> iterator = woSdk.iterator();
        while (iterator.hasNext()) {
            VirtualFile file = iterator.next();
            VirtualFile local = JarFileSystem.getInstance().getVirtualFileForJar(file);
            boolean dir = file.isDirectory();
            String name = file.getName();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Considering: " + file.getPath() + "; local=" + local + "; dir=" + dir + "; name=" + name);
            }
            if (dir || local != null || name.endsWith(".jar")) continue;
            LOG.debug("Removing");
            iterator.remove();
        }
    }

    private static void removeModuleOutput(Module module, List<VirtualFile> from) {
        CompilerModuleExtension extension = (CompilerModuleExtension)ModuleRootManager.getInstance((Module)module).getModuleExtension(CompilerModuleExtension.class);
        from.remove(extension.getCompilerOutputPath());
        from.remove(extension.getCompilerOutputPathForTests());
    }

    public static void addJavaHome(Sdk sdk, @NotNull JavaParameters params) {
        String path;
        String homePath;
        if (params == null) {
            GrailsFramework.$$$reportNull$$$0(18);
        }
        if ((homePath = sdk.getHomePath()) != null && StringUtil.isNotEmpty((String)(path = StringUtil.trimEnd((String)homePath, (String)File.separator)))) {
            params.addEnv("JAVA_HOME", FileUtil.toSystemDependentName((String)path));
        }
    }

    private void extractPlugins(Project project, @Nullable VirtualFile pluginRoot, boolean refreshPluginRoot, Map<String, VirtualFile> res) {
        if (pluginRoot != null) {
            VirtualFile[] children;
            if (refreshPluginRoot) {
                pluginRoot.refresh(false, false);
            }
            if ((children = pluginRoot.getChildren()) != null) {
                for (VirtualFile child : children) {
                    String pluginName = this.getInstalledPluginNameByPath(project, child);
                    if (pluginName == null) continue;
                    res.put(pluginName, child);
                }
            }
        }
    }

    public void collectCommonPluginRoots(Map<String, VirtualFile> result2, @NotNull Module module, boolean refresh) {
        if (module == null) {
            GrailsFramework.$$$reportNull$$$0(19);
        }
        if (this.isCommonPluginsModule(module)) {
            for (VirtualFile root : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
                String pluginName = this.getInstalledPluginNameByPath(module.getProject(), root);
                if (pluginName == null) continue;
                result2.put(pluginName, root);
            }
        } else {
            VirtualFile root = this.findAppRoot(module);
            if (root == null) {
                return;
            }
            this.extractPlugins(module.getProject(), root.findChild("plugins"), refresh, result2);
            this.extractPlugins(module.getProject(), MvcModuleStructureUtil.findFile(this.getCommonPluginsDir(module), refresh), refresh, result2);
            this.extractPlugins(module.getProject(), MvcModuleStructureUtil.findFile(this.getGlobalPluginsDir(module), refresh), refresh, result2);
        }
    }

    public Collection<VirtualFile> getCommonPluginRoots(@NotNull Module module, boolean refresh) {
        if (module == null) {
            GrailsFramework.$$$reportNull$$$0(20);
        }
        HashMap<String, VirtualFile> result2 = new HashMap<String, VirtualFile>();
        this.collectCommonPluginRoots(result2, module, refresh);
        return result2.values();
    }

    @Nullable
    public Module findCommonPluginsModule(@NotNull Module module) {
        if (module == null) {
            GrailsFramework.$$$reportNull$$$0(21);
        }
        return ModuleManager.getInstance((Project)module.getProject()).findModuleByName(this.getCommonPluginsModuleName(module));
    }

    public boolean isGlobalPluginModule(@NotNull Module module) {
        if (module == null) {
            GrailsFramework.$$$reportNull$$$0(22);
        }
        return module.getName().startsWith(this.getGlobalPluginsModuleName());
    }

    public String getCommonPluginsModuleName(Module module) {
        return module.getName() + this.getCommonPluginSuffix();
    }

    public static void addAvailableSystemScripts(Collection<? super String> result2, @NotNull Module module) {
        if (module == null) {
            GrailsFramework.$$$reportNull$$$0(23);
        }
        VirtualFile scriptRoot = null;
        GlobalSearchScope searchScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module, (boolean)false);
        for (PsiClass aClass : JavaPsiFacade.getInstance((Project)module.getProject()).findClasses("CreateApp_", searchScope)) {
            VirtualFile parent;
            VirtualFile file;
            PsiFile psiFile;
            PsiClass superClass = aClass.getSuperClass();
            if (superClass == null || !"groovy.lang.Script".equals(superClass.getQualifiedName()) || (psiFile = aClass.getContainingFile()) == null || (file = psiFile.getVirtualFile()) == null || !(file.getFileSystem() instanceof JarFileSystem) || (parent = file.getParent()) == null || parent.findChild("Console.class") == null) continue;
            scriptRoot = parent;
            break;
        }
        if (scriptRoot == null) {
            return;
        }
        Pattern scriptPattern = Pattern.compile("([A-Za-z0-9]+)_?\\.class");
        for (VirtualFile file : scriptRoot.getChildren()) {
            Matcher matcher = scriptPattern.matcher(file.getName());
            if (!matcher.matches()) continue;
            result2.add(GroovyNamesUtil.camelToSnake((String)matcher.group(1)));
        }
    }

    public static void addAvailableScripts(Collection<? super String> result2, @Nullable VirtualFile root) {
        if (root == null || !root.isDirectory()) {
            return;
        }
        VirtualFile scripts = root.findChild("scripts");
        if (scripts == null || !scripts.isDirectory()) {
            return;
        }
        for (VirtualFile child : scripts.getChildren()) {
            if (!GrailsFramework.isScriptFile(child)) continue;
            result2.add(GroovyNamesUtil.camelToSnake((String)child.getNameWithoutExtension()));
        }
    }

    public static boolean isScriptFileName(String fileName) {
        return fileName.endsWith("groovy") && fileName.charAt(0) != '_';
    }

    private static boolean isScriptFile(VirtualFile virtualFile) {
        return !virtualFile.isDirectory() && GrailsFramework.isScriptFileName(virtualFile.getName());
    }

    @Nullable
    public String getInstalledPluginNameByPath(Project project, @NotNull VirtualFile pluginPath) {
        VirtualFile pluginXml;
        if (pluginPath == null) {
            GrailsFramework.$$$reportNull$$$0(24);
        }
        if ((pluginXml = pluginPath.findChild("plugin.xml")) == null) {
            return null;
        }
        PsiFile pluginXmlPsi = PsiManager.getInstance((Project)project).findFile(pluginXml);
        if (!(pluginXmlPsi instanceof XmlFile)) {
            return null;
        }
        XmlTag rootTag = ((XmlFile)pluginXmlPsi).getRootTag();
        if (rootTag == null || !"plugin".equals(rootTag.getName())) {
            return null;
        }
        XmlAttribute attrName = rootTag.getAttribute("name");
        if (attrName == null) {
            return null;
        }
        String res = attrName.getValue();
        if (res == null) {
            return null;
        }
        if ((res = res.trim()).isEmpty()) {
            return null;
        }
        return res;
    }

    @Contract(value="null -> null")
    @Nullable
    public static GrailsFramework getInstance(@Nullable Module module) {
        if (module == null) {
            return null;
        }
        Project project = module.getProject();
        return (GrailsFramework)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)module, () -> {
            SimpleModificationTracker tracker = MvcModuleStructureSynchronizer.getInstance(project).getFileAndRootsModificationTracker();
            GrailsFramework framework = GrailsFramework.getInstance();
            if (framework.hasSupport(module)) {
                return CachedValueProvider.Result.create((Object)framework, (Object[])new Object[]{tracker});
            }
            return CachedValueProvider.Result.create(null, (Object[])new Object[]{tracker});
        });
    }

    static {
        GRAILS_SOURCE_FOLDERS.put((Object)JavaSourceRootType.SOURCE, Arrays.asList("src/java", "src/gwt", "src/scala", "grails-app/utils", "src/groovy", "grails-app/jobs", "grails-app/i18n", "grails-app/realms", "grails-app/controllers", "grails-app/domain", "grails-app/services", "grails-app/taglib"));
        GRAILS_SOURCE_FOLDERS.put((Object)JavaSourceRootType.TEST_SOURCE, Arrays.asList("test/unit", "test/integration", "test/functional"));
        GRAILS_SOURCE_FOLDERS.put((Object)JavaResourceRootType.RESOURCE, Collections.singleton("grails-app/resources"));
        INSTANCE = new GrailsFramework();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/grails/config/GrailsFramework";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "someModule";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s1";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/grails/config/GrailsFramework";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "hasSupport";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "syncSdkAndLibrariesInPluginsModule";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "upgradeFramework";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getCommonPluginsDir";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "forceSynchronizationSetting";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updateProjectStructure";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getImplicitClasspathRoots";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createProjectStructure";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getCustomPluginLocations";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "equalsIgnoreFirstCase";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findPluginRoot";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getAllPluginRoots";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getGlobalPluginsDir";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getSdkWorkDir";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "toAbsoluteFile";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isAuxModule";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isCommonPluginsModule";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addJavaHome";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "collectCommonPluginRoots";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getCommonPluginRoots";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "findCommonPluginsModule";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isGlobalPluginModule";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addAvailableSystemScripts";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getInstalledPluginNameByPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class GrailsProjectStructure
    extends MvcProjectStructure {
        GrailsProjectStructure(Module module, boolean auxModule) {
            super(module, auxModule, GrailsFramework.getUserHomeGrails(), GrailsFramework.getInstance().getSdkWorkDir(module));
        }

        @Override
        @NotNull
        public String getUserLibraryName() {
            return "Grails User Library";
        }

        @Override
        public MultiMap<JpsModuleSourceRootType<?>, String> getSourceFolders() {
            return GRAILS_SOURCE_FOLDERS;
        }

        @Override
        public String[] getInvalidSourceFolders() {
            return new String[]{"src", "."};
        }

        @Override
        public String[] getExcludedFolders() {
            return new String[]{"web-app/plugins", "target/classes", "target/test-classes"};
        }

        @Override
        public List<VirtualFile> getExcludedFolders(@NotNull VirtualFile root) {
            if (root == null) {
                GrailsProjectStructure.$$$reportNull$$$0(0);
            }
            List<VirtualFile> res = super.getExcludedFolders(root);
            VirtualFile workDir = VfsUtil.findRelativeFile((VirtualFile)root, (String[])new String[]{"target", "work"});
            if (workDir != null) {
                res = new ArrayList<VirtualFile>(res);
                for (VirtualFile dir : workDir.getChildren()) {
                    if (!dir.isDirectory() || Comparing.equal((CharSequence)"plugins", (CharSequence)dir.getNameSequence())) continue;
                    res.add(dir);
                }
            }
            return res;
        }

        @Override
        public void setupFacets(Collection<Consumer<ModifiableFacetModel>> actions, Collection<VirtualFile> roots) {
            for (GrailsFacetProvider provider : (GrailsFacetProvider[])GrailsFacetProvider.EP_NAME.getExtensions()) {
                provider.addFacets(actions, this.myModule, roots);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/plugins/grails/config/GrailsFramework$GrailsProjectStructure", "getExcludedFolders"));
        }
    }
}

