/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.config;

import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import org.jetbrains.plugins.grails.util.GrailsUtils;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightMethodBuilder;
import org.jetbrains.plugins.groovy.lang.resolve.ClosureMissingMethodContributor;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public class GrailsEnvironmentClosureMemberContributor
extends ClosureMissingMethodContributor {
    private static final Object ENVIRONMENT_NAME_METHOD_KIND = "grails:environment:name";

    public boolean processMembers(GrClosableBlock closure, PsiScopeProcessor processor, GrReferenceExpression ref, ResolveState state) {
        if (ref.isQualified()) {
            return true;
        }
        PsiElement parent = ref.getParent();
        if (parent instanceof GrMethodCall && ((GrMethodCall)parent).getInvokedExpression() == ref) {
            parent = parent.getParent();
        }
        if (parent != closure) {
            return true;
        }
        String nameHint = ResolveUtil.getNameHint((PsiScopeProcessor)processor);
        if (nameHint == null) {
            for (String envName : GrailsUtils.ENVIRONMENT_LIST) {
                GrLightMethodBuilder envMethod = new GrLightMethodBuilder(closure.getManager(), envName);
                envMethod.setMethodKind(ENVIRONMENT_NAME_METHOD_KIND);
                envMethod.addParameter("closure", "groovy.lang.Closure");
                if (processor.execute((PsiElement)envMethod, state)) continue;
                return false;
            }
        } else if (GrailsUtils.ENVIRONMENT_LIST.contains(nameHint)) {
            GrLightMethodBuilder envMethod = new GrLightMethodBuilder(closure.getManager(), nameHint);
            envMethod.setMethodKind(ENVIRONMENT_NAME_METHOD_KIND);
            envMethod.addParameter("closure", "groovy.lang.Closure");
            if (!processor.execute((PsiElement)envMethod, state)) {
                return false;
            }
        }
        return true;
    }
}

