/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.actions;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.actions.GrailsActionUtilKt;
import org.jetbrains.plugins.grails.runner.GrailsCommandExecutorUtil;
import org.jetbrains.plugins.grails.structure.GrailsApplication;
import org.jetbrains.plugins.grails.structure.GrailsApplicationManager;
import org.jetbrains.plugins.grails.ui.GrailsRunCommandDialog;

public final class GrailsRunCommandAction
extends AnAction {
    private static final String LAST_SELECTED_APP_KEY = "grails.last.selected.app.url";

    public void update(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            GrailsRunCommandAction.$$$reportNull$$$0(0);
        }
        boolean canRun = (project = e.getProject()) != null && GrailsApplicationManager.getInstance(project).hasApplications();
        e.getPresentation().setEnabledAndVisible(canRun);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            GrailsRunCommandAction.$$$reportNull$$$0(1);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        GrailsApplication application = GrailsRunCommandAction.getApplicationForSelection(e.getDataContext(), project);
        GrailsRunCommandDialog dialog = new GrailsRunCommandDialog(project).setSelectedApplication(application);
        if (dialog.showAndGet()) {
            GrailsApplication selectedApplication = dialog.getSelectedApplication();
            PropertiesComponent.getInstance((Project)project).setValue(LAST_SELECTED_APP_KEY, selectedApplication.getRoot().getUrl());
            GrailsCommandExecutorUtil.execute(selectedApplication, dialog.getCommand(), null, false, new String[0]);
        }
    }

    @Nullable
    private static GrailsApplication getApplicationForSelection(@NotNull DataContext context, @NotNull Project project) {
        GrailsApplication application;
        if (context == null) {
            GrailsRunCommandAction.$$$reportNull$$$0(2);
        }
        if (project == null) {
            GrailsRunCommandAction.$$$reportNull$$$0(3);
        }
        if ((application = GrailsActionUtilKt.getGrailsApplication(context)) != null) {
            return application;
        }
        GrailsApplicationManager applicationManager = GrailsApplicationManager.getInstance(project);
        Collection<GrailsApplication> applications = applicationManager.getApplications();
        if (applications.size() == 1) {
            return (GrailsApplication)ContainerUtil.getFirstItem(applications);
        }
        String url = PropertiesComponent.getInstance((Project)project).getValue(LAST_SELECTED_APP_KEY);
        if (url != null) {
            VirtualFile root = VirtualFileManager.getInstance().findFileByUrl(url);
            return applicationManager.getApplicationByRoot(root);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/grails/actions/GrailsRunCommandAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getApplicationForSelection";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

