/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.actions;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import org.jetbrains.plugins.grails.config.GrailsFramework;
import org.jetbrains.plugins.groovy.actions.GroovySourceFolderDetector;

final class GrailsGroovySourceFolderDetector
extends GroovySourceFolderDetector {
    private static final String[] GROOVY_FOLDERS = new String[]{"grails-app/controllers", "grails-app/domain", "grails-app/services", "grails-app/taglib", "src/groovy"};

    GrailsGroovySourceFolderDetector() {
    }

    public boolean isGroovySourceFolder(PsiDirectory file) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        VirtualFile appRoot = GrailsFramework.getInstance().findAppRoot(module);
        if (appRoot == null) {
            return false;
        }
        assert (module != null);
        if (GrailsFramework.getInstance().getSdkRoot(module) == null) {
            return false;
        }
        String path = VfsUtilCore.getRelativePath((VirtualFile)file.getVirtualFile(), (VirtualFile)appRoot, (char)'/');
        if (path == null) {
            return false;
        }
        for (String groovyFolder : GROOVY_FOLDERS) {
            if (!path.equals(groovyFolder) && (!path.startsWith(groovyFolder) || !path.startsWith("/", groovyFolder.length()))) continue;
            return true;
        }
        return false;
    }
}

