/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.actions;

import com.intellij.jsp.highlighter.JspxFileType;
import com.intellij.jsp.highlighter.NewJspFileType;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.navigation.GotoRelatedProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.GrailsBundle;
import org.jetbrains.plugins.grails.GroovyMvcIcons;
import org.jetbrains.plugins.grails.config.GrailsFramework;
import org.jetbrains.plugins.grails.fileType.GspFileType;
import org.jetbrains.plugins.grails.lang.gsp.GspFileViewProvider;
import org.jetbrains.plugins.grails.util.GrailsArtifact;
import org.jetbrains.plugins.grails.util.GrailsUtils;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.util.GroovyUtils;

public class GrailsGotoRelatedProvider
extends GotoRelatedProvider {
    @NotNull
    public List<? extends GotoRelatedItem> getItems(@NotNull PsiElement context) {
        GrTypeDefinition artifactClass;
        GrailsArtifact artifact;
        PsiFile containingFile;
        if (context == null) {
            GrailsGotoRelatedProvider.$$$reportNull$$$0(0);
        }
        if ((containingFile = context.getContainingFile()) == null) {
            List list = Collections.emptyList();
            if (list == null) {
                GrailsGotoRelatedProvider.$$$reportNull$$$0(1);
            }
            return list;
        }
        VirtualFile virtualFile = containingFile.getVirtualFile();
        if (virtualFile == null) {
            List list = Collections.emptyList();
            if (list == null) {
                GrailsGotoRelatedProvider.$$$reportNull$$$0(2);
            }
            return list;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)containingFile);
        if (module == null || !GrailsFramework.getInstance().hasSupport(module)) {
            List list = Collections.emptyList();
            if (list == null) {
                GrailsGotoRelatedProvider.$$$reportNull$$$0(3);
            }
            return list;
        }
        ArrayList<GotoRelatedItem> res = new ArrayList<GotoRelatedItem>();
        if (containingFile.getViewProvider() instanceof GspFileViewProvider) {
            GrailsGotoRelatedProvider.getRelatedForGsp(module, containingFile, virtualFile, res);
        } else if (containingFile instanceof GroovyFile && (artifact = GrailsArtifact.getType((PsiClass)(artifactClass = GroovyUtils.getClassDefinition((GroovyFile)((GroovyFile)containingFile))))) != null) {
            String name = artifact.getArtifactName((PsiClass)artifactClass);
            if (artifact == GrailsArtifact.CONTROLLER) {
                GrailsGotoRelatedProvider.addAll(module, name, GrailsArtifact.DOMAIN, res);
                GrailsGotoRelatedProvider.addAllRelatedView((PsiClass)artifactClass, res);
            } else if (artifact == GrailsArtifact.DOMAIN) {
                Collection<GrClassDefinition> controllers = GrailsGotoRelatedProvider.addAll(module, name, GrailsArtifact.CONTROLLER, res);
                for (GrClassDefinition controller : controllers) {
                    GrailsGotoRelatedProvider.addAllRelatedView((PsiClass)controller, res);
                }
            }
        }
        ArrayList<GotoRelatedItem> arrayList = res;
        if (arrayList == null) {
            GrailsGotoRelatedProvider.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    private static void getRelatedForGsp(@NotNull Module module, @NotNull PsiFile file, @NotNull VirtualFile gspFile, List<GotoRelatedItem> res) {
        String templateName;
        if (module == null) {
            GrailsGotoRelatedProvider.$$$reportNull$$$0(5);
        }
        if (file == null) {
            GrailsGotoRelatedProvider.$$$reportNull$$$0(6);
        }
        if (gspFile == null) {
            GrailsGotoRelatedProvider.$$$reportNull$$$0(7);
        }
        if ((templateName = GrailsUtils.getTemplateName(gspFile.getName())) != null) {
            GrailsGotoRelatedProvider.getRelatedForTemplate(file, res);
            return;
        }
        String name = GrailsUtils.getControllerNameByGsp(gspFile);
        if (name != null) {
            GrailsGotoRelatedProvider.addAll(module, name, GrailsArtifact.DOMAIN, res);
            Collection<GrClassDefinition> controllers = GrailsGotoRelatedProvider.addAll(module, name, GrailsArtifact.CONTROLLER, res);
            PsiMethod action = GrailsUtils.getControllerActions(name, module).get(gspFile.getNameWithoutExtension());
            if (action != null) {
                res.add(new GotoRelatedItem((PsiElement)GrailsUtils.toField(action), GrailsBundle.message("library.name", new Object[0])){

                    @Nullable
                    public Icon getCustomIcon() {
                        return GroovyMvcIcons.Action_method;
                    }
                });
            }
            for (GrClassDefinition controller : controllers) {
                GrailsGotoRelatedProvider.addAllRelatedView((PsiClass)controller, res);
            }
        }
    }

    private static void addAllRelatedView(@NotNull PsiClass controller, List<GotoRelatedItem> res) {
        VirtualFile gspDir;
        if (controller == null) {
            GrailsGotoRelatedProvider.$$$reportNull$$$0(8);
        }
        if ((gspDir = GrailsUtils.getControllerGspDir(controller)) == null) {
            return;
        }
        PsiManager psiManager = controller.getManager();
        for (VirtualFile child : gspDir.getChildren()) {
            PsiFile psiFile;
            FileType fileType = child.getFileType();
            if (fileType != GspFileType.GSP_FILE_TYPE && fileType != NewJspFileType.INSTANCE && fileType != JspxFileType.INSTANCE || (psiFile = psiManager.findFile(child)) == null) continue;
            res.add(new GotoRelatedItem((PsiElement)psiFile, GrailsBundle.message("view.group.title", new Object[0])));
        }
    }

    private static Collection<GrClassDefinition> addAll(Module module, String name, GrailsArtifact artifact, List<GotoRelatedItem> res) {
        Collection<GrClassDefinition> instances = artifact.getInstances(module, name);
        for (GrClassDefinition aClass : instances) {
            res.add(new GotoRelatedItem((PsiElement)aClass, GrailsBundle.message("library.name", new Object[0])));
        }
        return instances;
    }

    private static void getRelatedForTemplate(@NotNull PsiFile gspFile, List<GotoRelatedItem> res) {
        if (gspFile == null) {
            GrailsGotoRelatedProvider.$$$reportNull$$$0(9);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/grails/actions/GrailsGotoRelatedProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gspFile";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/grails/actions/GrailsGotoRelatedProvider";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getItems";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getRelatedForGsp";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addAllRelatedView";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getRelatedForTemplate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

