/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails;

import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.GrailsStaticFieldCompletionProvider;
import org.jetbrains.plugins.grails.util.GrailsArtifact;
import org.jetbrains.plugins.grails.util.GrailsUtils;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;

public class GrailsImplicitUsageProvider
implements ImplicitUsageProvider {
    private static final Set<String> DOMAIN_METHODS = ContainerUtil.immutableSet((Object[])new String[]{"beforeInsert", "beforeUpdate", "beforeDelete", "beforeValidate", "afterInsert", "afterUpdate", "afterDelete", "onLoad", "afterLoad"});

    public boolean isImplicitUsage(@NotNull PsiElement element) {
        if (element == null) {
            GrailsImplicitUsageProvider.$$$reportNull$$$0(0);
        }
        if (element instanceof GrClassDefinition) {
            if (GrailsArtifact.getType((PsiClass)element) != null) {
                return true;
            }
        } else if (element instanceof GrMember) {
            GrailsArtifact artifact;
            GrMember member = (GrMember)element;
            if (member instanceof GrField) {
                GrField field = (GrField)member;
                if (GrailsStaticFieldCompletionProvider.isGrailsField(field)) {
                    return true;
                }
                if (GrailsUtils.isGrailsPluginClass(field.getContainingClass())) {
                    return true;
                }
            }
            if ((artifact = GrailsArtifact.getType(member.getContainingClass())) != null) {
                switch (artifact) {
                    case CONTROLLER: {
                        if (!GrailsUtils.isControllerAction((PsiElement)member)) break;
                        return true;
                    }
                    case DOMAIN: {
                        if (!(member instanceof GrMethod) || !DOMAIN_METHODS.contains(member.getName())) break;
                        return true;
                    }
                    case BOOTSTRAP: {
                        String filedName;
                        if (!(member instanceof GrField) || !"init".equals(filedName = member.getName()) && !"destroy".equals(filedName)) break;
                        return true;
                    }
                    case CODEC: {
                        String filedName;
                        if (!(member instanceof GrField) || !member.hasModifierProperty("static") || !"encode".equals(filedName = member.getName()) && !"decode".equals(filedName)) break;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public boolean isImplicitRead(@NotNull PsiElement element) {
        if (element == null) {
            GrailsImplicitUsageProvider.$$$reportNull$$$0(1);
        }
        return false;
    }

    public boolean isImplicitWrite(@NotNull PsiElement element) {
        if (element == null) {
            GrailsImplicitUsageProvider.$$$reportNull$$$0(2);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "element";
        objectArray2[1] = "org/jetbrains/plugins/grails/GrailsImplicitUsageProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isImplicitUsage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isImplicitRead";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isImplicitWrite";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

