/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails;

import com.intellij.execution.filters.DefaultConsoleFiltersProvider;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.ide.browsers.OpenUrlHyperlinkInfo;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.lang.gsp.debug.GspPositionManager;
import org.jetbrains.plugins.grails.runner.util.GrailsExecutionUtils;
import org.jetbrains.plugins.grails.structure.GrailsApplicationManager;

public class GrailsConsoleFilterProvider
extends DefaultConsoleFiltersProvider {
    public Filter @NotNull [] getDefaultFilters(@NotNull Project project, @NotNull GlobalSearchScope scope) {
        if (project == null) {
            GrailsConsoleFilterProvider.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            GrailsConsoleFilterProvider.$$$reportNull$$$0(1);
        }
        Filter[] filterArray = (Filter[])ReadAction.compute(() -> {
            if (!GrailsApplicationManager.getInstance(project).hasApplications()) {
                return Filter.EMPTY_ARRAY;
            }
            return new Filter[]{new GrailsConsoleFilter(project)};
        });
        if (filterArray == null) {
            GrailsConsoleFilterProvider.$$$reportNull$$$0(2);
        }
        return filterArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/grails/GrailsConsoleFilterProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/grails/GrailsConsoleFilterProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultFilters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultFilters";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class GrailsConsoleFilter
    implements Filter {
        private static final Pattern LINK_PATTERN = Pattern.compile("https?:\\/\\/\\S+");
        private static final Pattern GROOVYC_PATTERN = Pattern.compile("(?:  \\[groovyc\\] )?(((?:/|[a-zA-Z]:[\\\\/])(?:[^\\\\/:\\*\\?\\|]+[\\\\/])*\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\.(?:groovy|java)): ?(\\d{1,8}): .*?(?:@ line \\2, column (\\d{1,8})\\.)?)\\s*");
        private static final Pattern GSP_PATTERN = Pattern.compile("\tat (\\w+_gsp)(?:\\$\\w+)?\\.\\w+\\(((?:\\1)|(\\w+\\.gsp))(?::(-?\\d+))?\\)\\s*");
        private static final Pattern GSP_2_0_PATTERN = Pattern.compile("(?:->>|\\|) *(-?\\d+) \\| [\\w_\\$]+[ \\.]*in (([\\w\\.]+)(?:\\$[\\w\\.\\$]+)?)\\s*");
        private static final Pattern GSP_COMPILATION_ERROR = Pattern.compile("(\\w+_gsp): ?(\\d{1,8}): .*?@ line \\2, column (\\d{1,8})\\.\\s*");
        private final Project myProject;

        GrailsConsoleFilter(Project project) {
            this.myProject = project;
        }

        public Filter.Result applyFilter(@NotNull String line, int entireLength) {
            int start;
            if (line == null) {
                GrailsConsoleFilter.$$$reportNull$$$0(0);
            }
            if (line.startsWith("Server running. Browse to ", start = GrailsExecutionUtils.getGrailsConsolePrefixLength(line))) {
                String url = line.substring(start + "Server running. Browse to ".length()).trim();
                if (LINK_PATTERN.matcher(url).matches()) {
                    int urlStart = entireLength - line.length() + start + "Server running. Browse to ".length();
                    return new Filter.Result(urlStart, urlStart + url.length(), (HyperlinkInfo)new OpenUrlHyperlinkInfo(url));
                }
                return null;
            }
            Matcher matcher = GROOVYC_PATTERN.matcher(line);
            if (matcher.matches()) {
                String path = matcher.group(2);
                VirtualFile file = LocalFileSystem.getInstance().findFileByPath(path);
                if (file != null) {
                    int lineNumber = Integer.parseInt(matcher.group(3)) - 1;
                    String column = matcher.group(4);
                    int columnNumber = column == null ? 0 : Integer.parseInt(column) - 1;
                    TextAttributes attr = GrailsConsoleFilter.createCompilationErrorAttr();
                    return new Filter.Result(entireLength - line.length() + matcher.start(1), entireLength - 1, (HyperlinkInfo)new OpenFileHyperlinkInfo(this.myProject, file, lineNumber, columnNumber), attr);
                }
                return null;
            }
            matcher = GSP_PATTERN.matcher(line);
            if (matcher.matches()) {
                String page = matcher.group(1);
                VirtualFile gspFile = this.getGspFile(page);
                if (gspFile != null) {
                    String fileName = matcher.group(3);
                    int lineNumber = -1;
                    if (fileName != null) {
                        lineNumber = GrailsConsoleFilter.parseLineNumber(matcher.group(4));
                    }
                    TextAttributes attr = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(CodeInsightColors.HYPERLINK_ATTRIBUTES);
                    return new Filter.Result(entireLength - line.length() + matcher.start(2), entireLength - line.length() + matcher.end(2), (HyperlinkInfo)new OpenFileHyperlinkInfo(this.myProject, gspFile, lineNumber), attr);
                }
                return null;
            }
            matcher = GSP_2_0_PATTERN.matcher(line);
            if (matcher.matches()) {
                final String className = matcher.group(3);
                VirtualFile file = this.getVirtualFileByClassName(className);
                if (file != null) {
                    final int lineNumber = GrailsConsoleFilter.parseLineNumber(matcher.group(1));
                    TextAttributes attr = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(CodeInsightColors.HYPERLINK_ATTRIBUTES);
                    return new Filter.Result(entireLength - line.length() + matcher.start(2), entireLength - line.length() + matcher.end(2), new HyperlinkInfo(){

                        public void navigate(@NotNull Project project) {
                            VirtualFile currentFile;
                            if (project == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            if ((currentFile = this.getVirtualFileByClassName(className)) != null) {
                                new OpenFileHyperlinkInfo(myProject, currentFile, lineNumber).navigate(project);
                            }
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/grails/GrailsConsoleFilterProvider$GrailsConsoleFilter$1", "navigate"));
                        }
                    }, attr);
                }
                return null;
            }
            matcher = GSP_COMPILATION_ERROR.matcher(line);
            if (matcher.matches()) {
                String gspName = matcher.group(1);
                VirtualFile file = this.getGspFile(gspName);
                if (file != null) {
                    int lineNumber = Integer.parseInt(matcher.group(2));
                    int columnNumber = Integer.parseInt(matcher.group(3));
                    TextAttributes attr = GrailsConsoleFilter.createCompilationErrorAttr();
                    return new Filter.Result(entireLength - line.length() + matcher.start(1), entireLength - line.length() + matcher.end(1), (HyperlinkInfo)new OpenFileHyperlinkInfo(this.myProject, file, lineNumber, columnNumber), attr);
                }
                return null;
            }
            return null;
        }

        @Nullable
        private VirtualFile getVirtualFileByClassName(String className) {
            PsiClass aClass;
            VirtualFile file = null;
            if (className.indexOf(46) == -1 && className.indexOf(95) != -1) {
                file = this.getGspFile(className);
            }
            if (file == null && (aClass = JavaPsiFacade.getInstance((Project)this.myProject).findClass(className, GlobalSearchScope.allScope((Project)this.myProject))) != null) {
                file = aClass.getContainingFile().getNavigationElement().getContainingFile().getVirtualFile();
            }
            return file;
        }

        private static TextAttributes createCompilationErrorAttr() {
            TextAttributes attr = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(CodeInsightColors.HYPERLINK_ATTRIBUTES).clone();
            attr.setForegroundColor((Color)JBColor.RED);
            attr.setEffectColor((Color)JBColor.RED);
            attr.setEffectType(EffectType.LINE_UNDERSCORE);
            attr.setFontType(0);
            return attr;
        }

        private static int parseLineNumber(@Nullable String sLineNumber) {
            if (sLineNumber != null) {
                try {
                    int res = Integer.parseInt(sLineNumber);
                    if (res >= 0) {
                        return res - 1;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return -1;
        }

        @Nullable
        private VirtualFile getGspFile(String page) {
            for (VirtualFile root : ProjectRootManager.getInstance((Project)this.myProject).getContentRootsFromAllModules()) {
                VirtualFile gspFile;
                String escapedRootName = GspPositionManager.ESCAPED_CHAR.matcher(root.getName()).replaceAll("_") + "_";
                int index = page.indexOf(escapedRootName);
                if (index == -1 || (gspFile = GrailsConsoleFilter.findFile(page, index + escapedRootName.length(), root)) == null) continue;
                return gspFile;
            }
            return null;
        }

        @Nullable
        private static VirtualFile findFile(String escapedPath, int startIndex, VirtualFile root) {
            for (VirtualFile child : root.getChildren()) {
                VirtualFile res;
                String name = child.getName();
                if (!GrailsConsoleFilter.startWithIgnoreEscapedLetters(escapedPath, name, startIndex)) continue;
                int newStartIndex = startIndex + name.length();
                if (newStartIndex == escapedPath.length()) {
                    return child;
                }
                if (escapedPath.charAt(newStartIndex) != '_' || (res = GrailsConsoleFilter.findFile(escapedPath, ++newStartIndex, child)) == null) continue;
                return res;
            }
            return null;
        }

        private static boolean startWithIgnoreEscapedLetters(String escapedPath, String s2, int startIndex) {
            if (s2.length() > escapedPath.length() - startIndex) {
                return false;
            }
            for (int i2 = 0; i2 < s2.length(); ++i2) {
                char a = s2.charAt(i2);
                if (!Character.isLetter(a) && !Character.isDigit(a)) {
                    a = '_';
                }
                if (escapedPath.charAt(startIndex + i2) == a) continue;
                return false;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "org/jetbrains/plugins/grails/GrailsConsoleFilterProvider$GrailsConsoleFilter", "applyFilter"));
        }
    }
}

