/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.sourcemap;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Url;
import com.intellij.util.containers.BidirectionalMap;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.sourcemap.SourceMap;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u001f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010&\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\t2\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0005J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u0006J\u000e\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\tJ\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001b\u001a\u00020\tJ\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00060\u001dJ\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0014\u001a\u00020\tJ\u0010\u0010\u001f\u001a\u0004\u0018\u00010\u00062\u0006\u0010 \u001a\u00020!J&\u0010\"\u001a\u00020\u00112\u001e\u0010#\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00060%\u0012\u0004\u0012\u00020\u00110$J\u0010\u0010&\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\tH\u0002R*\u0010\u0003\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R-\u0010\b\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\u0004j\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR*\u0010\r\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00060\u0004j\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00060\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/intellij/javascript/debugger/sourcemap/PreloadedSourceMapList;", "", "()V", "generatedFileToSourceMap", "Ljava/util/HashMap;", "Ljava/nio/file/Path;", "Lorg/jetbrains/debugger/sourcemap/SourceMap;", "Lkotlin/collections/HashMap;", "scriptUrlToRelativePath", "Lcom/intellij/util/Url;", "", "getScriptUrlToRelativePath", "()Ljava/util/HashMap;", "scriptUrlToSourceMap", "sourceMapUrlToSourceMap", "Lcom/intellij/util/containers/BidirectionalMap;", "add", "", "mapUrl", "map", "scriptUrl", "relativePath", "generatedFile", "containsMap", "", "containsScript", "get", "url", "getAllMaps", "", "getByScript", "getBySourceFile", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "process", "procedure", "Lkotlin/Function1;", "", "removeHash", "intellij.javascript.debugger"})
public final class PreloadedSourceMapList {
    private final HashMap<Url, SourceMap> scriptUrlToSourceMap = new HashMap();
    private final HashMap<Path, SourceMap> generatedFileToSourceMap = new HashMap();
    private final BidirectionalMap<Url, SourceMap> sourceMapUrlToSourceMap = new BidirectionalMap();
    @NotNull
    private final HashMap<Url, String> scriptUrlToRelativePath = new HashMap();

    @NotNull
    public final HashMap<Url, String> getScriptUrlToRelativePath() {
        return this.scriptUrlToRelativePath;
    }

    public final synchronized void add(@NotNull Url mapUrl, @NotNull SourceMap map2, @NotNull Url scriptUrl, @Nullable String relativePath, @Nullable Path generatedFile) {
        Intrinsics.checkNotNullParameter((Object)mapUrl, (String)"mapUrl");
        Intrinsics.checkNotNullParameter((Object)map2, (String)"map");
        Intrinsics.checkNotNullParameter((Object)scriptUrl, (String)"scriptUrl");
        Url mapUrlWithoutHash = this.removeHash(mapUrl);
        Url scriptUrlWithoutHash = this.removeHash(scriptUrl);
        ((Map)this.sourceMapUrlToSourceMap).put(mapUrlWithoutHash, map2);
        ((Map)this.scriptUrlToSourceMap).put(scriptUrlWithoutHash, map2);
        if (relativePath != null) {
            ((Map)this.scriptUrlToRelativePath).put(scriptUrlWithoutHash, relativePath);
        }
        if (generatedFile != null) {
            ((Map)this.generatedFileToSourceMap).put(generatedFile, map2);
        }
    }

    public static /* synthetic */ void add$default(PreloadedSourceMapList preloadedSourceMapList, Url url, SourceMap sourceMap, Url url2, String string, Path path, int n, Object object) {
        if ((n & 8) != 0) {
            string = null;
        }
        if ((n & 0x10) != 0) {
            path = null;
        }
        preloadedSourceMapList.add(url, sourceMap, url2, string, path);
    }

    @Nullable
    public final synchronized SourceMap get(@NotNull Url url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return (SourceMap)this.sourceMapUrlToSourceMap.get((Object)this.removeHash(url));
    }

    @Nullable
    public final synchronized SourceMap getByScript(@NotNull Url scriptUrl) {
        Intrinsics.checkNotNullParameter((Object)scriptUrl, (String)"scriptUrl");
        return this.scriptUrlToSourceMap.get(this.removeHash(scriptUrl));
    }

    @Nullable
    public final synchronized SourceMap getBySourceFile(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return this.generatedFileToSourceMap.get(VfsUtilCore.virtualToIoFile((VirtualFile)file2).toPath());
    }

    public final synchronized boolean containsMap(@NotNull SourceMap map2) {
        Intrinsics.checkNotNullParameter((Object)map2, (String)"map");
        return this.sourceMapUrlToSourceMap.containsValue((Object)map2);
    }

    public final synchronized boolean containsScript(@NotNull Url scriptUrl) {
        Intrinsics.checkNotNullParameter((Object)scriptUrl, (String)"scriptUrl");
        return this.scriptUrlToSourceMap.containsKey(this.removeHash(scriptUrl));
    }

    public final synchronized void process(@NotNull Function1<? super Map.Entry<? extends Url, ? extends SourceMap>, Unit> procedure) {
        Intrinsics.checkNotNullParameter(procedure, (String)"procedure");
        Map $this$forEach$iv = this.scriptUrlToSourceMap;
        boolean $i$f$forEach = false;
        Map map2 = $this$forEach$iv;
        boolean bl = false;
        for (Map.Entry element$iv : map2.entrySet()) {
            procedure.invoke(element$iv);
        }
    }

    @NotNull
    public final synchronized Collection<SourceMap> getAllMaps() {
        Collection<SourceMap> collection = this.scriptUrlToSourceMap.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"scriptUrlToSourceMap.values");
        return collection;
    }

    private final Url removeHash(Url url) {
        Url url2 = url.removeParameter("hash");
        Intrinsics.checkNotNullExpressionValue((Object)url2, (String)"url.removeParameter(\"hash\")");
        Url resultUrl = url2;
        String parameters = resultUrl.getParameters();
        if (parameters != null && parameters.length() > 8 && parameters.charAt(0) == '?') {
            boolean bl;
            block3: {
                String string = parameters;
                int n = 1;
                boolean bl2 = false;
                String string2 = string.substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
                CharSequence $this$all$iv = string2;
                boolean $i$f$all = false;
                CharSequence charSequence = $this$all$iv;
                for (int i = 0; i < charSequence.length(); ++i) {
                    char element$iv;
                    char p1 = element$iv = charSequence.charAt(i);
                    boolean bl3 = false;
                    if (StringUtil.isHexDigit((char)p1)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
            if (bl) {
                Url url3 = resultUrl.trimParameters();
                Intrinsics.checkNotNullExpressionValue((Object)url3, (String)"resultUrl.trimParameters()");
                return url3;
            }
        }
        return resultUrl;
    }
}

