/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.nashorn;

import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.javascript.debugger.nashorn.NashornObject;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.SmartList;
import com.jetbrains.debugger.jdi.JdiValueManager;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class NashornDebuggerSupportWrapper {
    private static final Logger LOG = Logger.getInstance(NashornObject.class);
    private static final Key<NashornDebuggerSupportWrapper> DEBUGGER_SUPPORT = Key.create((String)"nashornDebuggerSupport");
    private final ClassType classType;
    private final Method getPropertiesMethod;
    private final Method getIndexedValuesMethod;
    private Field nameField;
    private Field typeField;
    private Field vmValueField;
    private Field stringValueField;
    private Field lengthField;
    private Field indexField;
    private final List<? extends Field> fields;
    private final Method evaluateMethod;

    NashornDebuggerSupportWrapper(@NotNull ClassType classType, @NotNull List<? extends Field> fields) {
        if (classType == null) {
            NashornDebuggerSupportWrapper.$$$reportNull$$$0(0);
        }
        if (fields == null) {
            NashornDebuggerSupportWrapper.$$$reportNull$$$0(1);
        }
        this.classType = classType;
        this.getPropertiesMethod = DebuggerUtils.findMethod((ReferenceType)classType, (String)"getProperties", (String)"(Ljava/lang/Object;)[Lorg/jetbrains/nashorn/NashornDebuggerSupport$VariableDescriptor;");
        this.getIndexedValuesMethod = DebuggerUtils.findMethod((ReferenceType)classType, (String)"getIndexedValues", (String)"(Ljava/lang/Object;II)[Lorg/jetbrains/nashorn/NashornDebuggerSupport$VariableDescriptor;");
        this.fields = fields;
        for (Field field : fields) {
            String name = field.name();
            if (name.equals("name")) {
                this.nameField = field;
                continue;
            }
            if (name.equals("type")) {
                this.typeField = field;
                continue;
            }
            if (name.equals("value")) {
                this.vmValueField = field;
                continue;
            }
            if (name.equals("stringValue")) {
                this.stringValueField = field;
                continue;
            }
            if (name.equals("length")) {
                this.lengthField = field;
                continue;
            }
            if (!name.equals("index")) continue;
            this.indexField = field;
        }
        this.evaluateMethod = DebuggerUtils.findMethod((ReferenceType)classType, (String)"evaluate", (String)"(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)Lorg/jetbrains/nashorn/NashornDebuggerSupport$VariableDescriptor;");
        LOG.assertTrue(this.evaluateMethod != null);
        LOG.assertTrue(this.getPropertiesMethod != null);
        LOG.assertTrue(this.getIndexedValuesMethod != null);
    }

    private static Value mirrorOf(@NotNull URL value, @NotNull ThreadReference threadReference) throws Exception {
        if (value == null) {
            NashornDebuggerSupportWrapper.$$$reportNull$$$0(2);
        }
        if (threadReference == null) {
            NashornDebuggerSupportWrapper.$$$reportNull$$$0(3);
        }
        String typeName = value.getClass().getCanonicalName();
        ClassType type = (ClassType)threadReference.virtualMachine().classesByName(typeName).get(0);
        ArrayList<StringReference> args = new ArrayList<StringReference>();
        args.add(threadReference.virtualMachine().mirrorOf(value.toString()));
        return type.newInstance(threadReference, DebuggerUtils.findMethod((ReferenceType)type, (String)"<init>", (String)"(Ljava/lang/String;)V"), args, 1);
    }

    private static ObjectReference mirrorOf(URL @NotNull [] value, @NotNull ThreadReference threadReference, @NotNull EvaluationContext evaluationContext) throws Exception {
        if (threadReference == null) {
            NashornDebuggerSupportWrapper.$$$reportNull$$$0(4);
        }
        if (evaluationContext == null) {
            NashornDebuggerSupportWrapper.$$$reportNull$$$0(5);
        }
        if (value == null) {
            NashornDebuggerSupportWrapper.$$$reportNull$$$0(6);
        }
        int l = value.length;
        String typeName = value.getClass().getCanonicalName();
        ArrayType arrayType = (ArrayType)evaluationContext.getDebugProcess().findClass(evaluationContext, typeName, null);
        ArrayReference reference = arrayType.newInstance(l);
        int length = value.length;
        for (int i = 0; i < length; ++i) {
            URL url = value[i];
            reference.setValue(i, NashornDebuggerSupportWrapper.mirrorOf(url, threadReference));
        }
        return reference;
    }

    private static ReferenceType getClass(@NotNull ThreadReference threadReference, @NotNull String name, ClassLoaderReference classLoader) throws Exception {
        if (threadReference == null) {
            NashornDebuggerSupportWrapper.$$$reportNull$$$0(7);
        }
        if (name == null) {
            NashornDebuggerSupportWrapper.$$$reportNull$$$0(8);
        }
        ReferenceType refType = null;
        VirtualMachine virtualMachine = threadReference.virtualMachine();
        ClassType classClassType = (ClassType)virtualMachine.classesByName("java.lang.Class").get(0);
        Method forNameMethod = DebuggerUtils.findMethod((ReferenceType)classClassType, (String)"forName", (String)"(Ljava/lang/String;ZLjava/lang/ClassLoader;)Ljava/lang/Class;");
        ArrayList<Value> args = new ArrayList<Value>();
        args.add(virtualMachine.mirrorOf(name));
        args.add(virtualMachine.mirrorOf(true));
        args.add(classLoader);
        Value value = classClassType.invokeMethod(threadReference, forNameMethod, args, 1);
        if (value instanceof ClassObjectReference) {
            refType = ((ClassObjectReference)value).reflectedType();
        }
        return refType;
    }

    static NashornDebuggerSupportWrapper get(@NotNull ThreadReference threadReference, @NotNull JdiValueManager valueManager, @NotNull EvaluationContext evaluationContext) throws Exception {
        NashornDebuggerSupportWrapper wrapper;
        if (threadReference == null) {
            NashornDebuggerSupportWrapper.$$$reportNull$$$0(9);
        }
        if (valueManager == null) {
            NashornDebuggerSupportWrapper.$$$reportNull$$$0(10);
        }
        if (evaluationContext == null) {
            NashornDebuggerSupportWrapper.$$$reportNull$$$0(11);
        }
        if ((wrapper = (NashornDebuggerSupportWrapper)DEBUGGER_SUPPORT.get((UserDataHolder)valueManager.getProcessLevelCache())) == null) {
            File file2;
            Sdk jre;
            DebugProcess debugProcess = evaluationContext.getDebugProcess();
            ClassType urlClassLoaderClass = (ClassType)debugProcess.findClass(evaluationContext, "java.net.URLClassLoader", null);
            String jarName = "nashorn-debugger-rt.jar";
            if (debugProcess instanceof DebugProcessImpl && (jre = ((DebugProcessImpl)debugProcess).getSession().getRunJre()) != null && jre.getSdkType() instanceof JavaSdkType && JavaSdk.getInstance().isOfVersionOrHigher(jre, JavaSdkVersion.JDK_1_9)) {
                jarName = "nashorn-debugger-9-rt.jar";
            }
            if (!(file2 = new File(PathManager.getPreInstalledPluginsPath(), FileUtil.toSystemDependentName((String)("JavaScriptDebugger/lib/" + jarName)))).exists()) {
                file2 = new File(PathManager.getPreInstalledPluginsPath(), FileUtil.toSystemDependentName((String)("JavaScriptDebugger/nashorn/debugger-support/" + jarName)));
                LOG.assertTrue(file2.exists());
            }
            SmartList args = new SmartList();
            args.add(NashornDebuggerSupportWrapper.mirrorOf(new URL[]{file2.toURI().toURL()}, threadReference, evaluationContext));
            Method ctorMethod = DebuggerUtils.findMethod((ReferenceType)urlClassLoaderClass, (String)"<init>", (String)"([Ljava/net/URL;)V");
            ClassLoaderReference classLoader = (ClassLoaderReference)urlClassLoaderClass.newInstance(threadReference, ctorMethod, (List<? extends Value>)args, 1);
            wrapper = new NashornDebuggerSupportWrapper((ClassType)NashornDebuggerSupportWrapper.getClass(threadReference, "org.jetbrains.nashorn.NashornDebuggerSupport", classLoader), NashornDebuggerSupportWrapper.getClass(threadReference, "org.jetbrains.nashorn.NashornDebuggerSupport$VariableDescriptor", classLoader).fields());
            DEBUGGER_SUPPORT.set((UserDataHolder)valueManager.getProcessLevelCache(), (Object)wrapper);
        }
        return wrapper;
    }

    @NotNull
    public ArrayReference getProperties(@NotNull ObjectReference parent, @NotNull ThreadReference threadReference) throws InvocationException, InvalidTypeException, ClassNotLoadedException, IncompatibleThreadStateException {
        if (parent == null) {
            NashornDebuggerSupportWrapper.$$$reportNull$$$0(12);
        }
        if (threadReference == null) {
            NashornDebuggerSupportWrapper.$$$reportNull$$$0(13);
        }
        SmartList args = new SmartList();
        args.add(parent);
        ArrayReference arrayReference = (ArrayReference)this.classType.invokeMethod(threadReference, this.getPropertiesMethod, (List<? extends Value>)args, 0);
        if (arrayReference == null) {
            NashornDebuggerSupportWrapper.$$$reportNull$$$0(14);
        }
        return arrayReference;
    }

    @NotNull
    public ArrayReference getIndexedValues(@NotNull ObjectReference parent, @NotNull ThreadReference threadReference, int index, int length) throws InvocationException, InvalidTypeException, ClassNotLoadedException, IncompatibleThreadStateException {
        if (parent == null) {
            NashornDebuggerSupportWrapper.$$$reportNull$$$0(15);
        }
        if (threadReference == null) {
            NashornDebuggerSupportWrapper.$$$reportNull$$$0(16);
        }
        ArrayList<Value> args = new ArrayList<Value>();
        args.add(parent);
        args.add(threadReference.virtualMachine().mirrorOf(index));
        args.add(threadReference.virtualMachine().mirrorOf(length));
        ArrayReference arrayReference = (ArrayReference)this.classType.invokeMethod(threadReference, this.getIndexedValuesMethod, args, 0);
        if (arrayReference == null) {
            NashornDebuggerSupportWrapper.$$$reportNull$$$0(17);
        }
        return arrayReference;
    }

    @NotNull
    public String getName(@NotNull Map<Field, Value> fieldToValue) {
        if (fieldToValue == null) {
            NashornDebuggerSupportWrapper.$$$reportNull$$$0(18);
        }
        String string = ((StringReference)fieldToValue.get(this.nameField)).value();
        if (string == null) {
            NashornDebuggerSupportWrapper.$$$reportNull$$$0(19);
        }
        return string;
    }

    public int getType(@NotNull Map<Field, Value> fieldToValue) {
        if (fieldToValue == null) {
            NashornDebuggerSupportWrapper.$$$reportNull$$$0(20);
        }
        return ((IntegerValue)fieldToValue.get(this.typeField)).value();
    }

    @NotNull
    public ObjectReference getValue(@NotNull Map<Field, Value> fieldToValue) {
        if (fieldToValue == null) {
            NashornDebuggerSupportWrapper.$$$reportNull$$$0(21);
        }
        ObjectReference objectReference = (ObjectReference)fieldToValue.get(this.vmValueField);
        if (objectReference == null) {
            NashornDebuggerSupportWrapper.$$$reportNull$$$0(22);
        }
        return objectReference;
    }

    public String getStringValue(@NotNull Map<Field, Value> fieldToValue) {
        if (fieldToValue == null) {
            NashornDebuggerSupportWrapper.$$$reportNull$$$0(23);
        }
        return ((StringReference)fieldToValue.get(this.stringValueField)).value();
    }

    public int getLength(@NotNull Map<Field, Value> fieldToValue) {
        if (fieldToValue == null) {
            NashornDebuggerSupportWrapper.$$$reportNull$$$0(24);
        }
        return ((IntegerValue)fieldToValue.get(this.lengthField)).value();
    }

    public int getIndex(@NotNull Map<Field, Value> fieldToValue) {
        if (fieldToValue == null) {
            NashornDebuggerSupportWrapper.$$$reportNull$$$0(25);
        }
        return ((IntegerValue)fieldToValue.get(this.indexField)).value();
    }

    @NotNull
    public ObjectReference evaluate(@NotNull String expression, @Nullable ObjectReference scope, @Nullable ObjectReference self, @NotNull EvaluationContext context) throws Exception {
        if (expression == null) {
            NashornDebuggerSupportWrapper.$$$reportNull$$$0(26);
        }
        if (context == null) {
            NashornDebuggerSupportWrapper.$$$reportNull$$$0(27);
        }
        ArrayList<ObjectReference> args = new ArrayList<ObjectReference>();
        args.add(context.getSuspendContext().getThread().getThreadReference().virtualMachine().mirrorOf(expression));
        args.add(scope);
        args.add(self);
        ObjectReference objectReference = (ObjectReference)((DebugProcessImpl)context.getDebugProcess()).invokeMethod(context, this.classType, this.evaluateMethod, args, true);
        if (objectReference == null) {
            NashornDebuggerSupportWrapper.$$$reportNull$$$0(28);
        }
        return objectReference;
    }

    @NotNull
    public Map<Field, Value> getValues(@NotNull ObjectReference objectDescriptor) {
        if (objectDescriptor == null) {
            NashornDebuggerSupportWrapper.$$$reportNull$$$0(29);
        }
        Map<Field, Value> map2 = objectDescriptor.getValues(this.fields);
        if (map2 == null) {
            NashornDebuggerSupportWrapper.$$$reportNull$$$0(30);
        }
        return map2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: 
            case 17: 
            case 19: 
            case 22: 
            case 28: 
            case 30: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: 
            case 17: 
            case 19: 
            case 22: 
            case 28: 
            case 30: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fields";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threadReference";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluationContext";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueManager";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 14: 
            case 17: 
            case 19: 
            case 22: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/debugger/nashorn/NashornDebuggerSupportWrapper";
                break;
            }
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldToValue";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objectDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/debugger/nashorn/NashornDebuggerSupportWrapper";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexedValues";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getValue";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluate";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getValues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "mirrorOf";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getClass";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getProperties";
                break;
            }
            case 14: 
            case 17: 
            case 19: 
            case 22: 
            case 28: 
            case 30: {
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getIndexedValues";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getName";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getValue";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getStringValue";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getLength";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getIndex";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "evaluate";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getValues";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: 
            case 17: 
            case 19: 
            case 22: 
            case 28: 
            case 30: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

