/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.console;

import com.intellij.execution.console.BasicGutterContentProvider;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.JavaScriptDebugProcessKt;
import com.intellij.javascript.debugger.JsFileUtil;
import com.intellij.javascript.debugger.SegmentList;
import com.intellij.javascript.debugger.console.Annotation;
import com.intellij.javascript.debugger.console.ConsolePrinter;
import com.intellij.javascript.debugger.console.LineAnnotation;
import com.intellij.javascript.debugger.console.LineAnnotationMaps;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.ui.JBColor;
import com.intellij.util.Url;
import com.intellij.xdebugger.XDebugSession;
import java.awt.Color;
import java.awt.Graphics;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B!\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\r\u0010\u001d\u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\b\u001eJ \u0010\u001f\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J(\u0010#\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010'\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\"\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010*\u001a\u00020\u0007H\u0003J\u001a\u0010+\u001a\u0004\u0018\u00010)2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u001a\u0010,\u001a\u0004\u0018\u00010)2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010-\u001a\u00020\u0007H\u0016J\u000e\u0010.\u001a\u00020\u00182\u0006\u0010/\u001a\u000200R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0014X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u00061"}, d2={"Lcom/intellij/javascript/debugger/console/EditorConsoleGutterProvider;", "Lcom/intellij/execution/console/BasicGutterContentProvider;", "debugProcess", "Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "printer", "Lcom/intellij/javascript/debugger/console/ConsolePrinter;", "isLineRelationshipComputable", "", "(Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;Lcom/intellij/javascript/debugger/console/ConsolePrinter;Z)V", "getDebugProcess", "()Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "lineToAnnotation", "Lcom/intellij/javascript/debugger/console/LineAnnotationMaps;", "getLineToAnnotation$intellij_javascript_debugger", "()Lcom/intellij/javascript/debugger/console/LineAnnotationMaps;", "lock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "getLock", "()Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "relatedLines", "Lcom/intellij/javascript/debugger/SegmentList;", "getRelatedLines$intellij_javascript_debugger", "()Lcom/intellij/javascript/debugger/SegmentList;", "doAction", "", "line", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "doClear", "doClear$intellij_javascript_debugger", "doIsShowSeparatorLine", "document", "Lcom/intellij/openapi/editor/Document;", "documentCleared", "drawIcon", "g", "Ljava/awt/Graphics;", "y", "getLineStartGutterOverlap", "getStringInfo", "", "toolTip", "getText", "getToolTip", "hasText", "increaseLastMessageRepeatCount", "consoleView", "Lcom/intellij/execution/impl/ConsoleViewImpl;", "intellij.javascript.debugger"})
public final class EditorConsoleGutterProvider
extends BasicGutterContentProvider {
    @NotNull
    private final LineAnnotationMaps lineToAnnotation;
    @NotNull
    private final SegmentList relatedLines;
    @NotNull
    private final ReentrantReadWriteLock lock;
    @NotNull
    private final JavaScriptDebugProcess<?> debugProcess;

    @NotNull
    public final LineAnnotationMaps getLineToAnnotation$intellij_javascript_debugger() {
        return this.lineToAnnotation;
    }

    @NotNull
    public final SegmentList getRelatedLines$intellij_javascript_debugger() {
        return this.relatedLines;
    }

    @NotNull
    public final ReentrantReadWriteLock getLock() {
        return this.lock;
    }

    public final void doClear$intellij_javascript_debugger() {
        this.lineToAnnotation.clear();
        this.relatedLines.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void documentCleared(@NotNull Editor editor) {
        int n;
        int n2;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n3 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        boolean bl3 = false;
        int n4 = 0;
        n4 = 0;
        int n5 = n3;
        while (n4 < n5) {
            n2 = n4++;
            n = 0;
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl4 = false;
            this.doClear$intellij_javascript_debugger();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            n5 = 0;
            n2 = 0;
            n2 = 0;
            n = n3;
            while (n2 < n) {
                int n6 = n2++;
                boolean bl5 = false;
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    public final void increaseLastMessageRepeatCount(@NotNull ConsoleViewImpl consoleView) {
        Intrinsics.checkNotNullParameter((Object)consoleView, (String)"consoleView");
        JavaScriptDebugProcessKt.getLOG().assertTrue(this.lock.isWriteLockedByCurrentThread());
        Pair<Integer, LineAnnotation> annotation = this.lineToAnnotation.getLast();
        if (annotation == null) {
            return;
        }
        LineAnnotation lineAnnotation = (LineAnnotation)annotation.getSecond();
        lineAnnotation.setRepeatCount(lineAnnotation.getRepeatCount() + 1);
        int shownRepeatCount = lineAnnotation.getRepeatCount() + 1;
        if (shownRepeatCount < 10) {
            return;
        }
        int newRepeatCountLength = Integer.toString(shownRepeatCount).length();
        if (newRepeatCountLength <= Integer.toString(shownRepeatCount - 1).length()) {
            return;
        }
        int excess = newRepeatCountLength + 1 - 2;
        boolean bl = excess > 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        int version = this.lineToAnnotation.getVersion();
        int consoleOffset = ((Number)annotation.getFirst()).intValue();
        ApplicationManager.getApplication().invokeLater(new Runnable(this, version, consoleView, consoleOffset, excess){
            final /* synthetic */ EditorConsoleGutterProvider this$0;
            final /* synthetic */ int $version;
            final /* synthetic */ ConsoleViewImpl $consoleView;
            final /* synthetic */ int $consoleOffset;
            final /* synthetic */ int $excess;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void run() {
                ReentrantReadWriteLock.WriteLock writeLock = this.this$0.getLock().writeLock();
                if (writeLock.tryLock(50L, TimeUnit.MILLISECONDS)) {
                    try {
                        if (this.$version != this.this$0.getLineToAnnotation$intellij_javascript_debugger().getVersion()) {
                            return;
                        }
                        this.$consoleView.flushDeferredText();
                        Editor editor = this.$consoleView.getEditor();
                        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"consoleView.editor");
                        Document document = editor.getDocument();
                        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"consoleView.editor.document");
                        Document document2 = document;
                        int lineNumber = document2.getLineNumber(this.$consoleOffset);
                        int lineStartOffset = document2.getLineStartOffset(lineNumber);
                        int missed = this.$excess - StringUtil.countChars((CharSequence)document2.getImmutableCharSequence(), (char)' ', (int)lineStartOffset, (boolean)true);
                        if (missed <= 0) return;
                        document2.insertString(lineStartOffset, (CharSequence)StringUtil.repeat((String)" ", (int)missed));
                        return;
                    }
                    catch (Exception exception) {
                        return;
                    }
                    finally {
                        writeLock.unlock();
                    }
                } else {
                    ApplicationManager.getApplication().invokeLater((Runnable)this);
                }
            }
            {
                this.this$0 = this$0;
                this.$version = $captured_local_variable$1;
                this.$consoleView = $captured_local_variable$2;
                this.$consoleOffset = $captured_local_variable$3;
                this.$excess = $captured_local_variable$4;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasText() {
        boolean bl;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        boolean bl2 = false;
        boolean bl3 = false;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            boolean bl4 = false;
            bl = !this.lineToAnnotation.isEmpty();
        }
        finally {
            readLock.unlock();
        }
        return bl;
    }

    @Nullable
    public String getText(int line, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return this.getStringInfo(line, editor, false);
    }

    @Nullable
    public String getToolTip(int line, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return this.getStringInfo(line, editor, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NlsSafe
    private final String getStringInfo(int line, Editor editor, boolean toolTip) {
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            boolean bl3 = false;
            Object object = this.lineToAnnotation.get(line, editor);
            if (object == null || (object = ((LineAnnotation)object).getAnno()) == null) {
                String string = null;
                return string;
            }
            Object annotation = object;
            String name = null;
            VirtualFile file2 = ((Annotation)annotation).getFile();
            if (toolTip) {
                if (((Annotation)annotation).getUrl() != null) {
                    String string = ((Annotation)annotation).getUrl().trimParameters().toDecodedForm();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"annotation.url.trimParameters().toDecodedForm()");
                    name = string;
                } else {
                    VirtualFile virtualFile = file2;
                    Intrinsics.checkNotNull((Object)virtualFile);
                    XDebugSession xDebugSession = this.debugProcess.getSession();
                    Intrinsics.checkNotNullExpressionValue((Object)xDebugSession, (String)"debugProcess.session");
                    String string = JsFileUtil.getShortenedFilePath(virtualFile, xDebugSession.getProject());
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"JsFileUtil.getShortenedF\u2026gProcess.session.project)");
                    name = string;
                }
            } else {
                if (((Annotation)annotation).getUrl() == null) {
                    boolean bl4 = file2 != null;
                    boolean bl5 = false;
                    boolean bl6 = false;
                    if (_Assertions.ENABLED && !bl4) {
                        boolean bl7 = false;
                        String string = "Assertion failed";
                        throw (Throwable)((Object)new AssertionError((Object)string));
                    }
                    VirtualFile virtualFile = file2;
                    Intrinsics.checkNotNull((Object)virtualFile);
                    String string = virtualFile.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file!!.name");
                    name = string;
                } else {
                    String string = ((Annotation)annotation).getUrl().trimParameters().toDecodedForm();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"annotation.url.trimParameters().toDecodedForm()");
                    name = string;
                }
                String string = StringUtil.trimMiddle((String)name, (int)100);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringUtil.trimMiddle(name, 100)");
                name = string;
            }
            String string = ((Annotation)annotation).getLine() < 0 ? name : name + ':' + (((Annotation)annotation).getLine() + 1);
            return string;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAction(int line, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Annotation currentAnnotation = null;
        VirtualFile newFile = null;
        RangeMarker newPosition = null;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            Annotation annotation;
            boolean bl3 = false;
            LineAnnotation lineAnnotation = this.lineToAnnotation.get(line, editor);
            currentAnnotation = annotation = lineAnnotation != null ? lineAnnotation.getAnno() : null;
            if (annotation != null) {
                VirtualFile file2 = annotation.getFile();
                if (file2 == null) {
                    Url url = annotation.getUrl();
                    Intrinsics.checkNotNull((Object)url);
                    file2 = this.debugProcess.findFileOrAny(url);
                    if (file2 == null) {
                        this.debugProcess.getSession().reportError(JSDebuggerBundle.message("console.editor.notification.error.cannot.navigate", new Object[0]));
                        return;
                    }
                    newFile = file2;
                }
                Navigatable descriptor = null;
                if (annotation.getPosition() == null || annotation.getLine() < 0) {
                    XDebugSession xDebugSession = this.debugProcess.getSession();
                    Intrinsics.checkNotNullExpressionValue((Object)xDebugSession, (String)"debugProcess.session");
                    OpenFileDescriptor ofd = new OpenFileDescriptor(xDebugSession.getProject(), file2, annotation.getLine(), annotation.getColumn());
                    descriptor = (Navigatable)ofd;
                    newPosition = ofd.getRangeMarker();
                } else {
                    PsiNavigationSupport psiNavigationSupport = PsiNavigationSupport.getInstance();
                    XDebugSession xDebugSession = this.debugProcess.getSession();
                    Intrinsics.checkNotNullExpressionValue((Object)xDebugSession, (String)"debugProcess.session");
                    Project project = xDebugSession.getProject();
                    RangeMarker rangeMarker = annotation.getPosition();
                    Intrinsics.checkNotNull((Object)rangeMarker);
                    Navigatable navigatable = psiNavigationSupport.createNavigatable(project, file2, rangeMarker.getStartOffset());
                    Intrinsics.checkNotNullExpressionValue((Object)navigatable, (String)"PsiNavigationSupport.get\u2026n.position!!.startOffset)");
                    descriptor = navigatable;
                }
                descriptor.navigate(true);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            readLock.unlock();
        }
        if (newFile != null || newPosition != null) {
            int n;
            reentrantReadWriteLock = this.lock;
            bl = false;
            boolean bl4 = false;
            ReentrantReadWriteLock.ReadLock readLock2 = reentrantReadWriteLock.readLock();
            int n2 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
            boolean bl5 = false;
            int n3 = 0;
            n3 = 0;
            int n4 = n2;
            while (n3 < n4) {
                int n5 = n3++;
                n = 0;
                readLock2.unlock();
            }
            ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
            writeLock.lock();
            try {
                Annotation anno;
                boolean bl6 = false;
                LineAnnotation lineAnnotation = this.lineToAnnotation.get(line, editor);
                Annotation annotation = anno = lineAnnotation != null ? lineAnnotation.getAnno() : null;
                if (anno != null && Intrinsics.areEqual((Object)anno, (Object)currentAnnotation)) {
                    if (newFile != null) {
                        anno.setFile(newFile);
                    }
                    if (newPosition != null) {
                        anno.setPosition(newPosition);
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                n4 = 0;
                int n6 = 0;
                n6 = 0;
                n = n2;
                while (n6 < n) {
                    int n7 = n6++;
                    boolean bl7 = false;
                    readLock2.lock();
                }
                writeLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean drawIcon(int line, @NotNull Graphics g, int y, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            boolean bl3 = false;
            if (super.drawIcon(line, g, y, editor)) {
                boolean bl4 = true;
                return bl4;
            }
            LineAnnotation annotation = this.lineToAnnotation.get(line, editor);
            if (annotation == null || annotation.getRepeatCount() <= 0) {
                boolean bl5 = false;
                return bl5;
            }
            String text = String.valueOf(annotation.getRepeatCount() + 1);
            g.setColor((Color)JBColor.LIGHT_GRAY);
            g.drawString(text, 3, y);
            boolean bl6 = true;
            return bl6;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doIsShowSeparatorLine(int line, @NotNull Editor editor, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        int lineStartOffset = document.getLineStartOffset(line);
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            boolean bl3 = false;
            int rangeIndex = this.relatedLines.getRangeIndex(lineStartOffset);
            if (rangeIndex != -1) {
                boolean bl4 = !this.relatedLines.rangeContains(rangeIndex, document.getLineStartOffset(line + 1));
                return bl4;
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            readLock.unlock();
        }
        return this.isLineRelationshipComputable;
    }

    public int getLineStartGutterOverlap(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return EditorUtil.getSpaceWidth((int)0, (Editor)editor) * 3;
    }

    @NotNull
    public final JavaScriptDebugProcess<?> getDebugProcess() {
        return this.debugProcess;
    }

    public EditorConsoleGutterProvider(@NotNull JavaScriptDebugProcess<?> debugProcess, @NotNull ConsolePrinter printer, boolean isLineRelationshipComputable) {
        Intrinsics.checkNotNullParameter(debugProcess, (String)"debugProcess");
        Intrinsics.checkNotNullParameter((Object)printer, (String)"printer");
        super(isLineRelationshipComputable);
        this.debugProcess = debugProcess;
        this.lineToAnnotation = new LineAnnotationMaps();
        this.relatedLines = new SegmentList();
        this.lock = printer.getLock$intellij_javascript_debugger();
    }
}

