/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dynamicPlugins.performanceTesting;

import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.DynamicPlugins;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginDependency;
import com.intellij.ide.plugins.PluginEnabler;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class UnloadDynamicPluginCommand
extends AbstractCommand {
    public static final String PREFIX = "%unloadDynamicPlugin";
    private static final Logger LOG = Logger.getInstance(UnloadDynamicPluginCommand.class);

    public UnloadDynamicPluginCommand(@NotNull String text, int line) {
        if (text == null) {
            UnloadDynamicPluginCommand.$$$reportNull$$$0(0);
        }
        super(text, line);
    }

    protected Promise<Object> _execute(PlaybackContext context) {
        ActionCallbackProfilerStopper actionCallback = new ActionCallbackProfilerStopper();
        PluginId pluginId = PluginId.getId((String)this.getText().substring(PREFIX.length()).trim());
        final IdeaPluginDescriptorImpl pluginDescriptor = (IdeaPluginDescriptorImpl)Objects.requireNonNull(PluginManagerCore.getPlugin((PluginId)pluginId));
        final Project project = context.getProject();
        DumbService.getInstance((Project)project).waitForSmartMode();
        if (PluginEnabler.HEADLESS.isDisabled(pluginId)) {
            actionCallback.reject("Plugin " + this.getText().substring(PREFIX.length()).trim() + " is disabled. Unload can not be performed");
            return Promises.toPromise((ActionCallback)actionCallback);
        }
        for (IdeaPluginDescriptor loadedPlugin : PluginManagerCore.getLoadedPlugins()) {
            if (loadedPlugin.getPluginId().equals((Object)pluginId)) continue;
            List dependencies = ((IdeaPluginDescriptorImpl)loadedPlugin).pluginDependencies;
            for (PluginDependency dependency : dependencies) {
                if (dependency.isOptional() || !dependency.getPluginId().equals((Object)pluginId)) continue;
                actionCallback.reject("Plugin " + this.getText().substring(PREFIX.length()).trim() + " can't be unloaded because it's a non-optional dependency of " + loadedPlugin.getPluginId());
                return Promises.toPromise((ActionCallback)actionCallback);
            }
        }
        if (DynamicPlugins.allowLoadUnloadWithoutRestart((IdeaPluginDescriptorImpl)pluginDescriptor)) {
            pluginDescriptor.setEnabled(false);
            final MessageBusConnection appConnection = ApplicationManager.getApplication().getMessageBus().connect();
            appConnection.subscribe(DynamicPluginListener.TOPIC, (Object)new DynamicPluginListener((ActionCallback)actionCallback){
                final /* synthetic */ ActionCallback val$actionCallback;
                {
                    this.val$actionCallback = actionCallback;
                }

                public void pluginUnloaded(@NotNull IdeaPluginDescriptor descriptor, boolean isUpdate) {
                    if (descriptor == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (descriptor.equals(pluginDescriptor)) {
                        final MessageBusConnection projectConnection = project.getMessageBus().connect();
                        projectConnection.subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

                            public void exitDumbMode() {
                                appConnection.disconnect();
                                projectConnection.disconnect();
                                val$actionCallback.setDone();
                            }
                        });
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/dynamicPlugins/performanceTesting/UnloadDynamicPluginCommand$1", "pluginUnloaded"));
                }
            });
            ApplicationManager.getApplication().invokeLater(() -> this.lambda$_execute$0(pluginDescriptor, (ActionCallback)actionCallback));
        } else {
            actionCallback.reject("Plugin " + this.getText().substring(PREFIX.length()).trim() + " is not dynamic");
        }
        return Promises.toPromise((ActionCallback)actionCallback);
    }

    private /* synthetic */ void lambda$_execute$0(IdeaPluginDescriptorImpl pluginDescriptor, ActionCallback actionCallback) {
        IdeEventQueue.getInstance().flushQueue();
        boolean pluginUnloaded = DynamicPlugins.unloadPlugin((IdeaPluginDescriptorImpl)pluginDescriptor, (DynamicPlugins.UnloadPluginOptions)new DynamicPlugins.UnloadPluginOptions().withDisable(true).withRequireMemorySnapshot(true));
        if (!pluginUnloaded) {
            actionCallback.reject("Plugin " + this.getText().substring(PREFIX.length()).trim() + " was not unloaded");
        } else {
            LOG.info("Plugin " + this.getText().substring(PREFIX.length()).trim() + " was unloaded");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/dynamicPlugins/performanceTesting/UnloadDynamicPluginCommand", "<init>"));
    }
}

