/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dynamicPlugins.performanceTesting;

import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.DynamicPlugins;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public final class LoadDynamicPluginCommand
extends AbstractCommand {
    public static final String PREFIX = "%loadDynamicPlugin";

    public LoadDynamicPluginCommand(@NotNull String text, int line) {
        if (text == null) {
            LoadDynamicPluginCommand.$$$reportNull$$$0(0);
        }
        super(text, line);
    }

    protected Promise<Object> _execute(final PlaybackContext context) {
        ActionCallbackProfilerStopper actionCallback = new ActionCallbackProfilerStopper();
        String pluginId = this.getText().substring(PREFIX.length()).trim();
        if (InstalledPluginsState.getInstance().isRestartRequired()) {
            actionCallback.reject("Not allowing load/unload without restart because of pending restart operation");
        } else {
            IdeaPluginDescriptorImpl pluginDescriptor = (IdeaPluginDescriptorImpl)Objects.requireNonNull(PluginManagerCore.getPlugin((PluginId)PluginId.getId((String)pluginId)));
            pluginDescriptor.setEnabled(true);
            final MessageBusConnection appConnection = ApplicationManager.getApplication().getMessageBus().connect();
            appConnection.subscribe(DynamicPluginListener.TOPIC, (Object)new DynamicPluginListener((ActionCallback)actionCallback){
                final /* synthetic */ ActionCallback val$actionCallback;
                {
                    this.val$actionCallback = actionCallback;
                }

                public void pluginLoaded(@NotNull IdeaPluginDescriptor pluginDescriptor) {
                    if (pluginDescriptor == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    final MessageBusConnection projectConnection = context.getProject().getMessageBus().connect();
                    projectConnection.subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

                        public void exitDumbMode() {
                            appConnection.disconnect();
                            projectConnection.disconnect();
                            val$actionCallback.setDone();
                        }
                    });
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginDescriptor", "org/jetbrains/dynamicPlugins/performanceTesting/LoadDynamicPluginCommand$1", "pluginLoaded"));
                }
            });
            ApplicationManager.getApplication().invokeLater(() -> this.lambda$_execute$0(pluginDescriptor, context, pluginId, (ActionCallback)actionCallback));
        }
        return Promises.toPromise((ActionCallback)actionCallback);
    }

    private /* synthetic */ void lambda$_execute$0(IdeaPluginDescriptorImpl pluginDescriptor, PlaybackContext context, String pluginId, ActionCallback actionCallback) {
        UIUtil.dispatchAllInvocationEvents();
        boolean loaded = DynamicPlugins.INSTANCE.loadPlugin(pluginDescriptor);
        if (loaded) {
            context.message("Plugin " + pluginId + " was loaded successfully", this.getLine());
            actionCallback.setDone();
        } else {
            actionCallback.reject("Plugin " + pluginId + " was not loaded");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/dynamicPlugins/performanceTesting/LoadDynamicPluginCommand", "<init>"));
    }
}

