/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dynamicPlugins.performanceTesting;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import java.io.IOException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.dynamicPlugins.performanceTesting.FindPluginDependenciesCommand;

public final class GetAllBundledPlugins
extends AbstractCommand {
    public static final String PREFIX = "%getAllBundledPlugins";
    private static final Logger LOG = Logger.getInstance(FindPluginDependenciesCommand.class);

    public GetAllBundledPlugins(@NotNull String text, int line) {
        if (text == null) {
            GetAllBundledPlugins.$$$reportNull$$$0(0);
        }
        super(text, line);
    }

    @NotNull
    protected Promise<Object> _execute(@NotNull PlaybackContext context) {
        if (context == null) {
            GetAllBundledPlugins.$$$reportNull$$$0(1);
        }
        ActionCallbackProfilerStopper actionCallback = new ActionCallbackProfilerStopper();
        String fileName = this.getText().substring(PREFIX.length()).trim();
        ArrayList<PluginId> allBundledPlugins = new ArrayList<PluginId>();
        ArrayList<PluginId> ignoredPlugins = new ArrayList<PluginId>();
        ignoredPlugins.add(PluginId.getId((String)"com.intellij"));
        ignoredPlugins.add(PluginId.getId((String)"com.jetbrains.performancePlugin"));
        ignoredPlugins.add(PluginId.getId((String)"com.jetbrains.performancePlugin.dynamicPlugins"));
        ignoredPlugins.add(PluginId.getId((String)"intellij.profiler.ultimate.ideaAsyncProfiler"));
        for (IdeaPluginDescriptor loadedPlugin : PluginManagerCore.getLoadedPlugins()) {
            if (loadedPlugin == null || ignoredPlugins.contains(loadedPlugin.getPluginId()) || !loadedPlugin.isBundled() || loadedPlugin.isImplementationDetail()) continue;
            allBundledPlugins.add(loadedPlugin.getPluginId());
        }
        try {
            FindPluginDependenciesCommand.writeInFile(fileName, allBundledPlugins);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        actionCallback.setDone();
        Promise promise = Promises.toPromise((ActionCallback)actionCallback);
        if (promise == null) {
            GetAllBundledPlugins.$$$reportNull$$$0(2);
        }
        return promise;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/dynamicPlugins/performanceTesting/GetAllBundledPlugins";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/dynamicPlugins/performanceTesting/GetAllBundledPlugins";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "_execute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "_execute";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

