/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dynamicPlugins.performanceTesting;

import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.ModuleDependenciesDescriptor;
import com.intellij.ide.plugins.PluginDependency;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public final class FindPluginDependenciesCommand
extends AbstractCommand {
    public static final String PREFIX = "%findDependencies";
    private static final Logger LOG = Logger.getInstance(FindPluginDependenciesCommand.class);

    public FindPluginDependenciesCommand(@NotNull String text, int line) {
        if (text == null) {
            FindPluginDependenciesCommand.$$$reportNull$$$0(0);
        }
        super(text, line);
    }

    @NotNull
    protected Promise<Object> _execute(@NotNull PlaybackContext context) {
        if (context == null) {
            FindPluginDependenciesCommand.$$$reportNull$$$0(1);
        }
        ActionCallbackProfilerStopper actionCallback = new ActionCallbackProfilerStopper();
        String[] args = this.getText().substring(PREFIX.length()).trim().split(",");
        PluginId pluginId = PluginId.getId((String)args[0].trim());
        LinkedHashSet<PluginId> foundDependenciesOnPlugin = new LinkedHashSet<PluginId>();
        LinkedHashSet<PluginId> foundPluginsDependencies = new LinkedHashSet<PluginId>();
        Map pluginIdMap = PluginManagerCore.buildPluginIdMap();
        for (IdeaPluginDescriptorImpl descriptor : PluginManagerCore.getLoadedPlugins(null)) {
            PluginId currentPluginId = descriptor.getPluginId();
            Set<PluginId> dependenciesIds = FindPluginDependenciesCommand.getNonOptionalDependenciesIds(descriptor);
            if (currentPluginId.equals((Object)pluginId)) {
                FindPluginDependenciesCommand.collectNonOptionalDependenciesIds(dependenciesIds, pluginIdMap, foundPluginsDependencies);
                continue;
            }
            if (!dependenciesIds.contains(pluginId)) continue;
            foundDependenciesOnPlugin.add(currentPluginId);
        }
        try {
            FindPluginDependenciesCommand.writeInFile(args[1].trim(), foundDependenciesOnPlugin);
            FindPluginDependenciesCommand.writeInFile(args[2].trim(), foundPluginsDependencies);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        actionCallback.setDone();
        Promise promise = Promises.toPromise((ActionCallback)actionCallback);
        if (promise == null) {
            FindPluginDependenciesCommand.$$$reportNull$$$0(2);
        }
        return promise;
    }

    private static void collectNonOptionalDependenciesIds(@NotNull Set<PluginId> dependenciesIds, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> pluginIdMap, @NotNull Set<PluginId> accumulator) {
        if (dependenciesIds == null) {
            FindPluginDependenciesCommand.$$$reportNull$$$0(3);
        }
        if (pluginIdMap == null) {
            FindPluginDependenciesCommand.$$$reportNull$$$0(4);
        }
        if (accumulator == null) {
            FindPluginDependenciesCommand.$$$reportNull$$$0(5);
        }
        for (PluginId id : dependenciesIds) {
            IdeaPluginDescriptorImpl descriptor;
            if (accumulator.contains(id) || (descriptor = PluginManagerCore.isModuleDependency((PluginId)id) ? PluginManagerCore.findPluginByModuleDependency((PluginId)id) : Objects.requireNonNull(pluginIdMap.get(id))) == null || descriptor.isBundled()) continue;
            accumulator.add(descriptor.getPluginId());
            FindPluginDependenciesCommand.collectNonOptionalDependenciesIds(FindPluginDependenciesCommand.getNonOptionalDependenciesIds(descriptor), pluginIdMap, accumulator);
        }
    }

    static void writeInFile(@NotNull String fileName, @NotNull Collection<PluginId> pluginIds) throws IOException {
        if (fileName == null) {
            FindPluginDependenciesCommand.$$$reportNull$$$0(6);
        }
        if (pluginIds == null) {
            FindPluginDependenciesCommand.$$$reportNull$$$0(7);
        }
        FileUtil.writeToFile((File)new File(fileName), (String)StringUtil.join(pluginIds, (String)"\n"));
    }

    @NotNull
    private static Set<PluginId> getNonOptionalDependenciesIds(@NotNull IdeaPluginDescriptorImpl descriptor) {
        if (descriptor == null) {
            FindPluginDependenciesCommand.$$$reportNull$$$0(8);
        }
        LinkedHashSet<PluginId> dependencies = new LinkedHashSet<PluginId>();
        for (PluginDependency dependency : descriptor.pluginDependencies) {
            if (dependency.isOptional()) continue;
            dependencies.add(dependency.getPluginId());
        }
        for (ModuleDependenciesDescriptor.PluginReference plugin : descriptor.dependencies.plugins) {
            dependencies.add(plugin.id);
        }
        Set<PluginId> set = Collections.unmodifiableSet(dependencies);
        if (set == null) {
            FindPluginDependenciesCommand.$$$reportNull$$$0(9);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/dynamicPlugins/performanceTesting/FindPluginDependenciesCommand";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependenciesIds";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginIdMap";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accumulator";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginIds";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/dynamicPlugins/performanceTesting/FindPluginDependenciesCommand";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "_execute";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonOptionalDependenciesIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "_execute";
                break;
            }
            case 2: 
            case 9: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "collectNonOptionalDependenciesIds";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "writeInFile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getNonOptionalDependenciesIds";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

