/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dynamicPlugins.performanceTesting;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.PluginEnabler;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class CheckPluginStateCommand
extends AbstractCommand {
    public static final String PREFIX = "%checkPluginState";
    private static final Logger LOG = Logger.getInstance(CheckPluginStateCommand.class);

    public CheckPluginStateCommand(@NotNull String text, int line) {
        if (text == null) {
            CheckPluginStateCommand.$$$reportNull$$$0(0);
        }
        super(text, line);
    }

    protected Promise<Object> _execute(PlaybackContext context) {
        ActionCallbackProfilerStopper actionCallback = new ActionCallbackProfilerStopper();
        String input = this.getText().substring(PREFIX.length()).trim();
        PluginId pluginId = PluginId.getId((String)input.substring(0, input.lastIndexOf(" ")));
        boolean expectedState = Boolean.parseBoolean(input.substring(input.lastIndexOf(" ") + 1));
        DumbService.getInstance((Project)context.getProject()).waitForSmartMode();
        if (InstalledPluginsState.getInstance().isRestartRequired()) {
            return Promises.toPromise((ActionCallback)actionCallback.reject("Not allowing load/unload without restart because of pending restart operation"));
        }
        if (PluginEnabler.HEADLESS.isDisabled(pluginId)) {
            IdeaPluginDescriptor pluginDescriptor = PluginManagerCore.getPlugin((PluginId)pluginId);
            String message = "Plugin " + pluginId + " is disabled.";
            if (pluginDescriptor == null) {
                if (expectedState) {
                    actionCallback.reject(message);
                } else {
                    LOG.info("Plugin " + pluginId + " is disabled.");
                    actionCallback.setDone();
                }
                return Promises.toPromise((ActionCallback)actionCallback);
            }
            IdeaPluginDescriptorImpl pluginDescriptorImpl = (IdeaPluginDescriptorImpl)Objects.requireNonNull(pluginDescriptor);
            return CheckPluginStateCommand.checkPluginInLoadedPlugins((ActionCallback)actionCallback, expectedState, pluginId, pluginDescriptorImpl, pluginDescriptor.getName());
        }
        IdeaPluginDescriptorImpl pluginDescriptor = (IdeaPluginDescriptorImpl)Objects.requireNonNull(PluginManagerCore.getPlugin((PluginId)pluginId));
        return CheckPluginStateCommand.checkPluginInLoadedPlugins((ActionCallback)actionCallback, expectedState, pluginId, pluginDescriptor, pluginDescriptor.getName());
    }

    @NotNull
    private static Promise<Object> checkPluginInLoadedPlugins(ActionCallback actionCallback, boolean expectedState, PluginId pluginId, IdeaPluginDescriptorImpl pluginDescriptor, String name) {
        for (IdeaPluginDescriptor loadedPlugin : PluginManagerCore.getLoadedPlugins()) {
            if (!loadedPlugin.getPluginId().equals((Object)pluginId)) continue;
            String message = "Plugin " + pluginDescriptor.getName() + " has been found in the list of loaded plugins";
            if (expectedState) {
                actionCallback.setDone();
                LOG.info(message);
            } else {
                actionCallback.reject(message);
            }
            Promise promise = Promises.toPromise((ActionCallback)actionCallback);
            if (promise == null) {
                CheckPluginStateCommand.$$$reportNull$$$0(1);
            }
            return promise;
        }
        String message = "Plugin " + name + " has not been found in the list of loaded plugins.";
        if (expectedState) {
            actionCallback.reject(message);
        } else {
            actionCallback.setDone();
            LOG.info(message);
        }
        Promise promise = Promises.toPromise((ActionCallback)actionCallback);
        if (promise == null) {
            CheckPluginStateCommand.$$$reportNull$$$0(2);
        }
        return promise;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/dynamicPlugins/performanceTesting/CheckPluginStateCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/dynamicPlugins/performanceTesting/CheckPluginStateCommand";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "checkPluginInLoadedPlugins";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

