/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.text;

import com.intellij.grazie.text.TextContent;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TextContentImpl
implements TextContent {
    private final TextContent.TextDomain domain;
    final List<TokenInfo> tokens;
    private volatile String text;
    private volatile int[] tokenOffsets;
    static final TokenInfo WS_TOKEN = new TokenInfo(" "){};

    TextContentImpl(TextContent.TextDomain domain, List<TokenInfo> _tokens) {
        this.domain = domain;
        this.tokens = new ArrayList<TokenInfo>(_tokens.size());
        if (_tokens.isEmpty()) {
            throw new IllegalArgumentException("No tokens");
        }
        for (TokenInfo token : _tokens) {
            TokenInfo merged;
            if (!this.tokens.isEmpty() && (merged = TextContentImpl.merge(this.tokens.get(this.tokens.size() - 1), token)) != null) {
                this.tokens.set(this.tokens.size() - 1, merged);
                continue;
            }
            this.tokens.add(token);
        }
        if (this.tokens.get(0) == WS_TOKEN) {
            this.tokens.remove(0);
        }
        if (this.tokens.get(this.tokens.size() - 1) == WS_TOKEN) {
            this.tokens.remove(this.tokens.size() - 1);
        }
        if (this.tokens.isEmpty()) {
            throw new IllegalArgumentException("There should be at least one non-whitespace token");
        }
        List<TextRange> ranges = this.getRangesInFile();
        if (!ContainerUtil.sorted(ranges, (Comparator)Segment.BY_START_OFFSET_THEN_END_OFFSET).equals(ranges)) {
            throw new IllegalArgumentException("TextContent fragments should be ordered by the offset ascending: " + ranges);
        }
    }

    private int findTokenIndex(int textOffset, int[] tokenOffsets, boolean leanForward) {
        if (textOffset < 0 || textOffset > this.length()) {
            throw new IllegalArgumentException("Text offset " + textOffset + " should be between 0 and " + this.length());
        }
        int index = Arrays.binarySearch(tokenOffsets, textOffset);
        if (index < 0) {
            return -index - 2;
        }
        if (leanForward) {
            while (index < this.tokens.size() - 1 && this.tokens.get(index).length() == 0) {
                ++index;
            }
            if (this.tokens.get(index) == WS_TOKEN) {
                --index;
            }
        } else if (index > 0 && this.tokens.get(index - 1) != WS_TOKEN) {
            --index;
        }
        return index;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TextContentImpl)) {
            return false;
        }
        TextContentImpl that = (TextContentImpl)o;
        return this.domain == that.domain && this.tokens.equals(that.tokens);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.domain, this.tokens});
    }

    @Override
    public TextContent.TextDomain getDomain() {
        return this.domain;
    }

    @Override
    public String toString() {
        String text2 = this.text;
        if (text2 == null) {
            this.text = text2 = StringUtil.join(this.tokens, (String)"");
        }
        return text2;
    }

    @Override
    public char charAt(int index) {
        return this.toString().charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.toString().subSequence(start, end);
    }

    @Override
    public int length() {
        return this.toString().length();
    }

    @Override
    public int textOffsetToFile(int textOffset) {
        String text2 = this.toString();
        char prev = textOffset <= 0 ? (char)' ' : (char)text2.charAt(textOffset - 1);
        char next = textOffset >= text2.length() ? (char)' ' : (char)text2.charAt(textOffset);
        boolean leanForward = !(!Character.isWhitespace(prev) && Character.isWhitespace(next) || Character.isLetterOrDigit(prev) && !Character.isLetterOrDigit(next));
        return this.textOffsetToFile(textOffset, leanForward);
    }

    @Override
    public int textOffsetToFile(int textOffset, boolean leanForward) {
        int[] offsets = this.getTokenOffsets();
        int tokenIndex = this.findTokenIndex(textOffset, offsets, leanForward);
        return ((PsiToken)this.tokens.get(tokenIndex)).psiStart() + (textOffset - offsets[tokenIndex]);
    }

    @Override
    public Integer fileOffsetToText(int fileOffset) {
        for (int i = 0; i < this.tokens.size(); ++i) {
            int insidePsi;
            TextRange psiRange;
            TokenInfo token = this.tokens.get(i);
            if (!(token instanceof PsiToken) || !(psiRange = ((PsiToken)token).psi.getTextRange()).containsOffset(fileOffset) || !((PsiToken)token).rangeInPsi.containsOffset(insidePsi = fileOffset - psiRange.getStartOffset())) continue;
            return this.getTokenOffsets()[i] + insidePsi - ((PsiToken)token).rangeInPsi.getStartOffset();
        }
        return null;
    }

    @Override
    @Nullable
    public TextRange fileRangeToText(TextRange fileRange) {
        Integer start = this.fileOffsetToText(fileRange.getStartOffset());
        Integer end = this.fileOffsetToText(fileRange.getEndOffset());
        return start == null || end == null ? null : new TextRange(start.intValue(), end.intValue());
    }

    @Override
    @NotNull
    public PsiElement getCommonParent() {
        PsiElement psiElement = Objects.requireNonNull(PsiTreeUtil.findCommonParent(new ArrayList(ContainerUtil.map2SetNotNull(this.tokens, t -> t instanceof PsiToken ? ((PsiToken)t).psi : null))));
        if (psiElement == null) {
            TextContentImpl.$$$reportNull$$$0(0);
        }
        return psiElement;
    }

    @Override
    @NotNull
    public PsiElement findPsiElementAt(int textOffset) {
        PsiElement psiElement = Objects.requireNonNull(this.getContainingFile().findElementAt(this.textOffsetToFile(textOffset)));
        if (psiElement == null) {
            TextContentImpl.$$$reportNull$$$0(1);
        }
        return psiElement;
    }

    @Override
    @NotNull
    public List<TextRange> getRangesInFile() {
        List list = ((StreamEx)StreamEx.of(this.tokens).select(PsiToken.class).map(t -> t.rangeInPsi.shiftRight(t.psi.getTextRange().getStartOffset())).filter(r -> !r.isEmpty())).toList();
        if (list == null) {
            TextContentImpl.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Override
    @NotNull
    public PsiFile getContainingFile() {
        for (TokenInfo token : this.tokens) {
            if (!(token instanceof PsiToken)) continue;
            PsiFile psiFile = ((PsiToken)token).psi.getContainingFile();
            if (psiFile == null) {
                TextContentImpl.$$$reportNull$$$0(3);
            }
            return psiFile;
        }
        throw new IllegalStateException("No PSI tokens");
    }

    @Override
    public boolean hasUnknownFragmentsIn(TextRange rangeInText) {
        int[] offsets = this.getTokenOffsets();
        int start = this.findTokenIndex(rangeInText.getStartOffset(), offsets, false);
        int end = this.findTokenIndex(rangeInText.getEndOffset(), offsets, true);
        for (int i = start; i <= end; ++i) {
            TokenInfo token = this.tokens.get(i);
            if (!(token instanceof PsiToken) || !((PsiToken)token).unknown || !rangeInText.containsOffset(offsets[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public TextContent excludeRange(TextRange rangeInText) {
        return rangeInText.getLength() == 0 ? this : this.excludeRange(rangeInText, false);
    }

    @Override
    public TextContent markUnknown(TextRange rangeInText) {
        return this.excludeRange(rangeInText, true);
    }

    @Override
    public boolean intersectsRange(TextRange rangeInFile) {
        return this.tokens.stream().anyMatch(token -> token instanceof PsiToken && ((PsiToken)token).rangeInPsi.shiftRight(((PsiToken)token).psi.getTextRange().getStartOffset()).intersectsStrict(rangeInFile));
    }

    private TextContent excludeRange(TextRange range, boolean unknown) {
        int token2End;
        ProgressManager.checkCanceled();
        if (range.getStartOffset() < 0 || range.getEndOffset() > this.length()) {
            throw new IllegalArgumentException("Text range " + range + " should be between 0 and " + this.length());
        }
        if (range.getStartOffset() == 0 && range.getEndOffset() == this.length()) {
            PsiToken first = (PsiToken)this.tokens.get(0);
            return new TextContentImpl(this.domain, Collections.singletonList(new PsiToken("", first.psi, TextRange.from((int)first.rangeInPsi.getStartOffset(), (int)0), unknown || first.unknown || ((PsiToken)this.tokens.get((int)(this.tokens.size() - 1))).unknown)));
        }
        int[] offsets = this.getTokenOffsets();
        int i1 = this.findTokenIndex(range.getStartOffset(), offsets, true);
        int i2 = this.findTokenIndex(range.getEndOffset(), offsets, false);
        PsiToken t1 = (PsiToken)this.tokens.get(i1);
        PsiToken t2 = (PsiToken)this.tokens.get(i2);
        ArrayList<TokenInfo> newTokens = new ArrayList<TokenInfo>(this.tokens.subList(0, i1));
        if (range.getStartOffset() > offsets[i1]) {
            newTokens.add(t1.withRange(TextRange.from((int)t1.rangeInPsi.getStartOffset(), (int)(range.getStartOffset() - offsets[i1]))));
        }
        if (unknown) {
            newTokens.add(new PsiToken("", t1.psi, TextRange.from((int)(t1.rangeInPsi.getStartOffset() + range.getStartOffset() - offsets[i1]), (int)0), true));
        }
        if ((token2End = offsets[i2] + t2.length()) > range.getEndOffset()) {
            newTokens.add(t2.withRange(new TextRange(t2.rangeInPsi.getEndOffset() - token2End + range.getEndOffset(), t2.rangeInPsi.getEndOffset())));
        }
        newTokens.addAll(this.tokens.subList(i2 + 1, this.tokens.size()));
        return new TextContentImpl(this.domain, newTokens);
    }

    private int[] getTokenOffsets() {
        int[] offsets = this.tokenOffsets;
        if (offsets == null) {
            this.tokenOffsets = offsets = this.calcTokenOffsets();
        }
        return offsets;
    }

    private int[] calcTokenOffsets() {
        int[] offsets = new int[this.tokens.size()];
        int tokenStart = 0;
        for (int i = 0; i < this.tokens.size(); ++i) {
            TokenInfo info = this.tokens.get(i);
            offsets[i] = tokenStart;
            tokenStart += info.length();
        }
        return offsets;
    }

    @Override
    public TextContent trimWhitespace() {
        int start;
        String text2 = this.toString();
        int end = text2.length();
        for (start = 0; start < end && TextContentImpl.isSpace(text2, start); ++start) {
        }
        while (start < end && TextContentImpl.isSpace(text2, end - 1)) {
            --end;
        }
        if (start >= end) {
            return null;
        }
        if (start > 0 || end < text2.length()) {
            return this.excludeRange(new TextRange(end, text2.length())).excludeRange(new TextRange(0, start));
        }
        return this;
    }

    private static boolean isSpace(String text2, int start) {
        return Character.isWhitespace(text2.charAt(start)) || Character.isSpaceChar(text2.charAt(start));
    }

    @Nullable
    private static TokenInfo merge(TokenInfo t1, TokenInfo t2) {
        if (t1 == WS_TOKEN && t2 == WS_TOKEN) {
            return t1;
        }
        if (t1 instanceof PsiToken && t2 instanceof PsiToken) {
            if (((PsiToken)t1).unknown && ((PsiToken)t2).unknown) {
                return t1;
            }
            if (!((PsiToken)t1).unknown && !((PsiToken)t2).unknown) {
                if (t1.length() == 0) {
                    return t2;
                }
                if (t2.length() == 0) {
                    return t1;
                }
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/grazie/text/TextContentImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonParent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "findPsiElementAt";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangesInFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainingFile";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    static class PsiToken
    extends TokenInfo {
        final PsiElement psi;
        final TextRange rangeInPsi;
        final boolean unknown;

        PsiToken(String text2, PsiElement psi, TextRange rangeInPsi, boolean unknown) {
            super(text2);
            this.psi = psi;
            this.rangeInPsi = rangeInPsi;
            this.unknown = unknown;
            assert (rangeInPsi.getLength() == text2.length());
            assert (!unknown || rangeInPsi.getLength() == 0);
        }

        private int psiStart() {
            return this.psi.getTextRange().getStartOffset() + this.rangeInPsi.getStartOffset();
        }

        PsiToken withRange(TextRange range) {
            assert (range.getLength() > 0);
            assert (!this.unknown);
            return new PsiToken(range.shiftLeft(this.rangeInPsi.getStartOffset()).substring(this.text), this.psi, range, false);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PsiToken)) {
                return false;
            }
            PsiToken psiToken = (PsiToken)o;
            return this.unknown == psiToken.unknown && this.psi.equals(psiToken.psi) && this.rangeInPsi.equals((Object)psiToken.rangeInPsi);
        }

        public int hashCode() {
            return Objects.hash(this.psi, this.rangeInPsi, this.unknown);
        }
    }

    static abstract class TokenInfo {
        final String text;

        TokenInfo(String text2) {
            this.text = text2;
        }

        int length() {
            return this.text.length();
        }

        public String toString() {
            return this.text;
        }
    }
}

