/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.ui.details;

import com.intellij.collaboration.ui.SimpleEventListener;
import com.intellij.collaboration.ui.SingleValueModel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Consumer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.DataPackChangeListener;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsProjectLog;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequest;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRDetailsDataProvider;
import org.jetbrains.plugins.github.pullrequest.ui.details.GHPRBranchesModel;
import org.jetbrains.plugins.github.pullrequest.ui.details.GHPRBranchesModelImpl;
import org.jetbrains.plugins.github.util.GithubGitHelper;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B+\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0016\u0010*\u001a\u00020+2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020+0-H\u0017J\n\u0010.\u001a\u0004\u0018\u00010\rH\u0002J\n\u0010/\u001a\u0004\u0018\u00010#H\u0002J\b\u00100\u001a\u00020+H\u0002J\b\u00101\u001a\u00020+H\u0002R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR!\u0010\u0010\u001a\u0015\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00120\u00120\u0011\u00a2\u0006\u0002\b\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u000fR\u0014\u0010\u0019\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u000fR\u0014\u0010\u001b\u001a\u00020\u001c8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001dR\u0016\u0010\u001e\u001a\u0004\u0018\u00010\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u000fR\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\"\u001a\u0004\u0018\u00010#8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0016\u0010&\u001a\u0004\u0018\u00010\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u000fR\u0016\u0010(\u001a\u0004\u0018\u00010\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u000fR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/details/GHPRBranchesModelImpl;", "Lorg/jetbrains/plugins/github/pullrequest/ui/details/GHPRBranchesModel;", "valueModel", "Lcom/intellij/collaboration/ui/SingleValueModel;", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequest;", "detailsDataProvider", "Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRDetailsDataProvider;", "localRepository", "Lgit4idea/repo/GitRepository;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/collaboration/ui/SingleValueModel;Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRDetailsDataProvider;Lgit4idea/repo/GitRepository;Lcom/intellij/openapi/Disposable;)V", "baseBranch", "", "getBaseBranch", "()Ljava/lang/String;", "changeEventDispatcher", "Lcom/intellij/util/EventDispatcher;", "Lcom/intellij/collaboration/ui/SimpleEventListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "dataPackListener", "Lcom/intellij/vcs/log/data/DataPackChangeListener;", "headBranch", "getHeadBranch", "headRefName", "getHeadRefName", "isFork", "", "()Z", "localBranch", "getLocalBranch", "getLocalRepository", "()Lgit4idea/repo/GitRepository;", "prRemote", "Lgit4idea/repo/GitRemote;", "getPrRemote", "()Lgit4idea/repo/GitRemote;", "sshUrl", "getSshUrl", "url", "getUrl", "addAndInvokeChangeListener", "", "listener", "Lkotlin/Function0;", "determineLocalBranch", "determinePrRemote", "notifyChanged", "registerVCSLogDataPackListener", "intellij.vcs.github"})
public final class GHPRBranchesModelImpl
implements GHPRBranchesModel {
    private final EventDispatcher<SimpleEventListener> changeEventDispatcher;
    private final DataPackChangeListener dataPackListener;
    private final SingleValueModel<GHPullRequest> valueModel;
    @NotNull
    private final GitRepository localRepository;
    private final Disposable parentDisposable;

    private final void registerVCSLogDataPackListener() {
        Project project = this.getLocalRepository().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"localRepository.project");
        Project project2 = project;
        VcsProjectLog.runWhenLogIsReady((Project)project2, (Consumer)new Consumer(this, project2){
            final /* synthetic */ GHPRBranchesModelImpl this$0;
            final /* synthetic */ Project $project;

            public final void consume(VcsLogManager it) {
                VcsProjectLog log;
                VcsProjectLog vcsProjectLog = log = VcsProjectLog.getInstance((Project)this.$project);
                Intrinsics.checkNotNullExpressionValue((Object)vcsProjectLog, (String)"log");
                VcsLogData vcsLogData = vcsProjectLog.getDataManager();
                if (vcsLogData == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)vcsLogData, (String)"log.dataManager ?: return@runWhenLogIsReady");
                VcsLogData dataManager = vcsLogData;
                ApplicationManager.getApplication().invokeLater(new Runnable(this, dataManager){
                    final /* synthetic */ registerVCSLogDataPackListener.1 this$0;
                    final /* synthetic */ VcsLogData $dataManager;

                    public final void run() {
                        VcsLogData vcsLogData = this.$dataManager;
                        boolean bl = false;
                        boolean bl2 = false;
                        VcsLogData $this$with = vcsLogData;
                        boolean bl3 = false;
                        $this$with.addDataPackChangeListener(GHPRBranchesModelImpl.access$getDataPackListener$p(this.this$0.this$0));
                        Disposer.register((Disposable)GHPRBranchesModelImpl.access$getParentDisposable$p(this.this$0.this$0), (Disposable)new Disposable($this$with, this){
                            final /* synthetic */ VcsLogData $this_with;
                            final /* synthetic */ registerVCSLogDataPackListener.1 this$0;
                            {
                                this.$this_with = vcsLogData;
                                this.this$0 = var2_2;
                            }

                            public final void dispose() {
                                this.$this_with.removeDataPackChangeListener(GHPRBranchesModelImpl.access$getDataPackListener$p(this.this$0.this$0.this$0));
                            }
                        });
                    }
                    {
                        this.this$0 = var1_1;
                        this.$dataManager = vcsLogData;
                    }
                }, new Condition(this){
                    final /* synthetic */ registerVCSLogDataPackListener.1 this$0;

                    public final boolean value(Object it) {
                        return Disposer.isDisposed((Disposable)GHPRBranchesModelImpl.access$getParentDisposable$p(this.this$0.this$0));
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = gHPRBranchesModelImpl;
                this.$project = project;
            }
        });
    }

    @Override
    @RequiresEdt
    public void addAndInvokeChangeListener(@NotNull Function0<Unit> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        SimpleEventListener.Companion.addAndInvokeListener(this.changeEventDispatcher, this.parentDisposable, listener);
    }

    @Override
    @NotNull
    public String getBaseBranch() {
        return ((GHPullRequest)this.valueModel.getValue()).getBaseRefName();
    }

    @Override
    @NotNull
    public String getHeadBranch() {
        Object object = this.valueModel.getValue();
        boolean bl = false;
        boolean bl2 = false;
        GHPullRequest $this$with = (GHPullRequest)object;
        boolean bl3 = false;
        if ($this$with.getHeadRepository() == null) {
            return $this$with.getHeadRefName();
        }
        if ($this$with.getHeadRepository().isFork() || Intrinsics.areEqual((Object)$this$with.getBaseRefName(), (Object)$this$with.getHeadRefName())) {
            return $this$with.getHeadRepository().getOwner().getLogin() + ":" + $this$with.getHeadRefName();
        }
        return $this$with.getHeadRefName();
    }

    @Override
    @Nullable
    public GitRemote getPrRemote() {
        return this.determinePrRemote();
    }

    @Override
    @Nullable
    public String getLocalBranch() {
        return this.determineLocalBranch();
    }

    private final String getHeadRefName() {
        return ((GHPullRequest)this.valueModel.getValue()).getHeadRefName();
    }

    private final void notifyChanged() {
        ((SimpleEventListener)this.changeEventDispatcher.getMulticaster()).eventOccurred();
    }

    private final String getUrl() {
        GHPullRequest.HeadRepository headRepository = ((GHPullRequest)this.valueModel.getValue()).getHeadRepository();
        return headRepository != null ? headRepository.getUrl() : null;
    }

    private final String getSshUrl() {
        GHPullRequest.HeadRepository headRepository = ((GHPullRequest)this.valueModel.getValue()).getHeadRepository();
        return headRepository != null ? headRepository.getSshUrl() : null;
    }

    private final boolean isFork() {
        GHPullRequest.HeadRepository headRepository = ((GHPullRequest)this.valueModel.getValue()).getHeadRepository();
        return headRepository != null ? headRepository.isFork() : false;
    }

    private final GitRemote determinePrRemote() {
        return GithubGitHelper.Companion.getInstance().findRemote(this.getLocalRepository(), this.getUrl(), this.getSshUrl());
    }

    private final String determineLocalBranch() {
        GitRemote gitRemote = this.getPrRemote();
        if (gitRemote == null) {
            return null;
        }
        GitRemote prRemote = gitRemote;
        return GithubGitHelper.Companion.getInstance().findLocalBranch(this.getLocalRepository(), prRemote, this.isFork(), this.getHeadRefName());
    }

    @Override
    @NotNull
    public GitRepository getLocalRepository() {
        return this.localRepository;
    }

    public GHPRBranchesModelImpl(@NotNull SingleValueModel<GHPullRequest> valueModel, @NotNull GHPRDetailsDataProvider detailsDataProvider, @NotNull GitRepository localRepository, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter(valueModel, (String)"valueModel");
        Intrinsics.checkNotNullParameter((Object)detailsDataProvider, (String)"detailsDataProvider");
        Intrinsics.checkNotNullParameter((Object)localRepository, (String)"localRepository");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.valueModel = valueModel;
        this.localRepository = localRepository;
        this.parentDisposable = parentDisposable;
        EventDispatcher eventDispatcher = EventDispatcher.create(SimpleEventListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"EventDispatcher.create(S\u2026ventListener::class.java)");
        this.changeEventDispatcher = eventDispatcher;
        this.registerVCSLogDataPackListener();
        this.dataPackListener = new DataPackChangeListener(this, detailsDataProvider){
            final /* synthetic */ GHPRBranchesModelImpl this$0;
            final /* synthetic */ GHPRDetailsDataProvider $detailsDataProvider;

            public final void onDataPackChange(@NotNull DataPack it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                GHPRBranchesModelImpl.access$notifyChanged(this.this$0);
                this.$detailsDataProvider.reloadDetails();
            }
            {
                this.this$0 = gHPRBranchesModelImpl;
                this.$detailsDataProvider = gHPRDetailsDataProvider;
            }
        };
    }

    public static final /* synthetic */ DataPackChangeListener access$getDataPackListener$p(GHPRBranchesModelImpl $this) {
        return $this.dataPackListener;
    }

    public static final /* synthetic */ Disposable access$getParentDisposable$p(GHPRBranchesModelImpl $this) {
        return $this.parentDisposable;
    }

    public static final /* synthetic */ void access$notifyChanged(GHPRBranchesModelImpl $this) {
        $this.notifyChanged();
    }
}

