/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.groovy.compiler.rt;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class GroovyRtJarPaths {
    public static List<String> getGroovyRtRoots(File jpsPluginRoot) {
        ArrayList<String> result = new ArrayList<String>();
        GroovyRtJarPaths.addGroovyRtJarPath(jpsPluginRoot, "groovy-rt.jar", Collections.singletonList("intellij.groovy.rt"), "groovy-rt", result);
        GroovyRtJarPaths.addGroovyRtJarPath(jpsPluginRoot, "groovy-constants-rt.jar", Collections.singletonList("intellij.groovy.constants.rt"), "groovy-constants-rt", result);
        return result;
    }

    private static void addGroovyRtJarPath(File jpsPluginClassesRoot, String jarNameInDistribution, List<String> moduleNames, String mavenArtifactNamePrefix, List<String> to) {
        File parentDir = jpsPluginClassesRoot.getParentFile();
        if (jpsPluginClassesRoot.isFile()) {
            String fileName;
            if (jpsPluginClassesRoot.getName().equals("groovy-jps.jar")) {
                fileName = jarNameInDistribution;
            } else {
                String name = jpsPluginClassesRoot.getName();
                int dotIndex = name.lastIndexOf(46);
                name = dotIndex < 0 ? name : name.substring(0, dotIndex);
                int dashIndex = name.lastIndexOf(45);
                String version = dashIndex < 0 ? null : name.substring(dashIndex + 1);
                fileName = mavenArtifactNamePrefix + "-" + version + ".jar";
                if (parentDir.getName().equals(version)) {
                    parentDir = new File(parentDir.getParentFile().getParentFile(), mavenArtifactNamePrefix + "/" + version);
                }
            }
            to.add(new File(parentDir, fileName).getPath());
        } else {
            for (String moduleName : moduleNames) {
                to.add(new File(parentDir, moduleName).getPath());
            }
        }
    }
}

