/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.tslint.ui;

import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.lang.javascript.linter.AutodetectLinterPackage;
import com.intellij.lang.javascript.linter.JSLinterConfigurable;
import com.intellij.lang.javascript.linter.JSLinterView;
import com.intellij.lang.javascript.linter.NewLinterView;
import com.intellij.lang.javascript.linter.tslint.TsLintBundle;
import com.intellij.lang.javascript.linter.tslint.config.TsLintConfiguration;
import com.intellij.lang.javascript.linter.tslint.config.TsLintState;
import com.intellij.lang.javascript.linter.tslint.service.TslintLanguageServiceManager;
import com.intellij.lang.javascript.linter.tslint.ui.TslintPanel;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.util.text.SemVer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TsLintConfigurable
extends JSLinterConfigurable<TsLintState> {
    @NonNls
    public static final String SETTINGS_JAVA_SCRIPT_LINTERS_TSLINT = "settings.javascript.linters.tslint";

    public TsLintConfigurable(@NotNull Project project) {
        if (project == null) {
            TsLintConfigurable.$$$reportNull$$$0(0);
        }
        super(project, TsLintConfiguration.class, false);
    }

    public TsLintConfigurable(@NotNull Project project, boolean fullModeDialog) {
        if (project == null) {
            TsLintConfigurable.$$$reportNull$$$0(1);
        }
        super(project, TsLintConfiguration.class, fullModeDialog);
    }

    @NotNull
    protected JSLinterView<TsLintState> createView() {
        return new NewTslintView(this.myProject, this.getDisplayName(), new TslintPanel(this.getProject(), this.isFullModeDialog(), false));
    }

    @NotNull
    public String getId() {
        return SETTINGS_JAVA_SCRIPT_LINTERS_TSLINT;
    }

    @Nls
    public String getDisplayName() {
        return TsLintBundle.message("settings.javascript.linters.tslint.configurable.name", new Object[0]);
    }

    public void apply() throws ConfigurationException {
        super.apply();
        TsLintState state = (TsLintState)this.getExtendedState(TsLintConfiguration.class).getState();
        NodePackage nodePackage = state.getNodePackageRef().getConstantPackage();
        if (nodePackage != null && !nodePackage.isEmptyPath() && state.isAllowJs() && !TsLintConfigurable.checkPackageVersionForJs(nodePackage.getVersion())) {
            throw new ConfigurationException(TsLintBundle.message("linting.javascript.is.not.supported.for.this.version.of.tslint", new Object[0]));
        }
        TslintLanguageServiceManager.getInstance(this.myProject).terminateServices();
    }

    private static boolean checkPackageVersionForJs(@Nullable SemVer semVer) {
        return semVer != null && semVer.getMajor() >= 4;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/tslint/ui/TsLintConfigurable", "<init>"));
    }

    private static class NewTslintView
    extends NewLinterView<TsLintState> {
        private final TslintPanel myPanel;

        NewTslintView(Project project, String displayName, TslintPanel panel) {
            super(project, displayName, panel.createComponent(), "tslint.json");
            this.myPanel = panel;
        }

        @NotNull
        protected TsLintState getStateWithConfiguredAutomatically() {
            TsLintState tsLintState = TsLintState.DEFAULT.withLinterPackage(AutodetectLinterPackage.INSTANCE);
            if (tsLintState == null) {
                NewTslintView.$$$reportNull$$$0(0);
            }
            return tsLintState;
        }

        protected void handleEnabledStatusChanged(boolean enabled) {
            this.myPanel.handleEnableStatusChanged(enabled);
        }

        protected void setState(@NotNull TsLintState state) {
            if (state == null) {
                NewTslintView.$$$reportNull$$$0(1);
            }
            this.myPanel.setState(state);
        }

        @NotNull
        protected TsLintState getState() {
            TsLintState tsLintState = this.myPanel.getState();
            if (tsLintState == null) {
                NewTslintView.$$$reportNull$$$0(2);
            }
            return tsLintState;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/linter/tslint/ui/TsLintConfigurable$NewTslintView";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStateWithConfiguredAutomatically";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/linter/tslint/ui/TsLintConfigurable$NewTslintView";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getState";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setState";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

