/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.language.psi.reference;

import com.intellij.openapi.vfs.VirtualFile;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003H\u0002J\u000e\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0003J\u000e\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0003J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u0003J\u000e\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0003J\u000e\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u0003J\u000e\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0003R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0017"}, d2={"Lorg/editorconfig/language/psi/reference/EditorConfigVirtualFileDescriptor;", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/vfs/VirtualFile;)V", "cachedChildMappings", "", "", "cachedParentMappings", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "calculateDistanceBetween", "parentFile", "initialFile", "distanceToChild", "child", "distanceToParent", "parent", "isChildOf", "", "isParentOf", "isStrictChildOf", "isStrictParentOf", "intellij.editorconfig"})
public final class EditorConfigVirtualFileDescriptor {
    private final Map<VirtualFile, Integer> cachedChildMappings;
    private final Map<VirtualFile, Integer> cachedParentMappings;
    @NotNull
    private final VirtualFile file;

    public final int distanceToChild(@NotNull VirtualFile child) {
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        Integer cached = this.cachedChildMappings.get(child);
        if (cached != null) {
            return cached;
        }
        int distance = this.calculateDistanceBetween(this.file, child);
        this.cachedChildMappings.put(child, distance);
        return distance;
    }

    public final int distanceToParent(@NotNull VirtualFile parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Integer cached = this.cachedParentMappings.get(parent);
        if (cached != null) {
            return cached;
        }
        int distance = this.calculateDistanceBetween(parent, this.file);
        this.cachedParentMappings.put(parent, distance);
        return distance;
    }

    public final boolean isChildOf(@NotNull VirtualFile parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        return this.distanceToParent(parent) >= 0;
    }

    public final boolean isParentOf(@NotNull VirtualFile child) {
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        return this.distanceToChild(child) >= 0;
    }

    public final boolean isStrictParentOf(@NotNull VirtualFile child) {
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        return this.distanceToChild(child) > 0;
    }

    public final boolean isStrictChildOf(@NotNull VirtualFile parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        return this.distanceToParent(parent) > 0;
    }

    private final int calculateDistanceBetween(VirtualFile parentFile, VirtualFile initialFile) {
        int result2 = 0;
        VirtualFile targetFolder = parentFile.getParent();
        for (VirtualFile currentFolder = initialFile.getParent(); currentFolder != null; currentFolder = currentFolder.getParent()) {
            if (Intrinsics.areEqual((Object)currentFolder, (Object)targetFolder)) {
                return result2;
            }
            ++result2;
        }
        return -1;
    }

    @NotNull
    public final VirtualFile getFile() {
        return this.file;
    }

    public EditorConfigVirtualFileDescriptor(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.file = file;
        boolean bl = false;
        this.cachedChildMappings = new LinkedHashMap();
        bl = false;
        this.cachedParentMappings = new LinkedHashMap();
    }
}

