/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement;

import com.intellij.application.options.CodeStyle;
import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.FileEncodingProvider;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.editorconfig.Utils;
import org.editorconfig.configmanagement.EditorConfigEncodingCache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigEncodingManager
implements FileEncodingProvider {
    public static final String charsetKey = "charset";
    public static final String UTF8_BOM_ENCODING = "utf-8-bom";
    public static final String UTF8_ENCODING = "utf-8";
    private static final Map<String, Charset> encodingMap;
    private final ThreadLocal<Boolean> isApplyingSettings = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Charset getEncoding(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            ConfigEncodingManager.$$$reportNull$$$0(0);
        }
        if (!Utils.isApplicableTo(virtualFile) || Utils.isEditorConfigFile(virtualFile)) {
            return null;
        }
        Project project = ProjectLocator.getInstance().guessProjectForFile(virtualFile);
        if (project != null && !Utils.isEnabled(CodeStyle.getSettings((Project)project)) || this.isApplyingSettings.get() != null && this.isApplyingSettings.get().booleanValue()) {
            return null;
        }
        if (ConfigEncodingManager.isIndexing(project)) {
            return EditorConfigEncodingCache.getInstance().getCachedEncoding(virtualFile);
        }
        try {
            this.isApplyingSettings.set(true);
            Charset charset = EditorConfigEncodingCache.getInstance().getEncoding(project, virtualFile);
            return charset;
        }
        finally {
            this.isApplyingSettings.set(false);
        }
    }

    private static boolean isIndexing(@Nullable Project project) {
        return project != null && !LightEdit.owns((Project)project) && DumbService.isDumb((Project)project);
    }

    @Nullable
    public static String toString(@NotNull Charset charset, boolean useBom) {
        if (charset == null) {
            ConfigEncodingManager.$$$reportNull$$$0(1);
        }
        if (charset == StandardCharsets.UTF_8) {
            return useBom ? UTF8_BOM_ENCODING : UTF8_ENCODING;
        }
        return (String)ObjectUtils.doIfNotNull((Object)((Map.Entry)ContainerUtil.find(encodingMap.entrySet(), e -> e.getValue() == charset)), entry -> (String)entry.getKey());
    }

    @Nullable
    public static Charset toCharset(@NotNull String str) {
        if (str == null) {
            ConfigEncodingManager.$$$reportNull$$$0(2);
        }
        return encodingMap.get(str);
    }

    static {
        HashMap<String, Charset> map = new HashMap<String, Charset>();
        map.put("latin1", StandardCharsets.ISO_8859_1);
        map.put(UTF8_ENCODING, StandardCharsets.UTF_8);
        map.put(UTF8_BOM_ENCODING, StandardCharsets.UTF_8);
        map.put("utf-16be", StandardCharsets.UTF_16BE);
        map.put("utf-16le", StandardCharsets.UTF_16LE);
        encodingMap = Collections.unmodifiableMap(map);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = charsetKey;
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
        }
        objectArray2[1] = "org/editorconfig/configmanagement/ConfigEncodingManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getEncoding";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "toString";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "toCharset";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

