/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.telemetry.opentelemetry.export;

import com.newrelic.telemetry.Attributes;
import com.newrelic.telemetry.OkHttpPoster;
import com.newrelic.telemetry.SenderConfiguration;
import com.newrelic.telemetry.SpanBatchSenderFactory;
import com.newrelic.telemetry.TelemetryClient;
import com.newrelic.telemetry.opentelemetry.export.AttributesSupport;
import com.newrelic.telemetry.opentelemetry.export.SpanBatchAdapter;
import com.newrelic.telemetry.opentelemetry.export.VersionFinder;
import com.newrelic.telemetry.spans.SpanBatch;
import com.newrelic.telemetry.spans.SpanBatchSender;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewRelicSpanExporter
implements SpanExporter {
    private static final Logger logger = LoggerFactory.getLogger(NewRelicSpanExporter.class);
    private final SpanBatchAdapter adapter;
    private final TelemetryClient telemetryClient;

    NewRelicSpanExporter(SpanBatchAdapter adapter, TelemetryClient telemetryClient) {
        if (telemetryClient == null) {
            throw new IllegalArgumentException("You must provide a non-null telemetryClient");
        }
        this.adapter = adapter;
        this.telemetryClient = telemetryClient;
    }

    public CompletableResultCode export(Collection<SpanData> openTelemetrySpans) {
        Collection<SpanBatch> spanBatch = this.adapter.adaptToSpanBatches(openTelemetrySpans);
        if (spanBatch.isEmpty()) {
            logger.debug("spanBatch is empty");
        }
        spanBatch.forEach(arg_0 -> ((TelemetryClient)this.telemetryClient).sendBatch(arg_0));
        return CompletableResultCode.ofSuccess();
    }

    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    public CompletableResultCode shutdown() {
        this.telemetryClient.shutdown();
        return CompletableResultCode.ofSuccess();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private Attributes commonAttributes = new Attributes();
        private TelemetryClient telemetryClient;
        private String apiKey;
        private boolean enableAuditLogging = false;
        private URI uriOverride;

        public Builder telemetryClient(TelemetryClient telemetryClient) {
            this.telemetryClient = telemetryClient;
            return this;
        }

        public Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public Builder enableAuditLogging() {
            this.enableAuditLogging = true;
            return this;
        }

        public Builder commonAttributes(Attributes commonAttributes) {
            this.commonAttributes = commonAttributes;
            return this;
        }

        public Builder uriOverride(URI uriOverride) {
            this.uriOverride = uriOverride;
            return this;
        }

        public NewRelicSpanExporter build() {
            SpanBatchAdapter spanBatchAdapter = new SpanBatchAdapter(this.commonAttributes, AttributesSupport.SERVICE_INSTANCE_ID);
            if (this.telemetryClient != null) {
                return new NewRelicSpanExporter(spanBatchAdapter, this.telemetryClient);
            }
            SenderConfiguration.SenderConfigurationBuilder builder = SpanBatchSenderFactory.fromHttpImplementation(OkHttpPoster::new).configureWith(this.apiKey).secondaryUserAgent("NewRelic-OpenTelemetry-Exporter/" + VersionFinder.readVersion());
            if (this.enableAuditLogging) {
                builder.auditLoggingEnabled(true);
            }
            if (this.uriOverride != null) {
                try {
                    builder.endpoint(this.uriOverride.toURL());
                }
                catch (MalformedURLException e) {
                    throw new IllegalArgumentException("URI Override value must be a valid URI.", e);
                }
            }
            SenderConfiguration configuration = builder.build();
            this.telemetryClient = new TelemetryClient(null, SpanBatchSender.create((SenderConfiguration)configuration), null, null);
            return new NewRelicSpanExporter(spanBatchAdapter, this.telemetryClient);
        }
    }
}

