/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.telemetry.opentelemetry.export;

import com.newrelic.telemetry.Attributes;
import com.newrelic.telemetry.metrics.Count;
import com.newrelic.telemetry.metrics.Gauge;
import com.newrelic.telemetry.metrics.Metric;
import com.newrelic.telemetry.metrics.Summary;
import com.newrelic.telemetry.opentelemetry.export.DeltaDoubleCounter;
import com.newrelic.telemetry.opentelemetry.export.DeltaLongCounter;
import com.newrelic.telemetry.opentelemetry.export.TimeTracker;
import io.opentelemetry.api.common.Labels;
import io.opentelemetry.sdk.metrics.data.MetricData;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class MetricPointAdapter {
    private final Map<Key, DeltaLongCounter> deltaLongCountersByDescriptor = new HashMap<Key, DeltaLongCounter>();
    private final Map<Key, DeltaDoubleCounter> deltaDoubleCountersByDescriptor = new HashMap<Key, DeltaDoubleCounter>();
    private final TimeTracker timeTracker;

    public MetricPointAdapter(TimeTracker timeTracker) {
        this.timeTracker = timeTracker;
    }

    Collection<Metric> buildMetricsFromPoint(MetricData metric, Attributes attributes, MetricData.Point point) {
        point.getLabels().forEach((arg_0, arg_1) -> ((Attributes)attributes).put(arg_0, arg_1));
        if (point instanceof MetricData.LongPoint) {
            return this.buildLongPointMetrics(metric, attributes, (MetricData.LongPoint)point);
        }
        if (point instanceof MetricData.DoublePoint) {
            return this.buildDoublePointMetrics(metric, attributes, (MetricData.DoublePoint)point);
        }
        if (point instanceof MetricData.SummaryPoint) {
            return this.buildSummaryPointMetrics(metric, attributes, (MetricData.SummaryPoint)point);
        }
        return Collections.emptyList();
    }

    private boolean isNonMonotonic(MetricData metric) {
        MetricData.Type type = metric.getType();
        return type != MetricData.Type.NON_MONOTONIC_DOUBLE && type != MetricData.Type.NON_MONOTONIC_LONG;
    }

    private Collection<Metric> buildDoublePointMetrics(MetricData metric, Attributes attributes, MetricData.DoublePoint point) {
        double value = point.getValue();
        if (this.isNonMonotonic(metric)) {
            DeltaDoubleCounter deltaDoubleCounter = this.deltaDoubleCountersByDescriptor.computeIfAbsent(new Key(metric, point.getLabels()), d -> new DeltaDoubleCounter());
            value = deltaDoubleCounter.delta(point);
        }
        return this.buildMetricsFromSimpleType(metric, attributes, value, point.getEpochNanos(), this.timeTracker.getPreviousTime());
    }

    private Collection<Metric> buildLongPointMetrics(MetricData metric, Attributes attributes, MetricData.LongPoint point) {
        long value = point.getValue();
        if (this.isNonMonotonic(metric)) {
            DeltaLongCounter deltaLongCounter = this.deltaLongCountersByDescriptor.computeIfAbsent(new Key(metric, point.getLabels()), d -> new DeltaLongCounter());
            value = deltaLongCounter.delta(point);
        }
        return this.buildMetricsFromSimpleType(metric, attributes, value, point.getEpochNanos(), this.timeTracker.getPreviousTime());
    }

    private Collection<Metric> buildMetricsFromSimpleType(MetricData metric, Attributes attributes, double value, long epochNanos, long startEpochNanos) {
        switch (metric.getType()) {
            case NON_MONOTONIC_LONG: 
            case NON_MONOTONIC_DOUBLE: {
                return Collections.singleton(new Gauge(metric.getName(), value, TimeUnit.NANOSECONDS.toMillis(epochNanos), attributes));
            }
            case MONOTONIC_LONG: 
            case MONOTONIC_DOUBLE: {
                return Collections.singleton(new Count(metric.getName(), value, TimeUnit.NANOSECONDS.toMillis(startEpochNanos), TimeUnit.NANOSECONDS.toMillis(epochNanos), attributes));
            }
        }
        return Collections.emptyList();
    }

    private Collection<Metric> buildSummaryPointMetrics(MetricData metric, Attributes attributes, MetricData.SummaryPoint point) {
        List percentileValues = point.getPercentileValues();
        double min = Double.NaN;
        double max = Double.NaN;
        for (MetricData.ValueAtPercentile percentileValue : percentileValues) {
            if (percentileValue.getPercentile() == 0.0) {
                min = percentileValue.getValue();
            }
            if (percentileValue.getPercentile() != 100.0) continue;
            max = percentileValue.getValue();
        }
        return Collections.singleton(new Summary(metric.getName(), (int)point.getCount(), point.getSum(), min, max, TimeUnit.NANOSECONDS.toMillis(point.getStartEpochNanos()), TimeUnit.NANOSECONDS.toMillis(point.getEpochNanos()), attributes));
    }

    private static class Key {
        private final String name;
        private final String description;
        private final String unit;
        private final MetricData.Type type;
        private final Labels labels;

        public Key(MetricData metric, Labels labels) {
            this(metric.getName(), metric.getDescription(), metric.getUnit(), metric.getType(), labels);
        }

        public Key(String name, String description, String unit, MetricData.Type type, Labels labels) {
            this.name = name;
            this.description = description;
            this.unit = unit;
            this.type = type;
            this.labels = labels;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return this.name.equals(key.name) && Objects.equals(this.description, key.description) && Objects.equals(this.unit, key.unit) && this.type == key.type && Objects.equals(this.labels, key.labels);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.description, this.unit, this.type, this.labels);
        }
    }
}

