/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.telemetry.opentelemetry.export;

import com.newrelic.telemetry.Attributes;
import io.opentelemetry.api.common.AttributeConsumer;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.ReadableAttributes;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.resources.Resource;
import java.util.UUID;

public class AttributesSupport {
    static final String SERVICE_INSTANCE_ID = UUID.randomUUID().toString();

    static Attributes populateLibraryInfo(Attributes attributes, InstrumentationLibraryInfo instrumentationLibraryInfo) {
        if (instrumentationLibraryInfo != null) {
            if (instrumentationLibraryInfo.getName() != null && !instrumentationLibraryInfo.getName().isEmpty()) {
                attributes.put("instrumentation.name", instrumentationLibraryInfo.getName());
            }
            if (instrumentationLibraryInfo.getVersion() != null && !instrumentationLibraryInfo.getVersion().isEmpty()) {
                attributes.put("instrumentation.version", instrumentationLibraryInfo.getVersion());
            }
        }
        return attributes;
    }

    static Attributes addResourceAttributes(Attributes attributes, Resource resource) {
        if (resource != null) {
            ReadableAttributes labelsMap = resource.getAttributes();
            AttributesSupport.putInAttributes(attributes, labelsMap);
        }
        return attributes;
    }

    static void putInAttributes(final Attributes attributes, ReadableAttributes originalAttributes) {
        originalAttributes.forEach(new AttributeConsumer(){

            public <T> void accept(AttributeKey<T> key, T value) {
                switch (key.getType()) {
                    case STRING: {
                        attributes.put(key.getKey(), (String)value);
                        break;
                    }
                    case BOOLEAN: {
                        attributes.put(key.getKey(), ((Boolean)value).booleanValue());
                        break;
                    }
                    case LONG: 
                    case DOUBLE: {
                        attributes.put(key.getKey(), (Number)value);
                    }
                }
            }
        });
    }
}

