/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl.rules;

import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageGroup;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.impl.UnknownUsagesInUnloadedModules;
import com.intellij.usages.impl.rules.DefaultUsageGroup;
import com.intellij.usages.impl.rules.UsageGroupingRulesDefaultRanks;
import com.intellij.usages.rules.PsiElementUsage;
import com.intellij.usages.rules.SingleParentUsageGroupingRule;
import com.intellij.usages.rules.UsageGroupingRuleEx;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class NonCodeUsageGroupingRule
extends SingleParentUsageGroupingRule
implements UsageGroupingRuleEx {
    private static final UsageGroup ourUnloadedGroup = new DefaultUsageGroup(0, (Supplier)UsageViewBundle.messagePointer("list.item.usages.in.unloaded.modules", new Object[0])){

        public String toString() {
            return this.getPresentableGroupText();
        }
    };
    private static final UsageGroup ourCodeGroup = new CodeUsageGroup(UsageViewBundle.messagePointer("node.group.code.usages", new Object[0]));
    private static final UsageGroup ourDynamicGroup = new DynamicUsageGroup(UsageViewBundle.messagePointer("list.item.dynamic.usages", new Object[0]));
    private static final UsageGroup ourNonCodeGroup = new NonCodeUsageGroup(UsageViewBundle.messagePointer("node.non.code.usages", new Object[0]));
    private final UsageGroup myCodeGroup;
    private final UsageGroup myDynamicCodeGroup;
    private final UsageGroup myNonCodeGroup;

    NonCodeUsageGroupingRule(@Nullable UsageViewPresentation presentation) {
        if (presentation == null) {
            this.myCodeGroup = ourCodeGroup;
            this.myDynamicCodeGroup = ourDynamicGroup;
            this.myNonCodeGroup = ourNonCodeGroup;
        } else {
            this.myCodeGroup = new CodeUsageGroup(() -> NonCodeUsageGroupingRule.buildText(presentation.getCodeUsagesString(), presentation.getScopeText()));
            this.myDynamicCodeGroup = new DynamicUsageGroup(() -> {
                String dynamicCodeUsagesString = presentation.getDynamicCodeUsagesString();
                return dynamicCodeUsagesString != null ? dynamicCodeUsagesString : ourDynamicGroup.getPresentableGroupText();
            });
            this.myNonCodeGroup = new NonCodeUsageGroup(() -> NonCodeUsageGroupingRule.buildText(presentation.getNonCodeUsagesString(), presentation.getScopeText()));
        }
    }

    @Override
    @Nullable
    protected UsageGroup getParentGroupFor(@NotNull Usage usage, UsageTarget @NotNull [] targets) {
        if (usage == null) {
            NonCodeUsageGroupingRule.$$$reportNull$$$0(0);
        }
        if (targets == null) {
            NonCodeUsageGroupingRule.$$$reportNull$$$0(1);
        }
        if (usage instanceof UnknownUsagesInUnloadedModules) {
            return ourUnloadedGroup;
        }
        if (usage instanceof PsiElementUsage) {
            UsageInfo usageInfo;
            if (usage instanceof UsageInfo2UsageAdapter && (usageInfo = ((UsageInfo2UsageAdapter)usage).getUsageInfo()).isDynamicUsage()) {
                return this.myDynamicCodeGroup;
            }
            if (((PsiElementUsage)usage).isNonCodeUsage()) {
                return this.myNonCodeGroup;
            }
            return this.myCodeGroup;
        }
        return null;
    }

    @Override
    public int getRank() {
        return UsageGroupingRulesDefaultRanks.NON_CODE.getAbsoluteRank();
    }

    @Override
    public boolean isGroupingToggleable() {
        return false;
    }

    @Nls
    private static String buildText(String usages, String scope) {
        @NlsSafe StringBuilder text2 = new StringBuilder(usages);
        text2.append(" ").append(UsageViewBundle.message("usage.view.results.node.scope.in", new Object[0]));
        if (StringUtil.isNotEmpty((String)scope)) {
            text2.append(" ").append(scope);
        }
        return text2.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "usage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "targets";
                break;
            }
        }
        objectArray[1] = "com/intellij/usages/impl/rules/NonCodeUsageGroupingRule";
        objectArray[2] = "getParentGroupFor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class NonCodeUsageGroup
    extends DefaultUsageGroup {
        NonCodeUsageGroup(@NotNull @NotNull Supplier<@NlsContexts.ListItem @NotNull String> supplier) {
            if (supplier == null) {
                NonCodeUsageGroup.$$$reportNull$$$0(0);
            }
            super(3, supplier);
        }

        public String toString() {
            return "NonCodeUsages";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "supplier", "com/intellij/usages/impl/rules/NonCodeUsageGroupingRule$NonCodeUsageGroup", "<init>"));
        }
    }

    private static final class DynamicUsageGroup
    extends DefaultUsageGroup {
        DynamicUsageGroup(@NotNull @NotNull Supplier<@NlsContexts.ListItem @NotNull String> supplier) {
            if (supplier == null) {
                DynamicUsageGroup.$$$reportNull$$$0(0);
            }
            super(2, supplier);
        }

        public String toString() {
            return "DynamicUsages";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "supplier", "com/intellij/usages/impl/rules/NonCodeUsageGroupingRule$DynamicUsageGroup", "<init>"));
        }
    }

    private static final class CodeUsageGroup
    extends DefaultUsageGroup {
        CodeUsageGroup(@NotNull @NotNull Supplier<@NlsContexts.ListItem @NotNull String> textSupplier) {
            if (textSupplier == null) {
                CodeUsageGroup.$$$reportNull$$$0(0);
            }
            super(1, textSupplier);
        }

        public String toString() {
            return "CodeUsages";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textSupplier", "com/intellij/usages/impl/rules/NonCodeUsageGroupingRule$CodeUsageGroup", "<init>"));
        }
    }
}

