/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.roots;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import javax.swing.Icon;
import javax.swing.JComponent;

public class ScalableIconComponent
extends JComponent {
    private final Icon myIcon;
    private final Icon mySelectedIcon;
    private boolean myIsSelected = false;

    public ScalableIconComponent(Icon icon2) {
        this(icon2, icon2);
    }

    public ScalableIconComponent(Icon icon2, Icon selectedIcon) {
        this.myIcon = icon2;
        Icon icon3 = this.mySelectedIcon = selectedIcon != null ? selectedIcon : icon2;
        if (icon2 != null) {
            Dimension size = new Dimension(icon2.getIconWidth(), icon2.getIconHeight());
            this.setPreferredSize(size);
            this.setMinimumSize(size);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        Icon icon2;
        Icon icon3 = icon2 = this.myIsSelected ? this.mySelectedIcon : this.myIcon;
        if (icon2 != null) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setBackground(this.getBackground());
            AffineTransform savedTransform = g2.getTransform();
            g2.scale((double)this.getWidth() / (double)icon2.getIconWidth(), (double)this.getHeight() / (double)icon2.getIconHeight());
            icon2.paintIcon(this, g2, 0, 0);
            g2.setTransform(savedTransform);
        }
        super.paintComponent(g);
    }

    public final void setSelected(boolean isSelected) {
        this.myIsSelected = isSelected;
        this.revalidate();
        this.repaint();
    }
}

