/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.paint.RectanglePainter;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class SeparatorWithText
extends JComponent
implements Accessible {
    protected @NlsContexts.Separator String myCaption;
    protected int myPrefWidth;
    protected int myAlignment;
    protected Color myTextForeground;

    public SeparatorWithText() {
        this.setBorder(BorderFactory.createEmptyBorder(SeparatorWithText.getVgap(), 0, SeparatorWithText.getVgap(), 0));
        this.setFont(UIUtil.getLabelFont());
        this.setFont(this.getFont().deriveFont(1));
        this.setForeground(JBUI.CurrentTheme.Popup.separatorColor());
        this.setTextForeground(JBUI.CurrentTheme.Popup.separatorTextColor());
    }

    public Color getTextForeground() {
        return this.myTextForeground;
    }

    public void setTextForeground(@NotNull Color textForeground) {
        if (textForeground == null) {
            SeparatorWithText.$$$reportNull$$$0(0);
        }
        this.myTextForeground = textForeground;
    }

    protected static int getVgap() {
        return UIUtil.isUnderNativeMacLookAndFeel() ? 1 : 3;
    }

    protected static int getHgap() {
        return 3;
    }

    public void setCaptionCentered(boolean captionCentered) {
        this.myAlignment = captionCentered ? 0 : 2;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.isPreferredSizeSet() ? super.getPreferredSize() : this.getPreferredElementSize();
    }

    protected Dimension getPreferredElementSize() {
        Dimension size = this.getLabelSize();
        JBInsets.addTo((Dimension)size, (Insets)this.getInsets());
        return size;
    }

    @NotNull
    protected Dimension getLabelSize() {
        Dimension size = new Dimension(Math.max(this.myPrefWidth, 0), 1);
        String caption = this.getCaption();
        if (caption != null) {
            FontMetrics fm = this.getFontMetrics(this.getFont());
            size.height = fm.getHeight();
            if (this.myPrefWidth < 0) {
                size.width = 2 * SeparatorWithText.getHgap() + fm.stringWidth(caption);
            }
        }
        Dimension dimension = size;
        if (dimension == null) {
            SeparatorWithText.$$$reportNull$$$0(1);
        }
        return dimension;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.isMinimumSizeSet() ? super.getMinimumSize() : this.getPreferredElementSize();
    }

    public void setMinimumWidth(int width) {
        this.myPrefWidth = width;
    }

    @Override
    protected void paintComponent(Graphics g) {
        g.setColor(this.getForeground());
        Rectangle bounds = new Rectangle(this.getWidth(), this.getHeight());
        JBInsets.removeFrom((Rectangle)bounds, (Insets)this.getInsets());
        String caption = this.getCaption();
        if (caption != null) {
            int hGap = SeparatorWithText.getHgap();
            bounds.x += hGap;
            bounds.width -= hGap + hGap;
            Rectangle iconR = new Rectangle();
            Rectangle textR = new Rectangle();
            FontMetrics fm = g.getFontMetrics();
            String label = SwingUtilities.layoutCompoundLabel(fm, caption, null, 0, this.myAlignment, 0, this.myAlignment, bounds, iconR, textR, 0);
            textR.y += fm.getAscent();
            if (caption.equals(label)) {
                int y = textR.y + (int)fm.getLineMetrics(label, g).getStrikethroughOffset();
                this.paintLinePart(g, bounds.x, textR.x, -hGap, y);
                this.paintLinePart(g, textR.x + textR.width, bounds.x + bounds.width, hGap, y);
            }
            UISettings.setupAntialiasing(g);
            g.setColor(this.getTextForeground());
            g.drawString(label, textR.x, textR.y);
        } else {
            this.paintLine(g, bounds.x, bounds.y, bounds.width);
        }
    }

    protected void paintLinePart(Graphics g, int xMin, int xMax, int hGap, int y) {
        if (xMax > xMin) {
            this.paintLine(g, xMin + hGap, y, xMax - xMin);
        }
    }

    protected void paintLine(Graphics g, int x, int y, int width) {
        RectanglePainter.FILL.paint((Graphics2D)g, x, y, width, 1, null);
    }

    @NlsContexts.Separator
    public String getCaption() {
        return this.myCaption == null || this.myCaption.trim().isEmpty() ? null : this.myCaption;
    }

    public void setCaption(@NlsContexts.Separator String captionAboveOf) {
        this.myCaption = captionAboveOf;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleSeparatorWithText();
        }
        return this.accessibleContext;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textForeground";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/SeparatorWithText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/SeparatorWithText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLabelSize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setTextForeground";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected class AccessibleSeparatorWithText
    extends JComponent.AccessibleJComponent {
        protected AccessibleSeparatorWithText() {
            super(SeparatorWithText.this);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LABEL;
        }

        @Override
        public String getAccessibleName() {
            return SeparatorWithText.this.myCaption;
        }
    }
}

