/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.searches;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.IndexPattern;
import com.intellij.psi.search.IndexPatternOccurrence;
import com.intellij.psi.search.IndexPatternProvider;
import com.intellij.psi.search.searches.ExtensibleQueryFactory;
import com.intellij.util.Query;
import com.intellij.util.QueryExecutor;
import org.jetbrains.annotations.NotNull;

public abstract class IndexPatternSearch
extends ExtensibleQueryFactory<IndexPatternOccurrence, SearchParameters> {
    public static final ExtensionPointName<QueryExecutor<IndexPatternOccurrence, SearchParameters>> EP_NAME = ExtensionPointName.create((String)"com.intellij.indexPatternSearch");
    private static IndexPatternSearch ourInstance;

    protected IndexPatternSearch() {
        super(EP_NAME);
    }

    private static IndexPatternSearch getInstance() {
        IndexPatternSearch result = ourInstance;
        if (result == null) {
            ourInstance = result = (IndexPatternSearch)ApplicationManager.getApplication().getService(IndexPatternSearch.class);
        }
        return result;
    }

    @NotNull
    public static Query<IndexPatternOccurrence> search(@NotNull PsiFile file, @NotNull IndexPattern pattern) {
        if (file == null) {
            IndexPatternSearch.$$$reportNull$$$0(0);
        }
        if (pattern == null) {
            IndexPatternSearch.$$$reportNull$$$0(1);
        }
        SearchParameters parameters = new SearchParameters(file, pattern);
        Query<IndexPatternOccurrence> query = IndexPatternSearch.getInstance().createQuery(parameters);
        if (query == null) {
            IndexPatternSearch.$$$reportNull$$$0(2);
        }
        return query;
    }

    @NotNull
    public static Query<IndexPatternOccurrence> search(@NotNull PsiFile file, @NotNull IndexPattern pattern, int startOffset, int endOffset) {
        if (file == null) {
            IndexPatternSearch.$$$reportNull$$$0(3);
        }
        if (pattern == null) {
            IndexPatternSearch.$$$reportNull$$$0(4);
        }
        SearchParameters parameters = new SearchParameters(file, pattern, new TextRange(startOffset, endOffset));
        Query<IndexPatternOccurrence> query = IndexPatternSearch.getInstance().createQuery(parameters);
        if (query == null) {
            IndexPatternSearch.$$$reportNull$$$0(5);
        }
        return query;
    }

    @NotNull
    public static Query<IndexPatternOccurrence> search(@NotNull PsiFile file, @NotNull IndexPatternProvider patternProvider) {
        if (file == null) {
            IndexPatternSearch.$$$reportNull$$$0(6);
        }
        if (patternProvider == null) {
            IndexPatternSearch.$$$reportNull$$$0(7);
        }
        SearchParameters parameters = new SearchParameters(file, patternProvider);
        Query<IndexPatternOccurrence> query = IndexPatternSearch.getInstance().createQuery(parameters);
        if (query == null) {
            IndexPatternSearch.$$$reportNull$$$0(8);
        }
        return query;
    }

    @NotNull
    public static Query<IndexPatternOccurrence> search(@NotNull PsiFile file, @NotNull IndexPatternProvider patternProvider, boolean multiLineOccurrences) {
        if (file == null) {
            IndexPatternSearch.$$$reportNull$$$0(9);
        }
        if (patternProvider == null) {
            IndexPatternSearch.$$$reportNull$$$0(10);
        }
        SearchParameters parameters = new SearchParameters(file, patternProvider, multiLineOccurrences);
        Query<IndexPatternOccurrence> query = IndexPatternSearch.getInstance().createQuery(parameters);
        if (query == null) {
            IndexPatternSearch.$$$reportNull$$$0(11);
        }
        return query;
    }

    @NotNull
    public static Query<IndexPatternOccurrence> search(@NotNull PsiFile file, @NotNull IndexPatternProvider patternProvider, int startOffset, int endOffset) {
        if (file == null) {
            IndexPatternSearch.$$$reportNull$$$0(12);
        }
        if (patternProvider == null) {
            IndexPatternSearch.$$$reportNull$$$0(13);
        }
        SearchParameters parameters = new SearchParameters(file, patternProvider, new TextRange(startOffset, endOffset));
        Query<IndexPatternOccurrence> query = IndexPatternSearch.getInstance().createQuery(parameters);
        if (query == null) {
            IndexPatternSearch.$$$reportNull$$$0(14);
        }
        return query;
    }

    public static int getOccurrencesCount(@NotNull PsiFile file, @NotNull IndexPatternProvider patternProvider) {
        if (file == null) {
            IndexPatternSearch.$$$reportNull$$$0(15);
        }
        if (patternProvider == null) {
            IndexPatternSearch.$$$reportNull$$$0(16);
        }
        return IndexPatternSearch.getInstance().getOccurrencesCountImpl(file, patternProvider);
    }

    public static int getOccurrencesCount(@NotNull PsiFile file, @NotNull IndexPattern pattern) {
        if (file == null) {
            IndexPatternSearch.$$$reportNull$$$0(17);
        }
        if (pattern == null) {
            IndexPatternSearch.$$$reportNull$$$0(18);
        }
        return IndexPatternSearch.getInstance().getOccurrencesCountImpl(file, pattern);
    }

    protected abstract int getOccurrencesCountImpl(@NotNull PsiFile var1, @NotNull IndexPatternProvider var2);

    protected abstract int getOccurrencesCountImpl(@NotNull PsiFile var1, @NotNull IndexPattern var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 4: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/search/searches/IndexPatternSearch";
                break;
            }
            case 7: 
            case 10: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/search/searches/IndexPatternSearch";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "search";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "search";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: 
            case 14: {
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getOccurrencesCount";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class SearchParameters {
        private final PsiFile myFile;
        private final IndexPattern myPattern;
        private final IndexPatternProvider myPatternProvider;
        private final TextRange myRange;
        private final boolean myMultiLine;

        public SearchParameters(@NotNull PsiFile file, @NotNull IndexPattern pattern) {
            if (file == null) {
                SearchParameters.$$$reportNull$$$0(0);
            }
            if (pattern == null) {
                SearchParameters.$$$reportNull$$$0(1);
            }
            this(file, pattern, null);
        }

        public SearchParameters(@NotNull PsiFile file, @NotNull IndexPattern pattern, TextRange range2) {
            if (file == null) {
                SearchParameters.$$$reportNull$$$0(2);
            }
            if (pattern == null) {
                SearchParameters.$$$reportNull$$$0(3);
            }
            this.myFile = file;
            this.myRange = range2;
            this.myPatternProvider = null;
            this.myPattern = pattern;
            this.myMultiLine = false;
        }

        public SearchParameters(@NotNull PsiFile file, @NotNull IndexPatternProvider patternProvider) {
            if (file == null) {
                SearchParameters.$$$reportNull$$$0(4);
            }
            if (patternProvider == null) {
                SearchParameters.$$$reportNull$$$0(5);
            }
            this(file, patternProvider, null, false);
        }

        public SearchParameters(@NotNull PsiFile file, @NotNull IndexPatternProvider patternProvider, boolean multiLine) {
            if (file == null) {
                SearchParameters.$$$reportNull$$$0(6);
            }
            if (patternProvider == null) {
                SearchParameters.$$$reportNull$$$0(7);
            }
            this(file, patternProvider, null, multiLine);
        }

        public SearchParameters(@NotNull PsiFile file, @NotNull IndexPatternProvider patternProvider, TextRange range2) {
            if (file == null) {
                SearchParameters.$$$reportNull$$$0(8);
            }
            if (patternProvider == null) {
                SearchParameters.$$$reportNull$$$0(9);
            }
            this(file, patternProvider, range2, false);
        }

        private SearchParameters(@NotNull PsiFile file, @NotNull IndexPatternProvider patternProvider, TextRange range2, boolean multiLine) {
            if (file == null) {
                SearchParameters.$$$reportNull$$$0(10);
            }
            if (patternProvider == null) {
                SearchParameters.$$$reportNull$$$0(11);
            }
            this.myFile = file;
            this.myPatternProvider = patternProvider;
            this.myRange = range2;
            this.myPattern = null;
            this.myMultiLine = multiLine;
        }

        @NotNull
        public PsiFile getFile() {
            PsiFile psiFile = this.myFile;
            if (psiFile == null) {
                SearchParameters.$$$reportNull$$$0(12);
            }
            return psiFile;
        }

        public IndexPattern getPattern() {
            return this.myPattern;
        }

        public IndexPatternProvider getPatternProvider() {
            return this.myPatternProvider;
        }

        public TextRange getRange() {
            return this.myRange;
        }

        public boolean isMultiLine() {
            return this.myMultiLine;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 12: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 12: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pattern";
                    break;
                }
                case 5: 
                case 7: 
                case 9: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "patternProvider";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/search/searches/IndexPatternSearch$SearchParameters";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/search/searches/IndexPatternSearch$SearchParameters";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 12: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 12: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

