/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiReferenceBase<T extends PsiElement>
implements PsiReference {
    private static final Logger LOG = Logger.getInstance(PsiReferenceBase.class);
    protected final T myElement;
    private TextRange myRangeInElement;
    protected boolean mySoft;

    public PsiReferenceBase(@NotNull T element, TextRange rangeInElement, boolean soft) {
        if (element == null) {
            PsiReferenceBase.$$$reportNull$$$0(0);
        }
        this.myElement = element;
        this.myRangeInElement = rangeInElement;
        this.mySoft = soft;
    }

    public PsiReferenceBase(@NotNull T element, TextRange rangeInElement) {
        if (element == null) {
            PsiReferenceBase.$$$reportNull$$$0(1);
        }
        this(element);
        this.myRangeInElement = rangeInElement;
    }

    public PsiReferenceBase(@NotNull T element, boolean soft) {
        if (element == null) {
            PsiReferenceBase.$$$reportNull$$$0(2);
        }
        this.myElement = element;
        this.mySoft = soft;
    }

    public PsiReferenceBase(@NotNull T element) {
        if (element == null) {
            PsiReferenceBase.$$$reportNull$$$0(3);
        }
        this.myElement = element;
        this.mySoft = false;
    }

    public void setRangeInElement(TextRange rangeInElement) {
        this.myRangeInElement = rangeInElement;
    }

    @NotNull
    @NlsSafe
    public String getValue() {
        String string;
        String text2 = this.myElement.getText();
        TextRange range2 = this.getRangeInElement();
        try {
            string = range2.substring(text2);
        }
        catch (StringIndexOutOfBoundsException e) {
            LOG.error("Wrong range in reference " + this + ": " + range2 + ". Reference text: '" + text2 + "'", (Throwable)e);
            String string2 = text2;
            if (string2 == null) {
                PsiReferenceBase.$$$reportNull$$$0(5);
            }
            return string2;
        }
        if (string == null) {
            PsiReferenceBase.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public T getElement() {
        T t = this.myElement;
        if (t == null) {
            PsiReferenceBase.$$$reportNull$$$0(6);
        }
        return t;
    }

    @Override
    @NotNull
    public TextRange getRangeInElement() {
        TextRange rangeInElement = this.myRangeInElement;
        if (rangeInElement == null) {
            this.myRangeInElement = rangeInElement = this.calculateDefaultRangeInElement();
        }
        TextRange textRange = rangeInElement;
        if (textRange == null) {
            PsiReferenceBase.$$$reportNull$$$0(7);
        }
        return textRange;
    }

    protected TextRange calculateDefaultRangeInElement() {
        return this.getManipulator().getRangeInElement(this.myElement);
    }

    @Override
    @NotNull
    @NlsSafe
    public String getCanonicalText() {
        String string = this.getValue();
        if (string == null) {
            PsiReferenceBase.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            PsiReferenceBase.$$$reportNull$$$0(9);
        }
        return this.getManipulator().handleContentChange(this.myElement, this.getRangeInElement(), newElementName);
    }

    @Override
    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            PsiReferenceBase.$$$reportNull$$$0(10);
        }
        throw new IncorrectOperationException("Rebind cannot be performed for " + this.getClass());
    }

    @Override
    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            PsiReferenceBase.$$$reportNull$$$0(11);
        }
        return this.getElement().getManager().areElementsEquivalent(this.resolve(), element);
    }

    public static <T extends PsiElement> PsiReferenceBase<T> createSelfReference(T element, PsiElement resolveTo) {
        return new Immediate<T>(element, true, resolveTo);
    }

    public static <T extends PsiElement> PsiReferenceBase<T> createSelfReference(T element, TextRange rangeInElement, PsiElement resolveTo) {
        return new Immediate<T>(element, rangeInElement, resolveTo);
    }

    private ElementManipulator<T> getManipulator() {
        ElementManipulator<T> manipulator = ElementManipulators.getManipulator(this.myElement);
        if (manipulator == null) {
            LOG.error((Throwable)PluginException.createByClass("Cannot find manipulator for " + this.myElement + " in " + this + " class " + this.getClass(), null, this.myElement.getClass()));
        }
        return manipulator;
    }

    @Override
    public boolean isSoft() {
        return this.mySoft;
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.myElement + ":" + this.myRangeInElement + ")";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/PsiReferenceBase";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/PsiReferenceBase";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getValue";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Immediate<T extends PsiElement>
    extends PsiReferenceBase<T> {
        private final PsiElement myResolveTo;

        public Immediate(T element, TextRange rangeInElement, boolean soft, PsiElement resolveTo) {
            super(element, rangeInElement, soft);
            this.myResolveTo = resolveTo;
        }

        public Immediate(T element, TextRange rangeInElement, PsiElement resolveTo) {
            super(element, rangeInElement);
            this.myResolveTo = resolveTo;
        }

        public Immediate(T element, boolean soft, PsiElement resolveTo) {
            super(element, soft);
            this.myResolveTo = resolveTo;
        }

        public Immediate(@NotNull T element, PsiElement resolveTo) {
            if (element == null) {
                Immediate.$$$reportNull$$$0(0);
            }
            super(element);
            this.myResolveTo = resolveTo;
        }

        @Override
        public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
            if (newElementName == null) {
                Immediate.$$$reportNull$$$0(1);
            }
            return this.getElement();
        }

        @Override
        @Nullable
        public PsiElement resolve() {
            return this.myResolveTo;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newElementName";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/PsiReferenceBase$Immediate";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "handleElementRename";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static abstract class Poly<T extends PsiElement>
    extends PsiReferenceBase<T>
    implements PsiPolyVariantReference {
        public Poly(T psiElement) {
            super(psiElement);
        }

        public Poly(T element, boolean soft) {
            super(element, soft);
        }

        public Poly(T element, TextRange rangeInElement, boolean soft) {
            super(element, rangeInElement, soft);
        }

        @Override
        public boolean isReferenceTo(@NotNull PsiElement element) {
            ResolveResult[] results;
            if (element == null) {
                Poly.$$$reportNull$$$0(0);
            }
            for (ResolveResult result : results = this.multiResolve(false)) {
                if (!element.getManager().areElementsEquivalent(result.getElement(), element)) continue;
                return true;
            }
            return false;
        }

        @Override
        @Nullable
        public PsiElement resolve() {
            ResolveResult[] resolveResults = this.multiResolve(false);
            return resolveResults.length == 1 ? resolveResults[0].getElement() : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/PsiReferenceBase$Poly", "isReferenceTo"));
        }
    }
}

