/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem;

import com.intellij.openapi.externalSystem.ExternalProjectSystemRegistryImpl;
import com.intellij.openapi.externalSystem.ExternalSystemModulePropertyManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ExternalProjectSystemRegistry;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0005H\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/openapi/externalSystem/ExternalProjectSystemRegistryImpl;", "Lcom/intellij/openapi/roots/ExternalProjectSystemRegistry;", "()V", "idToSource", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/intellij/openapi/roots/ProjectModelExternalSource;", "getExternalSource", "module", "Lcom/intellij/openapi/module/Module;", "getSourceById", "id", "ProjectModelExternalSourceImpl", "intellij.platform.externalSystem"})
public final class ExternalProjectSystemRegistryImpl
implements ExternalProjectSystemRegistry {
    private final ConcurrentHashMap<String, ProjectModelExternalSource> idToSource = new ConcurrentHashMap();

    @Override
    @Nullable
    public ProjectModelExternalSource getExternalSource(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        ExternalSystemModulePropertyManager modulePropertyManager = ExternalSystemModulePropertyManager.Companion.getInstance(module);
        String externalSystemId = modulePropertyManager.getExternalSystemId();
        if (externalSystemId != null) {
            return this.getSourceById(externalSystemId);
        }
        if (modulePropertyManager.isMavenized()) {
            return this.getSourceById("Maven");
        }
        return null;
    }

    @Override
    @NotNull
    public ProjectModelExternalSource getSourceById(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        ProjectModelExternalSource projectModelExternalSource = this.idToSource.computeIfAbsent(id, getSourceById.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)projectModelExternalSource, (String)"idToSource.computeIfAbse\u2026ExternalSourceImpl(it) })");
        return projectModelExternalSource;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\r\u0010\u0007\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0006H\u0016J\b\u0010\b\u001a\u00020\u0003H\u0016R\u0013\u0010\u0005\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/openapi/externalSystem/ExternalProjectSystemRegistryImpl$ProjectModelExternalSourceImpl;", "Lcom/intellij/openapi/roots/ProjectModelExternalSource;", "myId", "", "(Ljava/lang/String;)V", "displayName", "Lorg/jetbrains/annotations/NotNull;", "getDisplayName", "getId", "intellij.platform.externalSystem"})
    private static final class ProjectModelExternalSourceImpl
    implements ProjectModelExternalSource {
        private final String displayName;
        private final String myId;

        @Override
        @NotNull
        public String getDisplayName() {
            return this.displayName;
        }

        @Override
        @NotNull
        public String getId() {
            return this.myId;
        }

        public ProjectModelExternalSourceImpl(@NotNull String myId) {
            Intrinsics.checkNotNullParameter((Object)myId, (String)"myId");
            String string = this.myId = myId;
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"Locale.US");
            Locale locale2 = locale;
            boolean bl = false;
            String string2 = string;
            boolean bl2 = false;
            String string3 = string2;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.toLowerCase(locale2);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toLowerCase(locale)");
            String string5 = StringUtil.capitalize((String)string4);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"StringUtil.capitalize(myId.toLowerCase(Locale.US))");
            this.displayName = string5;
        }
    }
}

