/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor;

import com.intellij.codeStyle.CodeStyleFacade;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.SoftWrap;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class EditorModificationUtilEx {
    public static void deleteSelectedText(Editor editor) {
        SelectionModel selectionModel = editor.getSelectionModel();
        if (!selectionModel.hasSelection()) {
            return;
        }
        int selectionStart = selectionModel.getSelectionStart();
        int selectionEnd = selectionModel.getSelectionEnd();
        VisualPosition selectionStartPosition = selectionModel.getSelectionStartPosition();
        if (editor.isColumnMode() && editor.getCaretModel().supportsMultipleCarets() && selectionStartPosition != null) {
            editor.getCaretModel().moveToVisualPosition(selectionStartPosition);
        } else {
            editor.getCaretModel().moveToOffset(selectionStart);
        }
        selectionModel.removeSelection();
        editor.getDocument().deleteString(selectionStart, selectionEnd);
        EditorModificationUtilEx.scrollToCaret(editor);
    }

    public static void insertStringAtCaret(Editor editor, @NotNull String s) {
        if (s == null) {
            EditorModificationUtilEx.$$$reportNull$$$0(0);
        }
        EditorModificationUtilEx.insertStringAtCaret(editor, s, false, true);
    }

    public static int insertStringAtCaret(Editor editor, @NotNull String s, boolean toProcessOverwriteMode) {
        if (s == null) {
            EditorModificationUtilEx.$$$reportNull$$$0(1);
        }
        return EditorModificationUtilEx.insertStringAtCaret(editor, s, toProcessOverwriteMode, s.length());
    }

    public static int insertStringAtCaret(Editor editor, @NotNull String s, boolean toProcessOverwriteMode, boolean toMoveCaret) {
        if (s == null) {
            EditorModificationUtilEx.$$$reportNull$$$0(2);
        }
        return EditorModificationUtilEx.insertStringAtCaret(editor, s, toProcessOverwriteMode, toMoveCaret, s.length());
    }

    public static int insertStringAtCaret(Editor editor, @NotNull String s, boolean toProcessOverwriteMode, int caretShift) {
        if (s == null) {
            EditorModificationUtilEx.$$$reportNull$$$0(3);
        }
        return EditorModificationUtilEx.insertStringAtCaret(editor, s, toProcessOverwriteMode, true, caretShift);
    }

    public static int insertStringAtCaret(Editor editor, @NotNull String s, boolean toProcessOverwriteMode, boolean toMoveCaret, int caretShift) {
        if (s == null) {
            EditorModificationUtilEx.$$$reportNull$$$0(4);
        }
        int result = EditorModificationUtilEx.insertStringAtCaretNoScrolling(editor, s, toProcessOverwriteMode, toMoveCaret, caretShift);
        if (toMoveCaret) {
            EditorModificationUtilEx.scrollToCaret(editor);
        }
        return result;
    }

    protected static int insertStringAtCaretNoScrolling(Editor editor, @NotNull String s, boolean toProcessOverwriteMode, boolean toMoveCaret, int caretShift) {
        String filler;
        if (s == null) {
            EditorModificationUtilEx.$$$reportNull$$$0(5);
        }
        editor.getSoftWrapModel().beforeDocumentChangeAtCaret();
        int oldOffset = editor.getSelectionModel().getSelectionStart();
        String string = filler = editor.getSelectionModel().hasSelection() ? "" : EditorModificationUtilEx.calcStringToFillVirtualSpace(editor);
        if (filler.length() > 0) {
            s = filler + (String)s;
        }
        Document document = editor.getDocument();
        SelectionModel selectionModel = editor.getSelectionModel();
        if (editor.isInsertMode() || !toProcessOverwriteMode) {
            if (selectionModel.hasSelection()) {
                document.replaceString(selectionModel.getSelectionStart(), selectionModel.getSelectionEnd(), (CharSequence)s);
            } else {
                document.insertString(oldOffset, (CharSequence)s);
            }
        } else {
            EditorModificationUtilEx.deleteSelectedText(editor);
            if (((String)s).length() == 1 && Character.isLowSurrogate(((String)s).charAt(0)) && oldOffset > 0 && Character.isHighSurrogate(document.getImmutableCharSequence().charAt(oldOffset - 1))) {
                document.insertString(oldOffset, (CharSequence)s);
            } else {
                int endOffset;
                int lineNumber = editor.getCaretModel().getLogicalPosition().line;
                int lineEndOffset = document.getLineEndOffset(lineNumber);
                int inputCodePointCount = ((String)s).codePointCount(0, ((String)s).length());
                try {
                    endOffset = Math.min(lineEndOffset, Character.offsetByCodePoints(document.getImmutableCharSequence(), oldOffset, inputCodePointCount));
                }
                catch (IndexOutOfBoundsException e) {
                    endOffset = lineEndOffset;
                }
                document.replaceString(oldOffset, endOffset, (CharSequence)s);
            }
        }
        int offset = oldOffset + filler.length() + caretShift;
        if (toMoveCaret) {
            editor.getCaretModel().moveToVisualPosition(editor.offsetToVisualPosition(offset, false, true));
            selectionModel.removeSelection();
        } else if (editor.getCaretModel().getOffset() != oldOffset) {
            editor.getCaretModel().moveToOffset(oldOffset);
        }
        return offset;
    }

    public static String calcStringToFillVirtualSpace(Editor editor) {
        int afterLineEnd = EditorModificationUtilEx.calcAfterLineEnd(editor);
        if (afterLineEnd > 0) {
            return EditorModificationUtilEx.calcStringToFillVirtualSpace(editor, afterLineEnd);
        }
        return "";
    }

    public static String calcStringToFillVirtualSpace(Editor editor, int afterLineEnd) {
        boolean atLineStart;
        Project project = editor.getProject();
        StringBuilder buf = new StringBuilder();
        Document doc = editor.getDocument();
        int caretOffset = editor.getCaretModel().getOffset();
        boolean bl = atLineStart = caretOffset >= doc.getTextLength() || doc.getLineStartOffset(doc.getLineNumber(caretOffset)) == caretOffset;
        if (atLineStart && project != null) {
            String properIndent;
            int offset = editor.getCaretModel().getOffset();
            PsiDocumentManager.getInstance(project).commitDocument(doc);
            String string = properIndent = offset >= doc.getTextLength() ? "" : CodeStyleFacade.getInstance(project).getLineIndent(doc, offset);
            if (properIndent != null) {
                int tabSize = editor.getSettings().getTabSize(project);
                for (int i = 0; i < properIndent.length(); ++i) {
                    if (properIndent.charAt(i) == ' ') {
                        --afterLineEnd;
                    } else if (properIndent.charAt(i) == '\t') {
                        if (afterLineEnd < tabSize) break;
                        afterLineEnd -= tabSize;
                    }
                    buf.append(properIndent.charAt(i));
                    if (afterLineEnd != 0) {
                        continue;
                    }
                    break;
                }
            } else {
                EditorSettings editorSettings = editor.getSettings();
                boolean useTab = editorSettings.isUseTabCharacter(editor.getProject());
                if (useTab) {
                    int tabSize = editorSettings.getTabSize(project);
                    while (afterLineEnd >= tabSize) {
                        buf.append('\t');
                        afterLineEnd -= tabSize;
                    }
                }
            }
        }
        for (int i = 0; i < afterLineEnd; ++i) {
            buf.append(' ');
        }
        return buf.toString();
    }

    public static void scrollToCaret(@NotNull Editor editor) {
        if (editor == null) {
            EditorModificationUtilEx.$$$reportNull$$$0(6);
        }
        if (editor.getCaretModel().getCurrentCaret() == editor.getCaretModel().getPrimaryCaret()) {
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        }
    }

    public static int calcAfterLineEnd(Editor editor) {
        CaretModel caretModel = editor.getCaretModel();
        int caretOffset = caretModel.getOffset();
        LogicalPosition logicalPosition = caretModel.getLogicalPosition();
        VisualPosition visualPosition = caretModel.getVisualPosition();
        return EditorModificationUtilEx.calcAfterLineEnd(editor, caretOffset, logicalPosition, visualPosition);
    }

    @ApiStatus.Experimental
    public static int calcAfterLineEnd(Editor editor, int caretOffset, LogicalPosition logicalPosition, VisualPosition visualPosition) {
        Document document = editor.getDocument();
        int lineNumber = logicalPosition.line;
        int columnNumber = logicalPosition.column;
        if (lineNumber >= document.getLineCount()) {
            return columnNumber;
        }
        int anchorLineEndOffset = document.getLineEndOffset(lineNumber);
        List<? extends SoftWrap> softWraps = editor.getSoftWrapModel().getSoftWrapsForLine(logicalPosition.line);
        for (SoftWrap softWrap : softWraps) {
            boolean visuallyBeforeSoftWrap;
            if (!editor.getSoftWrapModel().isVisible(softWrap)) continue;
            int softWrapOffset = softWrap.getStart();
            if (softWrapOffset == caretOffset) {
                VisualPosition position = editor.offsetToVisualPosition(caretOffset - 1);
                if (position.line == visualPosition.line) {
                    return visualPosition.column - position.column - 1;
                }
            }
            if (softWrapOffset > caretOffset) {
                anchorLineEndOffset = softWrapOffset;
                break;
            }
            if (softWrapOffset != caretOffset || !(visuallyBeforeSoftWrap = visualPosition.line < editor.offsetToVisualPosition((int)caretOffset).line)) continue;
            anchorLineEndOffset = softWrapOffset;
            break;
        }
        int lineEndColumnNumber = editor.offsetToLogicalPosition((int)anchorLineEndOffset).column;
        return columnNumber - lineEndColumnNumber;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/editor/EditorModificationUtilEx";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "insertStringAtCaret";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "insertStringAtCaretNoScrolling";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "scrollToCaret";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

