/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class InjectedDataKeys {
    private static final String ourInjectedPrefix = "$injected$.";
    private static final Map<String, String> ourInjectableIds = new HashMap<String, String>();
    public static final DataKey<Editor> EDITOR = InjectedDataKeys.injectedKey(CommonDataKeys.EDITOR);
    public static final DataKey<Caret> CARET = InjectedDataKeys.injectedKey(CommonDataKeys.CARET);
    public static final DataKey<VirtualFile> VIRTUAL_FILE = InjectedDataKeys.injectedKey(CommonDataKeys.VIRTUAL_FILE);
    public static final DataKey<PsiFile> PSI_FILE = InjectedDataKeys.injectedKey(CommonDataKeys.PSI_FILE);
    public static final DataKey<PsiElement> PSI_ELEMENT = InjectedDataKeys.injectedKey(CommonDataKeys.PSI_ELEMENT);
    public static final DataKey<Language> LANGUAGE = InjectedDataKeys.injectedKey(CommonDataKeys.LANGUAGE);

    private InjectedDataKeys() {
    }

    @ApiStatus.Internal
    @Nullable
    public static String injectedId(@NotNull String dataId) {
        if (dataId == null) {
            InjectedDataKeys.$$$reportNull$$$0(0);
        }
        return ourInjectableIds.get(dataId);
    }

    @ApiStatus.Internal
    @Nullable
    public static String uninjectedId(@NotNull String dataId) {
        if (dataId == null) {
            InjectedDataKeys.$$$reportNull$$$0(1);
        }
        return dataId.startsWith(ourInjectedPrefix) ? dataId.substring(ourInjectedPrefix.length()) : null;
    }

    @NotNull
    private static <T> DataKey<T> injectedKey(@NotNull DataKey<T> key) {
        if (key == null) {
            InjectedDataKeys.$$$reportNull$$$0(2);
        }
        String injectedId = ourInjectedPrefix + key.getName();
        ourInjectableIds.put(key.getName(), injectedId);
        DataKey dataKey = DataKey.create((String)injectedId);
        if (dataKey == null) {
            InjectedDataKeys.$$$reportNull$$$0(3);
        }
        return dataKey;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/actionSystem/InjectedDataKeys";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/actionSystem/InjectedDataKeys";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "injectedKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "injectedId";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "uninjectedId";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "injectedKey";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

