/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.editor.PlatformEditorBundle;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.ui.GraphicsUtil;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public enum AntialiasingType {
    SUBPIXEL("Subpixel", () -> PlatformEditorBundle.message("settings.editor.antialiasing.subpixel", new Object[0]), RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB, true),
    GREYSCALE("Greyscale", () -> PlatformEditorBundle.message("settings.editor.antialiasing.greyscale", new Object[0]), RenderingHints.VALUE_TEXT_ANTIALIAS_ON, true),
    OFF("No antialiasing", () -> PlatformEditorBundle.message("settings.editor.antialiasing.no.antialiasing", new Object[0]), RenderingHints.VALUE_TEXT_ANTIALIAS_OFF, false);

    private final String mySerializationName;
    private final Supplier<@Nls(capitalization=Nls.Capitalization.Sentence) String> myPresentableName;
    private final Object myHint;
    private final boolean isEnabled;

    public static Object getAAHintForSwingComponent() {
        UISettings uiSettings = UISettings.getInstanceOrNull();
        if (uiSettings == null) {
            return GREYSCALE.getTextInfo();
        }
        return uiSettings.getIdeAAType().getTextInfo();
    }

    public static boolean canUseSubpixelAAForIDE() {
        return !SystemInfo.isMacOSMojave || Boolean.getBoolean("enable.macos.ide.subpixelAA");
    }

    public static boolean canUseSubpixelAAForEditor() {
        return !SystemInfo.isMacOSBigSur || Boolean.getBoolean("enable.macos.editor.subpixelAA");
    }

    public static Object getKeyForCurrentScope(boolean inEditor) {
        UISettings uiSettings = UISettings.getInstanceOrNull();
        if (uiSettings != null) {
            AntialiasingType type = inEditor ? uiSettings.getEditorAAType() : uiSettings.getIdeAAType();
            return type.myHint;
        }
        return RenderingHints.VALUE_TEXT_ANTIALIAS_ON;
    }

    public static FontRenderContext updateContext(@NotNull FontRenderContext context, boolean inEditor) {
        Object aaHint;
        if (context == null) {
            AntialiasingType.$$$reportNull$$$0(0);
        }
        return (aaHint = AntialiasingType.getKeyForCurrentScope(inEditor)) == context.getAntiAliasingHint() ? context : new FontRenderContext(context.getTransform(), aaHint, context.getFractionalMetricsHint());
    }

    private AntialiasingType(String serializationName, Supplier<String> presentableName, Object hint, boolean enabled) {
        this.mySerializationName = serializationName;
        this.myPresentableName = presentableName;
        this.myHint = hint;
        this.isEnabled = enabled;
    }

    public Object getTextInfo() {
        return this.isEnabled || SystemInfo.isJetBrainsJvm ? GraphicsUtil.createAATextInfo((Object)this.myHint) : null;
    }

    @NonNls
    public String toString() {
        return this.mySerializationName;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    public String getPresentableName() {
        return this.myPresentableName.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/ide/ui/AntialiasingType", "updateContext"));
    }
}

