/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting.service;

import com.intellij.CodeStyleBundle;
import com.intellij.formatting.FormattingContext;
import com.intellij.formatting.service.AbstractDocumentFormattingService;
import com.intellij.formatting.service.AsyncFormattingRequest;
import com.intellij.formatting.service.DocumentMerger;
import com.intellij.formatting.service.FormattingNotificationService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.containers.ContainerUtil;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public abstract class AsyncDocumentFormattingService
extends AbstractDocumentFormattingService {
    private static final Logger LOG = Logger.getInstance(AsyncDocumentFormattingService.class);
    private final List<AsyncFormattingRequest> myPendingRequests = Collections.synchronizedList(new ArrayList());
    protected static final Duration DEFAULT_TIMEOUT = Duration.ofSeconds(30L);
    private static final int RETRY_PERIOD = 1000;

    @Override
    public final synchronized void formatDocument(@NotNull Document document, @NotNull List<TextRange> formattingRanges, @NotNull FormattingContext formattingContext, boolean canChangeWhiteSpaceOnly, boolean quickFormat) {
        AsyncFormattingRequest currRequest;
        if (document == null) {
            AsyncDocumentFormattingService.$$$reportNull$$$0(0);
        }
        if (formattingRanges == null) {
            AsyncDocumentFormattingService.$$$reportNull$$$0(1);
        }
        if (formattingContext == null) {
            AsyncDocumentFormattingService.$$$reportNull$$$0(2);
        }
        if ((currRequest = this.findPendingRequest(document)) != null && !((FormattingRequestImpl)currRequest).cancel()) {
            LOG.warn("Pending request can't be cancelled");
            return;
        }
        FormattingRequestImpl formattingRequest = new FormattingRequestImpl(formattingContext, document, formattingRanges, canChangeWhiteSpaceOnly, quickFormat);
        FormattingTask formattingTask = this.createFormattingTask(formattingRequest);
        if (formattingTask != null) {
            formattingRequest.setTask(formattingTask);
            if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
                this.runAsyncFormat(formattingRequest, null);
            } else if (formattingTask.isRunUnderProgress()) {
                new FormattingProgressTask(formattingRequest).setCancelText(CodeStyleBundle.message("async.formatting.service.cancel", this.getName())).queue();
            } else {
                ApplicationManager.getApplication().executeOnPooledThread(() -> this.runAsyncFormat(formattingRequest, null));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private AsyncFormattingRequest findPendingRequest(@NotNull Document document) {
        if (document == null) {
            AsyncDocumentFormattingService.$$$reportNull$$$0(3);
        }
        List<AsyncFormattingRequest> list = this.myPendingRequests;
        synchronized (list) {
            return (AsyncFormattingRequest)ContainerUtil.find(this.myPendingRequests, request -> ((FormattingRequestImpl)request).getDocument() == document);
        }
    }

    private void runAsyncFormat(@NotNull FormattingRequestImpl formattingRequest, @Nullable ProgressIndicator indicator) {
        if (formattingRequest == null) {
            AsyncDocumentFormattingService.$$$reportNull$$$0(4);
        }
        this.myPendingRequests.add(formattingRequest);
        try {
            formattingRequest.runTask(indicator);
        }
        finally {
            this.myPendingRequests.remove(formattingRequest);
        }
    }

    @Nullable
    protected abstract FormattingTask createFormattingTask(@NotNull AsyncFormattingRequest var1);

    @NotNull
    protected abstract String getNotificationGroupId();

    @NotNull
    @NlsSafe
    protected abstract String getName();

    protected Duration getTimeout() {
        return DEFAULT_TIMEOUT;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formattingRanges";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formattingContext";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formattingRequest";
                break;
            }
        }
        objectArray2[1] = "com/intellij/formatting/service/AsyncDocumentFormattingService";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "formatDocument";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findPendingRequest";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "runAsyncFormat";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class FormattingProgressTask
    extends Task.Backgroundable {
        private final FormattingRequestImpl myRequest;

        private FormattingProgressTask(FormattingRequestImpl request) {
            if (request == null) {
                FormattingProgressTask.$$$reportNull$$$0(0);
            }
            super(request.getContext().getProject(), CodeStyleBundle.message("async.formatting.service.running", AsyncDocumentFormattingService.this.getName()), true);
            this.myRequest = request;
        }

        @Override
        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                FormattingProgressTask.$$$reportNull$$$0(1);
            }
            indicator.setIndeterminate(false);
            indicator.setFraction(0.0);
            AsyncDocumentFormattingService.this.runAsyncFormat(this.myRequest, indicator);
            indicator.setFraction(1.0);
        }

        @Override
        public void onCancel() {
            this.myRequest.cancel();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/formatting/service/AsyncDocumentFormattingService$FormattingProgressTask";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "run";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static interface FormattingTask
    extends Runnable {
        public boolean cancel();

        default public boolean isRunUnderProgress() {
            return false;
        }
    }

    private class FormattingRequestImpl
    implements AsyncFormattingRequest {
        private final Document myDocument;
        private final List<TextRange> myRanges;
        private final long myInitialModificationStamp;
        private final FormattingContext myContext;
        private final boolean myCanChangeWhitespaceOnly;
        private final boolean myQuickFormat;
        private final Semaphore myTaskSemaphore;
        @Nullable
        private volatile FormattingTask myTask;
        private final AtomicReference<FormattingRequestState> myStateRef;

        private FormattingRequestImpl(@NotNull FormattingContext formattingContext, @NotNull Document document, List<TextRange> ranges2, boolean canChangeWhitespaceOnly, boolean quickFormat) {
            if (formattingContext == null) {
                FormattingRequestImpl.$$$reportNull$$$0(0);
            }
            if (document == null) {
                FormattingRequestImpl.$$$reportNull$$$0(1);
            }
            if (ranges2 == null) {
                FormattingRequestImpl.$$$reportNull$$$0(2);
            }
            this.myTaskSemaphore = new Semaphore(1);
            this.myStateRef = new AtomicReference<FormattingRequestState>(FormattingRequestState.NOT_STARTED);
            this.myContext = formattingContext;
            this.myDocument = document;
            this.myRanges = ranges2;
            this.myCanChangeWhitespaceOnly = canChangeWhitespaceOnly;
            this.myInitialModificationStamp = document.getModificationStamp();
            this.myQuickFormat = quickFormat;
        }

        @Override
        @NotNull
        public String getDocumentText() {
            String string = this.myDocument.getText();
            if (string == null) {
                FormattingRequestImpl.$$$reportNull$$$0(3);
            }
            return string;
        }

        private boolean cancel() {
            FormattingTask formattingTask = this.myTask;
            if (formattingTask != null && this.myStateRef.compareAndSet(FormattingRequestState.RUNNING, FormattingRequestState.CANCELLING) && formattingTask.cancel()) {
                this.myStateRef.set(FormattingRequestState.CANCELLED);
                this.myTaskSemaphore.release();
                return true;
            }
            return false;
        }

        private Document getDocument() {
            return this.myDocument;
        }

        @Override
        @NotNull
        public List<TextRange> getFormattingRanges() {
            List<TextRange> list = this.myRanges;
            if (list == null) {
                FormattingRequestImpl.$$$reportNull$$$0(4);
            }
            return list;
        }

        @Override
        public boolean canChangeWhitespaceOnly() {
            return this.myCanChangeWhitespaceOnly;
        }

        @Override
        @NotNull
        public FormattingContext getContext() {
            FormattingContext formattingContext = this.myContext;
            if (formattingContext == null) {
                FormattingRequestImpl.$$$reportNull$$$0(5);
            }
            return formattingContext;
        }

        private void setTask(@Nullable FormattingTask formattingTask) {
            this.myTask = formattingTask;
        }

        private void runTask(@Nullable ProgressIndicator indicator) {
            FormattingTask task = this.myTask;
            if (task != null && this.myStateRef.compareAndSet(FormattingRequestState.NOT_STARTED, FormattingRequestState.RUNNING)) {
                try {
                    this.myTaskSemaphore.acquire();
                    task.run();
                    for (long waitTime = 0L; waitTime < AsyncDocumentFormattingService.this.getTimeout().getSeconds() * 1000L; waitTime += 1000L) {
                        if (this.myTaskSemaphore.tryAcquire(1000L, TimeUnit.MILLISECONDS)) {
                            this.myTaskSemaphore.release();
                            break;
                        }
                        if (indicator == null) continue;
                        indicator.checkCanceled();
                    }
                    if (this.myStateRef.compareAndSet(FormattingRequestState.RUNNING, FormattingRequestState.EXPIRED)) {
                        FormattingNotificationService.getInstance(this.myContext.getProject()).reportError(AsyncDocumentFormattingService.this.getNotificationGroupId(), AsyncDocumentFormattingService.this.getName(), CodeStyleBundle.message("async.formatting.service.timeout", AsyncDocumentFormattingService.this.getName(), Long.toString(AsyncDocumentFormattingService.this.getTimeout().getSeconds())));
                    }
                }
                catch (InterruptedException ie) {
                    LOG.warn("Interrupted formatting thread.");
                }
            }
        }

        @Override
        public boolean isQuickFormat() {
            return this.myQuickFormat;
        }

        @Override
        public void onTextReady(@NotNull String updatedText) {
            if (updatedText == null) {
                FormattingRequestImpl.$$$reportNull$$$0(6);
            }
            if (this.myStateRef.compareAndSet(FormattingRequestState.RUNNING, FormattingRequestState.COMPLETED)) {
                this.myTaskSemaphore.release();
                ApplicationManager.getApplication().invokeLater(() -> CommandProcessor.getInstance().runUndoTransparentAction(() -> {
                    try {
                        WriteAction.run(() -> {
                            if (this.myDocument.getModificationStamp() > this.myInitialModificationStamp) {
                                DocumentMerger merger;
                                Iterator iterator = DocumentMerger.EP_NAME.getExtensionList().iterator();
                                while (iterator.hasNext() && !(merger = (DocumentMerger)iterator.next()).updateDocument(this.myDocument, updatedText)) {
                                }
                            } else {
                                this.myDocument.setText(updatedText);
                            }
                        });
                    }
                    catch (Throwable throwable) {
                        LOG.error(throwable);
                    }
                }));
            }
        }

        @Override
        public void onError(@NotNull @NlsContexts.NotificationTitle String title, @NotNull @NlsContexts.NotificationContent String message) {
            if (title == null) {
                FormattingRequestImpl.$$$reportNull$$$0(7);
            }
            if (message == null) {
                FormattingRequestImpl.$$$reportNull$$$0(8);
            }
            if (this.myStateRef.compareAndSet(FormattingRequestState.RUNNING, FormattingRequestState.COMPLETED)) {
                this.myTaskSemaphore.release();
                FormattingNotificationService.getInstance(this.myContext.getProject()).reportError(AsyncDocumentFormattingService.this.getNotificationGroupId(), title, message);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "formattingContext";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ranges";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/formatting/service/AsyncDocumentFormattingService$FormattingRequestImpl";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updatedText";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/formatting/service/AsyncDocumentFormattingService$FormattingRequestImpl";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDocumentText";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFormattingRanges";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "onTextReady";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "onError";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static enum FormattingRequestState {
        NOT_STARTED,
        RUNNING,
        CANCELLING,
        CANCELLED,
        COMPLETED,
        EXPIRED;

    }
}

