/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.featureStatistics;

import com.intellij.featureStatistics.FeatureStatisticsBundle;
import com.intellij.featureStatistics.GroupDescriptor;
import com.intellij.featureStatistics.LogEventDetector;
import com.intellij.featureStatistics.ProductivityFeaturesProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtilRt;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FeatureDescriptor {
    @NotNull
    private String myId;
    @NotNull
    private String myDisplayName;
    @Nullable
    private String myGroupId;
    @Nullable
    private String myTipFileName;
    @Nullable
    private Set<String> myDependencies;
    private int myDaysBeforeFirstShowUp;
    private int myDaysBetweenSuccessiveShowUps;
    private int myMinUsageCount;
    private boolean myNeedToBeShownInGuide;
    private final List<LogEventDetector> myLogEventDetectors;
    private int myUsageCount;
    private long myLastTimeShown;
    private long myLastTimeUsed;
    private int myShownCount;
    private ProductivityFeaturesProvider myProvider;
    private static final Logger LOG = Logger.getInstance(FeatureDescriptor.class);
    @NonNls
    private static final String ATTRIBUTE_COUNT = "count";
    @NonNls
    private static final String ATTRIBUTE_LAST_SHOWN = "last-shown";
    @NonNls
    private static final String ATTRIBUTE_LAST_USED = "last-used";
    @NonNls
    private static final String ATTRIBUTE_SHOWN_COUNT = "shown-count";
    @NonNls
    private static final String ATTRIBUTE_ID = "id";
    @NonNls
    private static final String ATTRIBUTE_TIP_FILE = "tip-file";
    @NonNls
    private static final String ATTRIBUTE_DETECTOR_TYPE = "type";
    @NonNls
    private static final String ATTRIBUTE_FIRST_SHOW = "first-show";
    @NonNls
    private static final String ATTRIBUTE_SUCCESSIVE_SHOW = "successive-show";
    @NonNls
    private static final String ATTRIBUTE_MIN_USAGE_COUNT = "min-usage-count";
    @NonNls
    private static final String ATTRIBUTE_SHOW_IN_GUIDE = "show-in-guide";
    @NonNls
    private static final String ELEMENT_DEPENDENCY = "dependency";
    @NonNls
    private static final String ELEMENT_EVENT_DETECTOR = "event-detector";

    FeatureDescriptor(@NotNull GroupDescriptor group, @NotNull Element featureElement) {
        if (group == null) {
            FeatureDescriptor.$$$reportNull$$$0(0);
        }
        if (featureElement == null) {
            FeatureDescriptor.$$$reportNull$$$0(1);
        }
        this.myNeedToBeShownInGuide = true;
        this.myLogEventDetectors = new ArrayList<LogEventDetector>();
        this.myGroupId = group.getId();
        this.readExternal(featureElement);
    }

    FeatureDescriptor(@NonNls @NotNull String id, @NonNls @Nullable String tipFileName, @NotNull String displayName) {
        if (id == null) {
            FeatureDescriptor.$$$reportNull$$$0(2);
        }
        if (displayName == null) {
            FeatureDescriptor.$$$reportNull$$$0(3);
        }
        this.myNeedToBeShownInGuide = true;
        this.myLogEventDetectors = new ArrayList<LogEventDetector>();
        this.myId = id;
        this.myTipFileName = tipFileName;
        this.myDisplayName = displayName;
    }

    public FeatureDescriptor(@NonNls @NotNull String id, @NonNls @Nullable String groupId, @NonNls @Nullable String tipFileName, @NotNull String displayName, int daysBeforeFirstShowUp, int daysBetweenSuccessiveShowUps, @Nullable Set<String> dependencies2, int minUsageCount, ProductivityFeaturesProvider provider) {
        if (id == null) {
            FeatureDescriptor.$$$reportNull$$$0(4);
        }
        if (displayName == null) {
            FeatureDescriptor.$$$reportNull$$$0(5);
        }
        this.myNeedToBeShownInGuide = true;
        this.myLogEventDetectors = new ArrayList<LogEventDetector>();
        this.myId = id;
        this.myGroupId = groupId;
        this.myTipFileName = tipFileName;
        this.myDisplayName = displayName;
        this.myDaysBeforeFirstShowUp = daysBeforeFirstShowUp;
        this.myDaysBetweenSuccessiveShowUps = daysBetweenSuccessiveShowUps;
        this.myDependencies = dependencies2;
        this.myMinUsageCount = minUsageCount;
        this.myProvider = provider;
    }

    private void readExternal(Element element) {
        this.myId = Objects.requireNonNull(element.getAttributeValue(ATTRIBUTE_ID));
        this.myTipFileName = element.getAttributeValue(ATTRIBUTE_TIP_FILE);
        this.myDisplayName = FeatureStatisticsBundle.message(this.myId, new Object[0]);
        String needToBeShownInGuide = element.getAttributeValue(ATTRIBUTE_SHOW_IN_GUIDE);
        if (needToBeShownInGuide != null) {
            this.myNeedToBeShownInGuide = Boolean.parseBoolean(needToBeShownInGuide);
        }
        this.myDaysBeforeFirstShowUp = StringUtil.parseInt((String)element.getAttributeValue(ATTRIBUTE_FIRST_SHOW), (int)1);
        this.myDaysBetweenSuccessiveShowUps = StringUtil.parseInt((String)element.getAttributeValue(ATTRIBUTE_SUCCESSIVE_SHOW), (int)3);
        String minUsageCount = element.getAttributeValue(ATTRIBUTE_MIN_USAGE_COUNT);
        this.myMinUsageCount = minUsageCount == null ? 1 : Integer.parseInt(minUsageCount);
        List eventDetectors = element.getChildren(ELEMENT_EVENT_DETECTOR);
        for (Element eventDetectorElement : eventDetectors) {
            @NonNls String detectorTypeStr = eventDetectorElement.getAttributeValue(ATTRIBUTE_DETECTOR_TYPE);
            @NonNls String eventDataId = eventDetectorElement.getAttributeValue(ATTRIBUTE_ID);
            if (detectorTypeStr == null || eventDataId == null) continue;
            try {
                LogEventDetector.Type detectorType = LogEventDetector.Type.valueOf(detectorTypeStr.toUpperCase(Locale.ROOT));
                this.myLogEventDetectors.add(LogEventDetector.create(detectorType, this.myId, eventDataId));
            }
            catch (Throwable t) {
                LOG.error(String.format("Error on reading event-detector with event data id %s for feature %s", eventDataId, this.myId), t);
            }
        }
        List dependencies2 = element.getChildren(ELEMENT_DEPENDENCY);
        if (!dependencies2.isEmpty()) {
            this.myDependencies = new HashSet<String>();
            for (Element dependencyElement : dependencies2) {
                this.myDependencies.add(dependencyElement.getAttributeValue(ATTRIBUTE_ID));
            }
        }
    }

    @NotNull
    public String getId() {
        String string = this.myId;
        if (string == null) {
            FeatureDescriptor.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nullable
    public String getGroupId() {
        return this.myGroupId;
    }

    @Nullable
    public String getTipFileName() {
        return this.myTipFileName;
    }

    public List<LogEventDetector> getLogEventDetectors() {
        return this.myLogEventDetectors;
    }

    @NotNull
    public String getDisplayName() {
        String string = this.myDisplayName;
        if (string == null) {
            FeatureDescriptor.$$$reportNull$$$0(7);
        }
        return string;
    }

    public boolean isNeedToBeShownInGuide() {
        return this.myNeedToBeShownInGuide;
    }

    public int getUsageCount() {
        return this.myUsageCount;
    }

    public Class<? extends ProductivityFeaturesProvider> getProvider() {
        if (this.myProvider == null) {
            return null;
        }
        return this.myProvider.getClass();
    }

    void triggerUsed() {
        this.myLastTimeUsed = System.currentTimeMillis();
        ++this.myUsageCount;
    }

    public boolean isUnused() {
        return this.myUsageCount < this.myMinUsageCount;
    }

    public String toString() {
        return "id = [" + this.myId + "], displayName = [" + this.myDisplayName + "], groupId = [" + this.myGroupId + "], usageCount = [" + this.myUsageCount + "]";
    }

    public int getDaysBeforeFirstShowUp() {
        return this.myDaysBeforeFirstShowUp;
    }

    public int getDaysBetweenSuccessiveShowUps() {
        return this.myDaysBetweenSuccessiveShowUps;
    }

    public int getMinUsageCount() {
        return this.myMinUsageCount;
    }

    public long getLastTimeShown() {
        return this.myLastTimeShown;
    }

    public String[] getDependencyFeatures() {
        if (this.myDependencies == null) {
            return ArrayUtilRt.EMPTY_STRING_ARRAY;
        }
        return ArrayUtilRt.toStringArray(this.myDependencies);
    }

    void triggerShown() {
        this.myLastTimeShown = System.currentTimeMillis();
        ++this.myShownCount;
    }

    public long getLastTimeUsed() {
        return this.myLastTimeUsed;
    }

    public int getShownCount() {
        return this.myShownCount;
    }

    void copyStatistics(FeatureDescriptor statistics) {
        this.myUsageCount = statistics.getUsageCount();
        this.myLastTimeShown = statistics.getLastTimeShown();
        this.myLastTimeUsed = statistics.getLastTimeUsed();
        this.myShownCount = statistics.getShownCount();
    }

    void readStatistics(Element element) {
        String count = element.getAttributeValue(ATTRIBUTE_COUNT);
        String lastShown = element.getAttributeValue(ATTRIBUTE_LAST_SHOWN);
        String lastUsed = element.getAttributeValue(ATTRIBUTE_LAST_USED);
        String shownCount = element.getAttributeValue(ATTRIBUTE_SHOWN_COUNT);
        this.myUsageCount = count == null ? 0 : Integer.parseInt(count);
        this.myLastTimeShown = lastShown == null ? 0L : Long.parseLong(lastShown);
        this.myLastTimeUsed = lastUsed == null ? 0L : Long.parseLong(lastUsed);
        this.myShownCount = shownCount == null ? 0 : Integer.parseInt(shownCount);
    }

    void writeStatistics(Element element) {
        element.setAttribute(ATTRIBUTE_COUNT, String.valueOf(this.getUsageCount()));
        element.setAttribute(ATTRIBUTE_LAST_SHOWN, String.valueOf(this.getLastTimeShown()));
        element.setAttribute(ATTRIBUTE_LAST_USED, String.valueOf(this.getLastTimeUsed()));
        element.setAttribute(ATTRIBUTE_SHOWN_COUNT, String.valueOf(this.getShownCount()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "featureElement";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = ATTRIBUTE_ID;
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/featureStatistics/FeatureDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/featureStatistics/FeatureDescriptor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

