/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.execution.ui.FragmentStatisticsService;
import com.intellij.execution.ui.SettingsEditorFragmentType;
import com.intellij.execution.ui.TagButton;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentValidator;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.panel.ComponentPanelBuilder;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.Ref;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SettingsEditorFragment<Settings, C extends JComponent>
extends SettingsEditor<Settings> {
    private final String myId;
    @Nls
    private final String myName;
    @Nls
    private final String myGroup;
    protected C myComponent;
    private final BiConsumer<? super Settings, ? super C> myReset;
    private final BiConsumer<? super Settings, ? super C> myApply;
    @Nullable
    private Function<Settings, List<ValidationInfo>> myValidation;
    @NotNull
    private final SettingsEditorFragmentType myType;
    private final int myPriority;
    private final Predicate<? super Settings> myInitialSelection;
    @Nullable
    @Nls
    private String myHint;
    @Nullable
    private JComponent myHintComponent;
    @Nullable
    @Nls
    private String myActionHint;
    @Nullable
    @Nls
    private String myActionDescription;
    @Nullable
    private String myConfigId;
    @Nullable
    private Function<? super C, ? extends JComponent> myEditorGetter;
    private boolean myRemovable;
    private boolean myCanBeHidden;

    public SettingsEditorFragment(String id, @Nls(capitalization=Nls.Capitalization.Sentence) String name, @Nls(capitalization=Nls.Capitalization.Title) String group, C component, int priority, @NotNull SettingsEditorFragmentType type, BiConsumer<? super Settings, ? super C> reset2, BiConsumer<? super Settings, ? super C> apply2, Predicate<? super Settings> initialSelection) {
        if (type == null) {
            SettingsEditorFragment.$$$reportNull$$$0(0);
        }
        this.myRemovable = true;
        this.myId = id;
        this.myName = name;
        this.myGroup = group;
        this.myComponent = component;
        this.myReset = reset2;
        this.myApply = apply2;
        this.myPriority = priority;
        this.myType = type;
        this.myInitialSelection = initialSelection;
    }

    public SettingsEditorFragment(String id, @Nls(capitalization=Nls.Capitalization.Sentence) String name, @Nls(capitalization=Nls.Capitalization.Title) String group, C component, @NotNull SettingsEditorFragmentType type, BiConsumer<? super Settings, ? super C> reset2, BiConsumer<? super Settings, ? super C> apply2, Predicate<? super Settings> initialSelection) {
        if (type == null) {
            SettingsEditorFragment.$$$reportNull$$$0(1);
        }
        this(id, name, group, (C)component, 0, type, reset2, apply2, initialSelection);
    }

    public SettingsEditorFragment(String id, @Nls(capitalization=Nls.Capitalization.Sentence) String name, @Nls(capitalization=Nls.Capitalization.Title) String group, C component, int commandLinePosition, BiConsumer<? super Settings, ? super C> reset2, BiConsumer<? super Settings, ? super C> apply2, Predicate<? super Settings> initialSelection) {
        this(id, name, group, (C)component, commandLinePosition, SettingsEditorFragment.getType(component, commandLinePosition), reset2, apply2, initialSelection);
    }

    @NotNull
    private static SettingsEditorFragmentType getType(JComponent component, int commandLinePosition) {
        SettingsEditorFragmentType settingsEditorFragmentType = component instanceof TagButton ? SettingsEditorFragmentType.TAG : (commandLinePosition == -2 ? SettingsEditorFragmentType.BEFORE_RUN : (commandLinePosition == -1 ? SettingsEditorFragmentType.HEADER : (commandLinePosition == 0 ? SettingsEditorFragmentType.EDITOR : SettingsEditorFragmentType.COMMAND_LINE)));
        if (settingsEditorFragmentType == null) {
            SettingsEditorFragment.$$$reportNull$$$0(2);
        }
        return settingsEditorFragmentType;
    }

    public SettingsEditorFragment(String id, @Nls(capitalization=Nls.Capitalization.Sentence) String name, @Nls(capitalization=Nls.Capitalization.Title) String group, C component, BiConsumer<? super Settings, ? super C> reset2, BiConsumer<? super Settings, ? super C> apply2, Predicate<? super Settings> initialSelection) {
        this(id, name, group, (C)component, 0, SettingsEditorFragmentType.EDITOR, reset2, apply2, initialSelection);
    }

    public static <S> SettingsEditorFragment<S, ?> createWrapper(String id, @Nls String name, @Nls String group, @NotNull SettingsEditor<S> inner, Predicate<? super S> initialSelection) {
        if (inner == null) {
            SettingsEditorFragment.$$$reportNull$$$0(3);
        }
        JComponent component = inner.getComponent();
        SettingsEditorFragment<? super S, JComponent> fragment = new SettingsEditorFragment<S, JComponent>(id, name, group, component, (settings, c) -> inner.resetFrom(settings), (settings, c) -> {
            try {
                inner.applyTo(settings);
            }
            catch (ConfigurationException e) {
                throw new RuntimeException(e);
            }
        }, initialSelection);
        Disposer.register(fragment, inner);
        return fragment;
    }

    public static <Settings> SettingsEditorFragment<Settings, TagButton> createTag(String id, @Nls String name, @Nls String group, Predicate<? super Settings> getter2, BiConsumer<? super Settings, ? super Boolean> setter2) {
        Ref ref = new Ref();
        TagButton tagButton2 = new TagButton(name, e -> {
            ((SettingsEditorFragment)ref.get()).setSelected(false);
            ((SettingsEditorFragment)ref.get()).logChange(false, (AnActionEvent)e);
        });
        SettingsEditorFragment<? super Settings, TagButton> fragment = new SettingsEditorFragment<Settings, TagButton>(id, name, group, tagButton2, SettingsEditorFragmentType.TAG, (settings, button) -> button.setVisible(getter2.test((Object)settings)), (settings, button) -> setter2.accept((Object)settings, (Boolean)button.isVisible()), getter2);
        Disposer.register(fragment, (Disposable)tagButton2);
        ref.set(fragment);
        return fragment;
    }

    public String getId() {
        return this.myId;
    }

    @Nls
    public String getName() {
        return this.myName;
    }

    @Nls
    public String getGroup() {
        return this.myGroup;
    }

    public C component() {
        return this.myComponent;
    }

    public JComponent[] getAllComponents() {
        return new JComponent[]{this.component()};
    }

    public boolean isTag() {
        return SettingsEditorFragmentType.TAG == this.myType;
    }

    public boolean isCommandLine() {
        return SettingsEditorFragmentType.COMMAND_LINE == this.myType;
    }

    public boolean isHeader() {
        return SettingsEditorFragmentType.HEADER == this.myType;
    }

    public boolean isBeforeRun() {
        return SettingsEditorFragmentType.BEFORE_RUN == this.myType;
    }

    public boolean isEditor() {
        return SettingsEditorFragmentType.EDITOR == this.myType;
    }

    public int getPriority() {
        return this.myPriority;
    }

    @Nullable
    public ActionGroup getCustomActionGroup() {
        return null;
    }

    public boolean isSelected() {
        return ((Component)this.myComponent).isVisible();
    }

    public boolean isInitiallyVisible(Settings settings) {
        return this.myInitialSelection.test(settings);
    }

    public boolean isRemovable() {
        return this.myRemovable;
    }

    public void setRemovable(boolean removable) {
        this.myRemovable = removable;
    }

    public void setValidation(@Nullable Function<Settings, List<ValidationInfo>> validation) {
        this.myValidation = validation;
    }

    protected void validate(Settings s) {
        if (this.myValidation == null) {
            return;
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            List<ValidationInfo> infos = this.myValidation.apply(s);
            if (infos.isEmpty()) {
                return;
            }
            UIUtil.invokeLaterIfNeeded(() -> {
                if (Disposer.isDisposed((Disposable)this)) {
                    return;
                }
                for (ValidationInfo info : infos) {
                    ComponentValidator validator2;
                    JComponent component = info.component;
                    if (component == null) continue;
                    Optional<ComponentValidator> optional = ComponentValidator.getInstance(component);
                    if (optional.isEmpty()) {
                        validator2 = new ComponentValidator(this);
                        validator2.installOn(component);
                    } else {
                        validator2 = optional.get();
                    }
                    validator2.updateInfo(info.message.isEmpty() ? null : info);
                }
            });
        });
    }

    public boolean isCanBeHidden() {
        return this.myCanBeHidden;
    }

    public void setCanBeHidden(boolean canBeHidden) {
        this.myCanBeHidden = canBeHidden;
    }

    public void setSelected(boolean selected) {
        ((JComponent)this.myComponent).setVisible(selected);
        if (this.myHintComponent != null) {
            this.myHintComponent.setVisible(selected);
        }
        this.fireEditorStateChanged();
    }

    public void toggle(boolean selected, @Nullable AnActionEvent e) {
        boolean changed = this.isSelected() != selected;
        this.setSelected(selected);
        if (selected) {
            JScrollPane scrollpane = (JScrollPane)UIUtil.getParentOfType(JScrollPane.class, this.myComponent);
            if (scrollpane != null) {
                scrollpane.validate();
            }
            ((JComponent)this.myComponent).scrollRectToVisible(new Rectangle(new Point(0, 50), ((JComponent)this.myComponent).getPreferredSize()));
        }
        if (changed) {
            this.logChange(selected, e);
        }
    }

    protected void logChange(boolean selected, @Nullable AnActionEvent e) {
        if (selected) {
            FragmentStatisticsService.getInstance().logOptionModified(this.getProject(), this.getId(), this.myConfigId, e);
        } else {
            FragmentStatisticsService.getInstance().logOptionRemoved(this.getProject(), this.getId(), this.myConfigId, e);
        }
    }

    private Project getProject() {
        return (Project)DataManager.getInstance().getDataContext((Component)this.myComponent).getData(PlatformDataKeys.PROJECT_CONTEXT);
    }

    public void setEditorGetter(@Nullable Function<? super C, ? extends JComponent> editorGetter) {
        this.myEditorGetter = editorGetter;
    }

    public JComponent getEditorComponent() {
        C component = this.component();
        if (this.myEditorGetter != null) {
            return this.myEditorGetter.apply(component);
        }
        return SettingsEditorFragment.getEditorComponent(component);
    }

    private static JComponent getEditorComponent(JComponent component) {
        if (component instanceof LabeledComponent) {
            component = ((LabeledComponent)component).getComponent();
        }
        if (component instanceof TagButton) {
            return ((TagButton)component).myButton;
        }
        if (component instanceof ComponentWithBrowseButton) {
            return ((ComponentWithBrowseButton)component).getChildComponent();
        }
        if (component instanceof RawCommandLineEditor) {
            return ((RawCommandLineEditor)component).getEditorField();
        }
        return component;
    }

    @Deprecated
    public int getCommandLinePosition() {
        return this.myPriority;
    }

    public int getMenuPosition() {
        return 0;
    }

    @Override
    protected void resetEditorFrom(@NotNull Settings s) {
        if (s == null) {
            SettingsEditorFragment.$$$reportNull$$$0(4);
        }
        this.myReset.accept(s, this.myComponent);
    }

    @Override
    protected void applyEditorTo(@NotNull Settings s) {
        if (s == null) {
            SettingsEditorFragment.$$$reportNull$$$0(5);
        }
        this.myApply.accept(s, this.myComponent);
        this.validate(s);
    }

    @Override
    @NotNull
    protected JComponent createEditor() {
        ((JComponent)this.myComponent).setVisible(this.isSelected());
        C c = this.myComponent;
        if (c == null) {
            SettingsEditorFragment.$$$reportNull$$$0(6);
        }
        return c;
    }

    public List<SettingsEditorFragment<Settings, ?>> getChildren() {
        return Collections.emptyList();
    }

    @Nullable
    @Nls
    public String getChildrenGroupName() {
        return null;
    }

    @Nullable
    @NlsActions.ActionDescription
    public String getActionHint() {
        return this.myActionHint;
    }

    public void setActionDescription(@Nullable @Nls String actionDescription) {
        this.myActionDescription = actionDescription;
    }

    @Nullable
    @Nls
    public String getActionDescription() {
        return this.myActionDescription;
    }

    public void setActionHint(@Nullable @Nls String hint) {
        this.myActionHint = hint;
    }

    @Nullable
    public String getHint(@Nullable JComponent component) {
        return this.myHint;
    }

    public void setHint(@Nullable @Nls String hint) {
        this.myHint = hint;
    }

    public void setConfigId(@Nullable String configId) {
        this.myConfigId = configId;
    }

    @Nullable
    public JComponent getHintComponent() {
        if (this.myHintComponent == null && this.myHint != null) {
            JLabel comment = ComponentPanelBuilder.createNonWrappingCommentComponent(this.myHint);
            comment.setFocusable(false);
            this.myHintComponent = LabeledComponent.create(comment, "", "West");
        }
        return this.myHintComponent;
    }

    public String toString() {
        return this.myId + " " + this.myName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/ui/SettingsEditorFragment";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inner";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/ui/SettingsEditorFragment";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createWrapper";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

