/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.execution.ui.FragmentHintManager;
import com.intellij.execution.ui.FragmentedSettingsBuilder;
import com.intellij.execution.ui.SettingsEditorFragment;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.ui.panel.ComponentPanelBuilder;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.WrapLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommandLinePanel
extends JPanel {
    private final List<JComponent> myComponents;
    private final JLabel myHintLabel;

    public CommandLinePanel(Collection<? extends SettingsEditorFragment<?, ?>> fragments2, @Nullable String configId, @NotNull Disposable disposable) {
        if (disposable == null) {
            CommandLinePanel.$$$reportNull$$$0(0);
        }
        this.myComponents = ContainerUtil.map(fragments2, fragment -> fragment.createEditor());
        this.myHintLabel = ComponentPanelBuilder.createNonWrappingCommentComponent("");
        String keystrokeText = KeymapUtil.getKeystrokeText(KeyStroke.getKeyStroke(18, 0));
        FragmentHintManager manager = new FragmentHintManager((Consumer<? super String>)((Consumer)s -> this.myHintLabel.setText((String)s)), IdeBundle.message("dialog.message.press.for.field.hints", keystrokeText), configId, disposable);
        manager.registerFragments(fragments2);
        this.setLayout(new BoxLayout(this, 1));
        this.buildRows();
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension size = super.getMinimumSize();
        return new Dimension(Math.min(700, size.width), size.height);
    }

    private void buildRows() {
        WrapLayout layout = new WrapLayout(0, 0, 5);
        layout.setFillWidth(true);
        JPanel mainPanel = new JPanel((LayoutManager)layout);
        for (JComponent component : this.myComponents) {
            mainPanel.add(component);
        }
        this.add(mainPanel);
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)this.myHintLabel, "West");
        JBDimension size = new JBDimension(100, 15);
        panel2.setMinimumSize((Dimension)size);
        panel2.setPreferredSize((Dimension)size);
        panel2.setBorder((Border)JBUI.Borders.emptyLeft((int)this.getLeftInset()));
        this.add(panel2);
    }

    public int getLeftInset() {
        return Arrays.stream(this.getComponents()).map(component -> FragmentedSettingsBuilder.getLeftInset((JComponent)component)).max(Comparator.comparingInt(o -> o)).orElse(0);
    }

    public static Dimension setMinimumWidth(Component component, int width) {
        Dimension size = new Dimension(width, Math.max(JBUI.scale((int)30), component.getMinimumSize().height));
        component.setMinimumSize(size);
        if (component instanceof RawCommandLineEditor) {
            ((RawCommandLineEditor)component).getTextField().setColumns(0);
        }
        return size;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/intellij/execution/ui/CommandLinePanel", "<init>"));
    }
}

