/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.target;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentAwareRunProfile;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetProgressIndicator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@ApiStatus.Experimental
public interface TargetEnvironmentAwareRunProfileState
extends RunProfileState {
    public void prepareTargetEnvironmentRequest(@NotNull TargetEnvironmentRequest var1, @NotNull TargetProgressIndicator var2) throws ExecutionException;

    public void handleCreatedTargetEnvironment(@NotNull TargetEnvironment var1, @NotNull TargetProgressIndicator var2) throws ExecutionException;

    default public <T> Promise<T> prepareTargetToCommandExecution(@NotNull ExecutionEnvironment env, @NotNull Logger logger, @NonNls String logFailureMessage, @NotNull ThrowableComputable<? extends T, ? extends ExecutionException> afterPreparation) throws ExecutionException {
        if (env == null) {
            TargetEnvironmentAwareRunProfileState.$$$reportNull$$$0(0);
        }
        if (logger == null) {
            TargetEnvironmentAwareRunProfileState.$$$reportNull$$$0(1);
        }
        if (afterPreparation == null) {
            TargetEnvironmentAwareRunProfileState.$$$reportNull$$$0(2);
        }
        Promise<Object> preparationTasks = ((TargetEnvironmentAwareRunProfile)env.getRunProfile()).needPrepareTarget() ? ExecutionManager.getInstance(env.getProject()).executePreparationTasks(env, this) : Promises.resolvedPromise();
        return preparationTasks.thenAsync(o -> {
            AsyncPromise<@Nullable T> promise = new AsyncPromise();
            AppExecutorUtil.getAppExecutorService().execute(() -> {
                try {
                    promise.setResult(afterPreparation.compute());
                }
                catch (ProcessCanceledException e) {
                    promise.setError(StringUtil.notNullize((String)e.getLocalizedMessage()));
                }
                catch (ExecutionException t) {
                    logger.warn(logFailureMessage, (Throwable)t);
                    promise.setError(t);
                }
                catch (Throwable t) {
                    logger.error(logFailureMessage, t);
                    promise.setError(t);
                }
            });
            return promise;
        });
    }

    default public TargetEnvironmentRequest createCustomTargetEnvironmentRequest() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "env";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "logger";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "afterPreparation";
                break;
            }
        }
        objectArray[1] = "com/intellij/execution/target/TargetEnvironmentAwareRunProfileState";
        objectArray[2] = "prepareTargetToCommandExecution";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

