/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.PluginProblemReporter;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.ExceptionWithAttachments;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.text.Strings;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginException
extends RuntimeException
implements ExceptionWithAttachments {
    private final PluginId myPluginId;
    private final List<Attachment> attachments;

    public PluginException(@NotNull @NonNls String message, Throwable cause, @Nullable PluginId pluginId) {
        if (message == null) {
            PluginException.$$$reportNull$$$0(0);
        }
        super(message, cause);
        this.myPluginId = pluginId;
        this.attachments = Collections.emptyList();
    }

    public PluginException(@NotNull Throwable e, @Nullable PluginId pluginId) {
        if (e == null) {
            PluginException.$$$reportNull$$$0(1);
        }
        super(e.getMessage(), e);
        this.myPluginId = pluginId;
        this.attachments = Collections.emptyList();
    }

    public PluginException(@NotNull @NonNls String message, @Nullable PluginId pluginId) {
        if (message == null) {
            PluginException.$$$reportNull$$$0(2);
        }
        super(message);
        this.myPluginId = pluginId;
        this.attachments = Collections.emptyList();
    }

    public PluginException(@NotNull @NonNls String message, @Nullable PluginId pluginId, @NotNull List<Attachment> attachments) {
        if (message == null) {
            PluginException.$$$reportNull$$$0(3);
        }
        if (attachments == null) {
            PluginException.$$$reportNull$$$0(4);
        }
        super(message);
        this.myPluginId = pluginId;
        this.attachments = attachments;
    }

    public PluginException(@NotNull @NonNls String message, @Nullable Throwable cause, @Nullable PluginId pluginId, @NotNull List<Attachment> attachments) {
        if (message == null) {
            PluginException.$$$reportNull$$$0(5);
        }
        if (attachments == null) {
            PluginException.$$$reportNull$$$0(6);
        }
        super(message, cause);
        this.myPluginId = pluginId;
        this.attachments = attachments;
    }

    @Nullable
    public final PluginId getPluginId() {
        return this.myPluginId;
    }

    @Override
    @NotNull
    @NonNls
    public String getMessage() {
        String message = super.getMessage();
        if (this.myPluginId == null || message != null && message.contains("PluginDescriptor(")) {
            String string = message;
            if (string == null) {
                PluginException.$$$reportNull$$$0(7);
            }
            return string;
        }
        String string = Strings.notNullize((String)message) + " [Plugin: " + this.myPluginId + "]";
        if (string == null) {
            PluginException.$$$reportNull$$$0(8);
        }
        return string;
    }

    public final Attachment @NotNull [] getAttachments() {
        Attachment[] attachmentArray = this.attachments.toArray(Attachment.EMPTY_ARRAY);
        if (attachmentArray == null) {
            PluginException.$$$reportNull$$$0(9);
        }
        return attachmentArray;
    }

    @NotNull
    public static PluginException createByClass(@NotNull @NonNls String errorMessage, @Nullable Throwable cause, @NotNull Class<?> pluginClass) {
        if (errorMessage == null) {
            PluginException.$$$reportNull$$$0(10);
        }
        if (pluginClass == null) {
            PluginException.$$$reportNull$$$0(11);
        }
        PluginException pluginException = PluginProblemReporter.getInstance().createPluginExceptionByClass(errorMessage, cause, pluginClass);
        if (pluginException == null) {
            PluginException.$$$reportNull$$$0(12);
        }
        return pluginException;
    }

    @NotNull
    public static PluginException createByClass(@NotNull Throwable cause, @NotNull Class<?> pluginClass) {
        if (cause == null) {
            PluginException.$$$reportNull$$$0(13);
        }
        if (pluginClass == null) {
            PluginException.$$$reportNull$$$0(14);
        }
        PluginException pluginException = PluginProblemReporter.getInstance().createPluginExceptionByClass(Strings.notNullize((String)cause.getMessage()), cause, pluginClass);
        if (pluginException == null) {
            PluginException.$$$reportNull$$$0(15);
        }
        return pluginException;
    }

    public static void logPluginError(@NotNull Logger logger, @NotNull @NonNls String errorMessage, @Nullable Throwable cause, @NotNull Class<?> pluginClass) {
        if (logger == null) {
            PluginException.$$$reportNull$$$0(16);
        }
        if (errorMessage == null) {
            PluginException.$$$reportNull$$$0(17);
        }
        if (pluginClass == null) {
            PluginException.$$$reportNull$$$0(18);
        }
        logger.error((Throwable)PluginException.createByClass(errorMessage, cause, pluginClass));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attachments";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagnostic/PluginException";
                break;
            }
            case 10: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessage";
                break;
            }
            case 11: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginClass";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cause";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logger";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagnostic/PluginException";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessage";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttachments";
                break;
            }
            case 12: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createByClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 15: {
                break;
            }
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createByClass";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "logPluginError";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

