/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.coroutine.util;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.xdebugger.frame.XNamedValue;
import com.sun.jdi.Location;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ThreadReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutineInfoData;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutinePreflightFrame;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutineStackFrameItem;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CreationCoroutineStackFrameItem;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.RunningCoroutineStackFrameItem;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.SuspendExitMode;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.ContinuationHolder;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.CoroutineStackFrameProxysKt;
import org.jetbrains.kotlin.idea.debugger.coroutine.util.CoroutineFrameBuilder$Companion$WhenMappings;
import org.jetbrains.kotlin.idea.debugger.coroutine.util.CoroutineUtilsKt;
import org.jetbrains.kotlin.idea.debugger.coroutine.util.ProvidersKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.DefaultExecutionContext;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/util/CoroutineFrameBuilder;", "", "()V", "Companion", "kotlin.jvm-debugger.coroutines"})
public final class CoroutineFrameBuilder {
    @NotNull
    private static final ReadOnlyProperty log$delegate;
    private static final int PRE_FETCH_FRAME_COUNT = 5;
    @NotNull
    public static final Companion Companion;

    static {
        Companion = new Companion(null);
        log$delegate = ProvidersKt.getLogger();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001&B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0018\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u0010J\u0014\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J\u0014\u0010\u001b\u001a\u0004\u0018\u00010\u001a2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J\u0018\u0010\u001c\u001a\u0004\u0018\u00010\u00162\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00160\u001eH\u0002J \u0010\u001f\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010 \u001a\u00020!J(\u0010\"\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020$0\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020%0\u001e0#2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u001e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0005\u001a\u00020\u00068FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\b\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/util/CoroutineFrameBuilder$Companion;", "", "()V", "PRE_FETCH_FRAME_COUNT", "", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "getLog", "()Lcom/intellij/openapi/diagnostic/Logger;", "log$delegate", "Lkotlin/properties/ReadOnlyProperty;", "build", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/util/CoroutineFrameBuilder$Companion$CoroutineFrameItemLists;", "coroutine", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineInfoData;", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "preflightFrame", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutinePreflightFrame;", "buildRealStackFrameItem", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/RunningCoroutineStackFrameItem;", "frame", "Lcom/intellij/debugger/jdi/StackFrameProxyImpl;", "buildStackFrameForActive", "coroutineExitFrame", "getLVTContinuation", "Lcom/sun/jdi/ObjectReference;", "getThisContinuation", "lookForTheFollowingFrame", "theFollowingFrames", "", "lookupContinuation", "mode", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/SuspendExitMode;", "restoredStackTrace", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineStackFrameItem;", "Lcom/intellij/xdebugger/frame/XNamedValue;", "CoroutineFrameItemLists", "kotlin.jvm-debugger.coroutines"})
    public static final class Companion {
        static final /* synthetic */ KProperty[] $$delegatedProperties;

        static {
            $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl(Companion.class, "log", "getLog()Lcom/intellij/openapi/diagnostic/Logger;", 0))};
        }

        @NotNull
        public final Logger getLog() {
            return (Logger)log$delegate.getValue((Object)Companion, $$delegatedProperties[0]);
        }

        @Nullable
        public final CoroutineFrameItemLists build(@NotNull CoroutineInfoData coroutine, @NotNull SuspendContextImpl suspendContext) {
            Intrinsics.checkNotNullParameter((Object)coroutine, (String)"coroutine");
            Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
            return coroutine.isRunning() ? this.buildStackFrameForActive(coroutine, suspendContext) : (coroutine.isSuspended() ? new CoroutineFrameItemLists(coroutine.getStackTrace(), coroutine.getCreationStackTrace()) : null);
        }

        private final CoroutineFrameItemLists buildStackFrameForActive(CoroutineInfoData coroutine, SuspendContextImpl suspendContext) {
            ThreadReference threadReference = coroutine.getActiveThread();
            if (threadReference == null) {
                return null;
            }
            ThreadReference activeThread = threadReference;
            boolean bl = false;
            List coroutineStackFrameList = new ArrayList();
            DebugProcessImpl debugProcessImpl = suspendContext.getDebugProcess();
            Intrinsics.checkNotNullExpressionValue((Object)debugProcessImpl, (String)"suspendContext.debugProcess");
            ThreadReferenceProxyImpl threadReferenceProxyImpl = new ThreadReferenceProxyImpl(debugProcessImpl.getVirtualMachineProxy(), activeThread);
            List list = threadReferenceProxyImpl.forceFrames();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"threadReferenceProxyImpl.forceFrames()");
            List realFrames = list;
            Iterator iterator = realFrames.iterator();
            while (iterator.hasNext()) {
                RunningCoroutineStackFrameItem it;
                boolean bl2;
                boolean bl3;
                RunningCoroutineStackFrameItem runningCoroutineStackFrameItem;
                StackFrameProxyImpl runningStackFrameProxy;
                StackFrameProxyImpl stackFrameProxyImpl = runningStackFrameProxy = (StackFrameProxyImpl)iterator.next();
                Intrinsics.checkNotNullExpressionValue((Object)stackFrameProxyImpl, (String)"runningStackFrameProxy");
                CoroutinePreflightFrame preflightStackFrame = this.coroutineExitFrame(stackFrameProxyImpl, suspendContext);
                if (preflightStackFrame != null) {
                    StackFrameProxyImpl stackFrameProxyImpl2 = preflightStackFrame.getStackFrameProxy();
                    Intrinsics.checkNotNullExpressionValue((Object)stackFrameProxyImpl2, (String)"preflightStackFrame.stackFrameProxy");
                    RunningCoroutineStackFrameItem runningCoroutineStackFrameItem2 = this.buildRealStackFrameItem(stackFrameProxyImpl2);
                    if (runningCoroutineStackFrameItem2 != null) {
                        runningCoroutineStackFrameItem = runningCoroutineStackFrameItem2;
                        bl3 = false;
                        bl2 = false;
                        it = runningCoroutineStackFrameItem;
                        boolean bl4 = false;
                        coroutineStackFrameList.add(it);
                    }
                    CoroutineFrameItemLists coroutineFrameLists = this.build(preflightStackFrame, suspendContext);
                    coroutineStackFrameList.addAll((Collection)coroutineFrameLists.getFrames());
                    return new CoroutineFrameItemLists(coroutineStackFrameList, coroutine.getCreationStackTrace());
                }
                if (this.buildRealStackFrameItem(runningStackFrameProxy) == null) continue;
                bl3 = false;
                bl2 = false;
                it = runningCoroutineStackFrameItem;
                boolean bl5 = false;
                coroutineStackFrameList.add(it);
            }
            return new CoroutineFrameItemLists(coroutineStackFrameList, coroutine.getCreationStackTrace());
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final CoroutineFrameItemLists build(@NotNull CoroutinePreflightFrame preflightFrame, @NotNull SuspendContextImpl suspendContext) {
            void $this$mapIndexedNotNullTo$iv$iv;
            void $this$mapIndexedNotNull$iv;
            void restoredStackTrace;
            Intrinsics.checkNotNullParameter((Object)((Object)preflightFrame), (String)"preflightFrame");
            Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
            boolean bl = false;
            List stackFrames = new ArrayList();
            Pair<List<CoroutineStackFrameItem>, List<XNamedValue>> pair = this.restoredStackTrace(preflightFrame);
            List list = (List)pair.component1();
            List variablesRemovedFromBottomRestoredFrame = (List)pair.component2();
            stackFrames.addAll((Collection)restoredStackTrace);
            List<StackFrameProxyImpl> framesLeft = preflightFrame.getThreadPreCoroutineFrames();
            Iterable iterable = framesLeft;
            List list2 = stackFrames;
            boolean $i$f$mapIndexedNotNull = false;
            void var9_11 = $this$mapIndexedNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapIndexedNotNullTo = false;
            void $this$forEachIndexed$iv$iv$iv = $this$mapIndexedNotNullTo$iv$iv;
            boolean $i$f$forEachIndexed = false;
            int index$iv$iv$iv = 0;
            for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
                RunningCoroutineStackFrameItem runningCoroutineStackFrameItem;
                void stackFrameProxyImpl;
                void element$iv$iv;
                int n = index$iv$iv$iv++;
                boolean bl2 = false;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Object t = item$iv$iv$iv;
                int index$iv$iv = n;
                boolean bl3 = false;
                StackFrameProxyImpl stackFrameProxyImpl2 = (StackFrameProxyImpl)element$iv$iv;
                int index = index$iv$iv;
                boolean bl4 = false;
                if ((RunningCoroutineStackFrameItem)((Object)CoroutineUtilsKt.invokeInManagerThread(suspendContext, (Function0)new Function0<RunningCoroutineStackFrameItem>((StackFrameProxyImpl)stackFrameProxyImpl){
                    final /* synthetic */ StackFrameProxyImpl $stackFrameProxyImpl;

                    @Nullable
                    public final RunningCoroutineStackFrameItem invoke() {
                        return org.jetbrains.kotlin.idea.debugger.coroutine.util.CoroutineFrameBuilder$Companion.access$buildRealStackFrameItem(CoroutineFrameBuilder.Companion, this.$stackFrameProxyImpl);
                    }
                    {
                        this.$stackFrameProxyImpl = stackFrameProxyImpl;
                        super(0);
                    }
                })) == null) continue;
                boolean bl5 = false;
                boolean bl6 = false;
                RunningCoroutineStackFrameItem it$iv$iv = runningCoroutineStackFrameItem;
                boolean bl7 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List list3 = (List)destination$iv$iv;
            list2.addAll(list3);
            return new CoroutineFrameItemLists(stackFrames, preflightFrame.getCoroutineInfoData().getCreationStackTrace());
        }

        private final Pair<List<CoroutineStackFrameItem>, List<XNamedValue>> restoredStackTrace(CoroutinePreflightFrame preflightFrame) {
            List list;
            boolean $this$apply;
            boolean bl;
            boolean bl2;
            boolean bl3;
            CoroutineStackFrameItem it;
            Location preflightFrameLocation = preflightFrame.getStackFrameProxy().location();
            List<CoroutineStackFrameItem> coroutineStackFrame = preflightFrame.getCoroutineInfoData().getStackTrace();
            StackFrameProxyImpl stackFrameProxyImpl = (StackFrameProxyImpl)CollectionsKt.firstOrNull(preflightFrame.getThreadPreCoroutineFrames());
            Location preCoroutineTopFrameLocation = stackFrameProxyImpl != null ? stackFrameProxyImpl.location() : null;
            boolean bl4 = false;
            List variablesRemovedFromTopRestoredFrame = new ArrayList();
            Iterable $this$dropWhile$iv = coroutineStackFrame;
            boolean $i$f$dropWhile = false;
            boolean yielding$iv = false;
            ArrayList list$iv = new ArrayList();
            for (Object item$iv : $this$dropWhile$iv) {
                if (yielding$iv) {
                    list$iv.add(item$iv);
                    continue;
                }
                it = (CoroutineStackFrameItem)((Object)item$iv);
                boolean bl5 = false;
                bl3 = CoroutineUtilsKt.isFilterFromTop(it.getLocation(), preflightFrameLocation);
                bl2 = false;
                bl = false;
                $this$apply = bl3;
                boolean bl6 = false;
                if ($this$apply) {
                    variablesRemovedFromTopRestoredFrame.addAll((Collection)it.getSpilledVariables());
                }
                if (bl3) continue;
                list$iv.add(item$iv);
                yielding$iv = true;
            }
            List stripTopStackTrace = list$iv;
            $i$f$dropWhile = false;
            List variablesRemovedFromBottomRestoredFrame = new ArrayList();
            Location location2 = preCoroutineTopFrameLocation;
            if (location2 == null) {
                list = stripTopStackTrace;
            } else {
                List $this$dropLastWhile$iv = stripTopStackTrace;
                boolean $i$f$dropLastWhile = false;
                if (!$this$dropLastWhile$iv.isEmpty()) {
                    ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        it = (CoroutineStackFrameItem)((Object)iterator$iv.previous());
                        boolean bl7 = false;
                        bl3 = CoroutineUtilsKt.isFilterFromBottom(it.getLocation(), preCoroutineTopFrameLocation);
                        bl2 = false;
                        bl = false;
                        $this$apply = bl3;
                        boolean bl8 = false;
                        variablesRemovedFromBottomRestoredFrame.addAll((Collection)it.getSpilledVariables());
                        if (bl3) continue;
                        list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                        break;
                    }
                } else {
                    list = CollectionsKt.emptyList();
                }
            }
            List restoredFrames = list;
            return new Pair((Object)restoredFrames, (Object)variablesRemovedFromBottomRestoredFrame);
        }

        private final RunningCoroutineStackFrameItem buildRealStackFrameItem(StackFrameProxyImpl frame) {
            Location location2 = frame.location();
            if (location2 == null) {
                return null;
            }
            Location location3 = location2;
            return !CoroutineUtilsKt.safeCoroutineExitPointLineNumber(location3) ? new RunningCoroutineStackFrameItem(CoroutineStackFrameProxysKt.safeSkipCoroutineStackFrameProxy(frame), location3, null, 4, null) : null;
        }

        @Nullable
        public final CoroutinePreflightFrame coroutineExitFrame(@NotNull StackFrameProxyImpl frame, @NotNull SuspendContextImpl suspendContext) {
            Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
            Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
            return (CoroutinePreflightFrame)((Object)CoroutineUtilsKt.invokeInManagerThread(suspendContext, (Function0)new Function0<CoroutinePreflightFrame>(frame, suspendContext){
                final /* synthetic */ StackFrameProxyImpl $frame;
                final /* synthetic */ SuspendContextImpl $suspendContext;

                /*
                 * WARNING - void declaration
                 */
                @Nullable
                public final CoroutinePreflightFrame invoke() {
                    void var2_2;
                    Location location2 = this.$frame.location();
                    Intrinsics.checkNotNullExpressionValue((Object)location2, (String)"frame.location()");
                    SuspendExitMode sem = CoroutineUtilsKt.getSuspendExitMode(location2);
                    CoroutinePreflightFrame preflightStackFrame = sem.isCoroutineFound() ? CoroutineFrameBuilder.Companion.lookupContinuation(this.$suspendContext, this.$frame, sem) : null;
                    return var2_2;
                }
                {
                    this.$frame = stackFrameProxyImpl;
                    this.$suspendContext = suspendContextImpl;
                    super(0);
                }
            }));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Nullable
        public final CoroutinePreflightFrame lookupContinuation(@NotNull SuspendContextImpl suspendContext, @NotNull StackFrameProxyImpl frame, @NotNull SuspendExitMode mode) {
            ObjectReference objectReference;
            StackFrameProxyImpl stackFrameProxyImpl;
            List theFollowingFrames;
            Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
            Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
            Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
            if (!mode.isCoroutineFound()) {
                return null;
            }
            List list = this.theFollowingFrames(frame);
            if (list == null) {
                list = theFollowingFrames = CollectionsKt.emptyList();
            }
            if (mode.isSuspendMethodParameter()) {
                Collection collection = theFollowingFrames;
                boolean bl = false;
                if (collection.isEmpty()) return null;
                boolean bl2 = true;
                if (!bl2) return null;
                StackFrameProxyImpl stackFrameProxyImpl2 = this.lookForTheFollowingFrame(theFollowingFrames);
                stackFrameProxyImpl = stackFrameProxyImpl2;
                if (stackFrameProxyImpl2 == null) return null;
            } else {
                stackFrameProxyImpl = null;
            }
            StackFrameProxyImpl suspendParameterFrame = stackFrameProxyImpl;
            if (!CoroutineUtilsKt.threadAndContextSupportsEvaluation(suspendContext, frame)) return null;
            DefaultExecutionContext defaultExecutionContext = CoroutineUtilsKt.executionContext(suspendContext);
            if (defaultExecutionContext == null) return null;
            DefaultExecutionContext context = defaultExecutionContext;
            switch (CoroutineFrameBuilder$Companion$WhenMappings.$EnumSwitchMapping$0[mode.ordinal()]) {
                case 1: {
                    objectReference = this.getThisContinuation(frame);
                    break;
                }
                case 2: {
                    objectReference = this.getLVTContinuation(frame);
                    break;
                }
                default: {
                    return null;
                }
            }
            if (objectReference == null) return null;
            ObjectReference continuation = objectReference;
            ContinuationHolder continuationHolder = ContinuationHolder.Companion.instance(context);
            CoroutineInfoData coroutineInfoData = continuationHolder.extractCoroutineInfoData(continuation);
            if (coroutineInfoData == null) return null;
            CoroutineInfoData coroutineInfo = coroutineInfoData;
            return new CoroutinePreflightFrame(coroutineInfo, frame, theFollowingFrames, mode, null, 16, null);
        }

        /*
         * WARNING - void declaration
         */
        private final StackFrameProxyImpl lookForTheFollowingFrame(List<? extends StackFrameProxyImpl> theFollowingFrames) {
            int n = 0;
            int n2 = Integer.min(5, theFollowingFrames.size());
            while (n < n2) {
                void i;
                StackFrameProxyImpl nextFrame = theFollowingFrames.get((int)i);
                Location location2 = nextFrame.location();
                Intrinsics.checkNotNullExpressionValue((Object)location2, (String)"nextFrame.location()");
                if (CoroutineUtilsKt.getSuspendExitMode(location2) != SuspendExitMode.NONE) {
                    return nextFrame;
                }
                ++i;
            }
            return null;
        }

        private final ObjectReference getLVTContinuation(StackFrameProxyImpl frame) {
            StackFrameProxyImpl stackFrameProxyImpl = frame;
            return stackFrameProxyImpl != null ? CoroutineUtilsKt.continuationVariableValue(stackFrameProxyImpl) : null;
        }

        private final ObjectReference getThisContinuation(StackFrameProxyImpl frame) {
            StackFrameProxyImpl stackFrameProxyImpl = frame;
            return stackFrameProxyImpl != null ? CoroutineUtilsKt.thisVariableValue(stackFrameProxyImpl) : null;
        }

        private final List<StackFrameProxyImpl> theFollowingFrames(StackFrameProxyImpl frame) {
            List list = frame.threadProxy().frames();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"frame.threadProxy().frames()");
            List frames = list;
            int indexOfCurrentFrame = frames.indexOf(frame);
            if (indexOfCurrentFrame >= 0) {
                int indexOfGetCoroutineSuspended = CoroutineUtilsKt.hasGetCoroutineSuspended(frames);
                if (indexOfGetCoroutineSuspended < 0 && frames.size() > indexOfCurrentFrame + 1) {
                    return CollectionsKt.drop((Iterable)frames, (int)(indexOfCurrentFrame + 1));
                }
            } else {
                this.getLog().error("Frame isn't found on the thread stack.");
            }
            return null;
        }

        private Companion() {
        }

        public static final /* synthetic */ RunningCoroutineStackFrameItem access$buildRealStackFrameItem(Companion $this, StackFrameProxyImpl frame) {
            return $this.buildRealStackFrameItem(frame);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0002\u0010\u0007J\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0003J)\u0010\u000e\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\t\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/util/CoroutineFrameBuilder$Companion$CoroutineFrameItemLists;", "", "frames", "", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineStackFrameItem;", "creationFrames", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CreationCoroutineStackFrameItem;", "(Ljava/util/List;Ljava/util/List;)V", "getCreationFrames", "()Ljava/util/List;", "getFrames", "allFrames", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "kotlin.jvm-debugger.coroutines"})
        public static final class CoroutineFrameItemLists {
            @NotNull
            private final List<CoroutineStackFrameItem> frames;
            @NotNull
            private final List<CreationCoroutineStackFrameItem> creationFrames;

            @NotNull
            public final List<CoroutineStackFrameItem> allFrames() {
                return CollectionsKt.plus((Collection)this.frames, (Iterable)this.creationFrames);
            }

            @NotNull
            public final List<CoroutineStackFrameItem> getFrames() {
                return this.frames;
            }

            @NotNull
            public final List<CreationCoroutineStackFrameItem> getCreationFrames() {
                return this.creationFrames;
            }

            public CoroutineFrameItemLists(@NotNull List<? extends CoroutineStackFrameItem> frames, @NotNull List<CreationCoroutineStackFrameItem> creationFrames) {
                Intrinsics.checkNotNullParameter(frames, (String)"frames");
                Intrinsics.checkNotNullParameter(creationFrames, (String)"creationFrames");
                this.frames = frames;
                this.creationFrames = creationFrames;
            }

            @NotNull
            public final List<CoroutineStackFrameItem> component1() {
                return this.frames;
            }

            @NotNull
            public final List<CreationCoroutineStackFrameItem> component2() {
                return this.creationFrames;
            }

            @NotNull
            public final CoroutineFrameItemLists copy(@NotNull List<? extends CoroutineStackFrameItem> frames, @NotNull List<CreationCoroutineStackFrameItem> creationFrames) {
                Intrinsics.checkNotNullParameter(frames, (String)"frames");
                Intrinsics.checkNotNullParameter(creationFrames, (String)"creationFrames");
                return new CoroutineFrameItemLists(frames, creationFrames);
            }

            public static /* synthetic */ CoroutineFrameItemLists copy$default(CoroutineFrameItemLists coroutineFrameItemLists, List list, List list2, int n, Object object) {
                if ((n & 1) != 0) {
                    list = coroutineFrameItemLists.frames;
                }
                if ((n & 2) != 0) {
                    list2 = coroutineFrameItemLists.creationFrames;
                }
                return coroutineFrameItemLists.copy(list, list2);
            }

            @NotNull
            public String toString() {
                return "CoroutineFrameItemLists(frames=" + this.frames + ", creationFrames=" + this.creationFrames + ")";
            }

            public int hashCode() {
                List<CoroutineStackFrameItem> list = this.frames;
                List<CreationCoroutineStackFrameItem> list2 = this.creationFrames;
                return (list != null ? ((Object)list).hashCode() : 0) * 31 + (list2 != null ? ((Object)list2).hashCode() : 0);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof CoroutineFrameItemLists)) break block3;
                        CoroutineFrameItemLists coroutineFrameItemLists = (CoroutineFrameItemLists)object;
                        if (!Intrinsics.areEqual(this.frames, coroutineFrameItemLists.frames) || !Intrinsics.areEqual(this.creationFrames, coroutineFrameItemLists.creationFrames)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
    }
}

