/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.coroutine.proxy;

import com.intellij.openapi.diagnostic.Logger;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutineInfoData;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.ContinuationHolder;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.CoroutineInfoProvider;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.CoroutineNoLibraryProxyKt;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror.CancellableContinuationImpl;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror.MirrorOfCancellableContinuationImpl;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror.MirrorOfDispatchedContinuation;
import org.jetbrains.kotlin.idea.debugger.coroutine.util.CoroutineUtilsKt;
import org.jetbrains.kotlin.idea.debugger.coroutine.util.ProvidersKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.DefaultExecutionContext;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J\u0016\u0010\u0014\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00130\u0016H\u0016J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u001a\u0010\u001b\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\t\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/CoroutineNoLibraryProxy;", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/CoroutineInfoProvider;", "executionContext", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/DefaultExecutionContext;", "(Lorg/jetbrains/kotlin/idea/debugger/evaluate/DefaultExecutionContext;)V", "debugMetadataKtType", "Lcom/sun/jdi/ClassType;", "holder", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/ContinuationHolder;", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "getLog", "()Lcom/intellij/openapi/diagnostic/Logger;", "log$delegate", "Lkotlin/properties/ReadOnlyProperty;", "cancellableContinuation", "", "resultList", "", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineInfoData;", "dispatchedContinuation", "dumpCoroutinesInfo", "", "extractCancellableContinuation", "Lcom/sun/jdi/ObjectReference;", "ccMirrorProvider", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/mirror/CancellableContinuationImpl;", "extractDispatchedContinuation", "continuation", "Lcom/sun/jdi/Field;", "kotlin.jvm-debugger.coroutines"})
public final class CoroutineNoLibraryProxy
implements CoroutineInfoProvider {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final ReadOnlyProperty log$delegate;
    private final ClassType debugMetadataKtType;
    private final ContinuationHolder holder;
    private final DefaultExecutionContext executionContext;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl(CoroutineNoLibraryProxy.class, "log", "getLog()Lcom/intellij/openapi/diagnostic/Logger;", 0))};
    }

    private final Logger getLog() {
        return (Logger)this.log$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @NotNull
    public List<CoroutineInfoData> dumpCoroutinesInfo() {
        block5: {
            block4: {
                vm = this.executionContext.getVm();
                var3_2 = false;
                resultList = new ArrayList<E>();
                if (!vm.getVirtualMachine().canGetInstanceInfo()) break block4;
                var3_3 = CoroutineNoLibraryProxyKt.coroutineSwitch();
                switch (var3_3.hashCode()) {
                    case -56977878: {
                        if (!var3_3.equals("CANCELLABLE_CONTINUATION")) ** break;
                        break;
                    }
                    case -439614947: {
                        if (!var3_3.equals("DISPATCHED_CONTINUATION")) ** break;
                        this.dispatchedContinuation(resultList);
                        break block5;
                    }
                }
                this.cancellableContinuation(resultList);
                break block5;
                this.dispatchedContinuation(resultList);
                break block5;
            }
            this.getLog().warn("Remote JVM doesn't support canGetInstanceInfo capability (perhaps JDK-8197943).");
        }
        return resultList;
    }

    private final boolean cancellableContinuation(List<CoroutineInfoData> resultList) {
        List<ReferenceType> dcClassTypeList;
        List<ReferenceType> list = dcClassTypeList = CoroutineUtilsKt.findCancellableContinuationImplReferenceType(this.executionContext);
        if (list != null) {
            if (list.size() == 1) {
                ReferenceType dcClassType = (ReferenceType)CollectionsKt.first(dcClassTypeList);
                CancellableContinuationImpl cci = new CancellableContinuationImpl(this.executionContext);
                List<ObjectReference> continuationList = dcClassType.instances(CoroutineNoLibraryProxyKt.maxCoroutines());
                Iterator<ObjectReference> iterator = continuationList.iterator();
                while (iterator.hasNext()) {
                    CoroutineInfoData coroutineInfo;
                    ObjectReference cancellableContinuation;
                    ObjectReference objectReference = cancellableContinuation = iterator.next();
                    Intrinsics.checkNotNullExpressionValue((Object)objectReference, (String)"cancellableContinuation");
                    if (this.extractCancellableContinuation(objectReference, cci) == null) {
                        continue;
                    }
                    resultList.add(coroutineInfo);
                }
            }
        }
        return false;
    }

    private final CoroutineInfoData extractCancellableContinuation(ObjectReference dispatchedContinuation, CancellableContinuationImpl ccMirrorProvider) {
        MirrorOfCancellableContinuationImpl mirrorOfCancellableContinuationImpl = (MirrorOfCancellableContinuationImpl)ccMirrorProvider.mirror(dispatchedContinuation, this.executionContext);
        if (mirrorOfCancellableContinuationImpl == null) {
            return null;
        }
        MirrorOfCancellableContinuationImpl mirror = mirrorOfCancellableContinuationImpl;
        Object object = mirror.getDelegate();
        if (object == null || (object = ((MirrorOfDispatchedContinuation)object).getContinuation()) == null) {
            return null;
        }
        Object continuation = object;
        return this.holder.extractCoroutineInfoData((ObjectReference)continuation);
    }

    private final boolean dispatchedContinuation(List<CoroutineInfoData> resultList) {
        List<ReferenceType> dcClassTypeList;
        List<ReferenceType> list = dcClassTypeList = CoroutineUtilsKt.findDispatchedContinuationReferenceType(this.executionContext);
        if (list != null) {
            if (list.size() == 1) {
                ReferenceType dcClassType = (ReferenceType)CollectionsKt.first(dcClassTypeList);
                Field field = dcClassType.fieldByName("continuation");
                if (field == null) {
                    return true;
                }
                Field continuationField = field;
                List<ObjectReference> continuationList = dcClassType.instances(CoroutineNoLibraryProxyKt.maxCoroutines());
                Iterator<ObjectReference> iterator = continuationList.iterator();
                while (iterator.hasNext()) {
                    CoroutineInfoData coroutineInfo;
                    ObjectReference dispatchedContinuation;
                    ObjectReference objectReference = dispatchedContinuation = iterator.next();
                    Intrinsics.checkNotNullExpressionValue((Object)objectReference, (String)"dispatchedContinuation");
                    if (this.extractDispatchedContinuation(objectReference, continuationField) == null) {
                        continue;
                    }
                    resultList.add(coroutineInfo);
                }
            }
        }
        return false;
    }

    private final CoroutineInfoData extractDispatchedContinuation(ObjectReference dispatchedContinuation, Field continuation) {
        if (this.debugMetadataKtType == null) {
            return null;
        }
        Value value = dispatchedContinuation.getValue(continuation);
        if (value == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.sun.jdi.ObjectReference");
        }
        ObjectReference initialContinuation = (ObjectReference)value;
        return this.holder.extractCoroutineInfoData(initialContinuation);
    }

    public CoroutineNoLibraryProxy(@NotNull DefaultExecutionContext executionContext2) {
        Intrinsics.checkNotNullParameter((Object)executionContext2, (String)"executionContext");
        this.executionContext = executionContext2;
        this.log$delegate = ProvidersKt.getLogger();
        this.debugMetadataKtType = CoroutineUtilsKt.findCoroutineMetadataType(this.executionContext);
        this.holder = ContinuationHolder.Companion.instance(this.executionContext);
    }
}

