/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.coroutine.proxy;

import com.intellij.debugger.engine.JavaValue;
import com.intellij.openapi.diagnostic.Logger;
import com.sun.jdi.ClassType;
import com.sun.jdi.Location;
import com.sun.jdi.Mirror;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import com.sun.jdi.VMDisconnectedException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutineInfoData;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutineNameIdState;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutineStackFrameItem;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CreationCoroutineStackFrameItem;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.DefaultCoroutineStackFrameItem;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.State;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.ContinuationHolderKt;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.LocationCache;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror.DebugMetadata;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror.DebugProbesImpl;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror.JavaLangObjectToString;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror.MirrorOfBaseContinuationImpl;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror.MirrorOfContinuationStack;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror.MirrorOfCoroutineContext;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror.MirrorOfCoroutineInfo;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror.MirrorOfStackFrame;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror.MirrorOfStackTraceElement;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror.MirrorOfStandaloneCoroutine;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror.StandaloneCoroutine;
import org.jetbrains.kotlin.idea.debugger.coroutine.util.CoroutineUtilsKt;
import org.jetbrains.kotlin.idea.debugger.coroutine.util.ProvidersKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.DefaultExecutionContext;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 %2\u00020\u0001:\u0001%B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\"\u0010\u001d\u001a\u0004\u0018\u00010\u001a2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001c2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 H\u0002J\u0012\u0010\"\u001a\u0004\u0018\u00010#2\b\u0010$\u001a\u0004\u0018\u00010\u001cR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000f\u001a\u00020\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/ContinuationHolder;", "", "context", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/DefaultExecutionContext;", "(Lorg/jetbrains/kotlin/idea/debugger/evaluate/DefaultExecutionContext;)V", "getContext", "()Lorg/jetbrains/kotlin/idea/debugger/evaluate/DefaultExecutionContext;", "debugMetadata", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/mirror/DebugMetadata;", "debugProbesImpl", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/mirror/DebugProbesImpl;", "javaLangObjectToString", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/mirror/JavaLangObjectToString;", "locationCache", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/LocationCache;", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "getLog", "()Lcom/intellij/openapi/diagnostic/Logger;", "log$delegate$1", "Lkotlin/properties/ReadOnlyProperty;", "createStackFrameItem", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/DefaultCoroutineStackFrameItem;", "frame", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/mirror/MirrorOfStackFrame;", "extractCoroutineInfoData", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineInfoData;", "continuation", "Lcom/sun/jdi/ObjectReference;", "findCoroutineInformation", "coroutineOwner", "stackFrameItems", "", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineStackFrameItem;", "state", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineNameIdState;", "value", "Companion", "kotlin.jvm-debugger.coroutines"})
public final class ContinuationHolder {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final DebugMetadata debugMetadata;
    private final LocationCache locationCache;
    private final DebugProbesImpl debugProbesImpl;
    private final JavaLangObjectToString javaLangObjectToString;
    private final ReadOnlyProperty log$delegate$1;
    @NotNull
    private final DefaultExecutionContext context;
    @NotNull
    private static final ReadOnlyProperty log$delegate;
    @NotNull
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl(ContinuationHolder.class, "log", "getLog()Lcom/intellij/openapi/diagnostic/Logger;", 0))};
        Companion = new Companion(null);
        log$delegate = ProvidersKt.getLogger();
    }

    private final Logger getLog() {
        return (Logger)this.log$delegate$1.getValue((Object)this, $$delegatedProperties[0]);
    }

    @Nullable
    public final CoroutineInfoData extractCoroutineInfoData(@NotNull ObjectReference continuation) {
        Intrinsics.checkNotNullParameter((Object)continuation, (String)"continuation");
        try {
            boolean bl = false;
            List consumer = new ArrayList();
            Object object = this.debugMetadata;
            if (object == null || (object = ((DebugMetadata)object).fetchContinuationStack(continuation, this.context)) == null) {
                return null;
            }
            Object continuationStack = object;
            for (MirrorOfStackFrame frame : ((MirrorOfContinuationStack)continuationStack).getCoroutineStack()) {
                DefaultCoroutineStackFrameItem coroutineStackFrame = this.createStackFrameItem(frame);
                if (coroutineStackFrame == null) continue;
                consumer.add(coroutineStackFrame);
            }
            MirrorOfStackFrame lastRestoredFrame = (MirrorOfStackFrame)CollectionsKt.lastOrNull(((MirrorOfContinuationStack)continuationStack).getCoroutineStack());
            Object object2 = lastRestoredFrame;
            return this.findCoroutineInformation(object2 != null && (object2 = ((MirrorOfStackFrame)object2).getBaseContinuationImpl()) != null ? ((MirrorOfBaseContinuationImpl)object2).getCoroutineOwner() : null, consumer);
        }
        catch (VMDisconnectedException consumer) {
        }
        catch (Exception e) {
            this.getLog().warn("Error while looking for stack frame", (Throwable)e);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private final CoroutineInfoData findCoroutineInformation(ObjectReference coroutineOwner, List<? extends CoroutineStackFrameItem> stackFrameItems) {
        CoroutineNameIdState coroutineNameIdState;
        List creationStackTrace;
        block3: {
            MirrorOfCoroutineInfo ci;
            block5: {
                int n;
                int n2;
                block6: {
                    block4: {
                        block2: {
                            boolean bl = false;
                            creationStackTrace = new ArrayList();
                            Mirror mirror = coroutineOwner;
                            if (mirror == null || (mirror = mirror.type()) == null || !CoroutineUtilsKt.isAbstractCoroutine((Type)mirror)) break block2;
                            coroutineNameIdState = this.state(coroutineOwner);
                            if (coroutineNameIdState == null) {
                                return null;
                            }
                            break block3;
                        }
                        DebugProbesImpl debugProbesImpl = this.debugProbesImpl;
                        MirrorOfCoroutineInfo mirrorOfCoroutineInfo = ci = debugProbesImpl != null ? debugProbesImpl.getCoroutineInfo(coroutineOwner, this.context) : null;
                        if (ci == null) break block4;
                        if (ci.getCreationStackTrace() == null) break block5;
                        n2 = 0;
                        n = ((Collection)ci.getCreationStackTrace()).size();
                        break block6;
                    }
                    coroutineNameIdState = new CoroutineNameIdState("coroutine", "-1", State.UNKNOWN, null);
                    break block3;
                }
                while (n2 < n) {
                    void index;
                    MirrorOfStackTraceElement frame = ci.getCreationStackTrace().get((int)index);
                    StackTraceElement ste = frame.stackTraceElement();
                    Location location2 = this.locationCache.createLocation(ste);
                    creationStackTrace.add(new CreationCoroutineStackFrameItem(ste, location2, index == false));
                    ++index;
                }
            }
            coroutineNameIdState = CoroutineNameIdState.Companion.instance(ci);
        }
        CoroutineNameIdState realState = coroutineNameIdState;
        return new CoroutineInfoData(realState, stackFrameItems, creationStackTrace, null, null, 24, null);
    }

    @Nullable
    public final CoroutineNameIdState state(@Nullable ObjectReference value) {
        MirrorOfStandaloneCoroutine standAloneCoroutineMirror;
        if (value == null) {
            return null;
        }
        StandaloneCoroutine standaloneCoroutine = StandaloneCoroutine.Companion.instance(this.context);
        if (standaloneCoroutine == null) {
            return null;
        }
        StandaloneCoroutine standaloneCoroutine2 = standaloneCoroutine;
        MirrorOfStandaloneCoroutine mirrorOfStandaloneCoroutine = standAloneCoroutineMirror = (MirrorOfStandaloneCoroutine)standaloneCoroutine2.mirror(value, this.context);
        if ((mirrorOfStandaloneCoroutine != null ? mirrorOfStandaloneCoroutine.getContext() : null) instanceof MirrorOfCoroutineContext) {
            Long id = standAloneCoroutineMirror.getContext().getId();
            String string = standAloneCoroutineMirror.getContext().getName();
            if (string == null) {
                string = "coroutine";
            }
            String name = string;
            String toString = (String)this.javaLangObjectToString.mirror(value, this.context);
            String string2 = "\\w+\\{(\\w+)}@([\\w\\d]+)";
            boolean bl = false;
            Regex r = new Regex(string2);
            Matcher matcher = r.toPattern().matcher(toString);
            if (matcher.matches()) {
                State state = ContinuationHolder.Companion.stateOf(matcher.group(1));
                String hexAddress = matcher.group(2);
                Object object = id;
                if (object == null || (object = String.valueOf((Long)object)) == null) {
                    object = hexAddress;
                }
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"id?.toString() ?: hexAddress");
                return new CoroutineNameIdState(name, (String)object, state, standAloneCoroutineMirror.getContext().getDispatcher());
            }
        }
        return null;
    }

    private final DefaultCoroutineStackFrameItem createStackFrameItem(MirrorOfStackFrame frame) {
        Object object = frame.getBaseContinuationImpl().getStackTraceElement();
        if (object == null || (object = ((MirrorOfStackTraceElement)object).stackTraceElement()) == null) {
            return null;
        }
        Object stackTraceElement = object;
        String string = ((StackTraceElement)stackTraceElement).getClassName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stackTraceElement.className");
        ClassType classType = this.context.findClassSafe(string);
        if (classType == null) {
            return null;
        }
        ClassType locationClass = classType;
        ReferenceType referenceType = locationClass;
        String string2 = ((StackTraceElement)stackTraceElement).getMethodName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"stackTraceElement.methodName");
        Location generatedLocation = this.locationCache.createLocation(referenceType, string2, ((StackTraceElement)stackTraceElement).getLineNumber());
        List<JavaValue> spilledVariables = ContinuationHolderKt.spilledValues(frame.getBaseContinuationImpl(), this.context);
        return new DefaultCoroutineStackFrameItem(generatedLocation, spilledVariables);
    }

    @NotNull
    public final DefaultExecutionContext getContext() {
        return this.context;
    }

    private ContinuationHolder(DefaultExecutionContext context) {
        this.context = context;
        this.debugMetadata = DebugMetadata.Companion.instance(this.context);
        this.locationCache = new LocationCache(this.context);
        this.debugProbesImpl = DebugProbesImpl.Companion.instance(this.context);
        this.javaLangObjectToString = new JavaLangObjectToString(this.context);
        this.log$delegate$1 = ProvidersKt.getLogger();
    }

    public /* synthetic */ ContinuationHolder(DefaultExecutionContext context, DefaultConstructorMarker $constructor_marker) {
        this(context);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0012\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002R\u001b\u0010\u0003\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/ContinuationHolder$Companion;", "", "()V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "getLog", "()Lcom/intellij/openapi/diagnostic/Logger;", "log$delegate", "Lkotlin/properties/ReadOnlyProperty;", "instance", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/ContinuationHolder;", "context", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/DefaultExecutionContext;", "stateOf", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/State;", "state", "", "kotlin.jvm-debugger.coroutines"})
    public static final class Companion {
        static final /* synthetic */ KProperty[] $$delegatedProperties;

        static {
            $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl(Companion.class, "log", "getLog()Lcom/intellij/openapi/diagnostic/Logger;", 0))};
        }

        @NotNull
        public final Logger getLog() {
            return (Logger)log$delegate.getValue((Object)Companion, $$delegatedProperties[0]);
        }

        @NotNull
        public final ContinuationHolder instance(@NotNull DefaultExecutionContext context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return new ContinuationHolder(context, null);
        }

        /*
         * Enabled aggressive block sorting
         */
        private final State stateOf(String state) {
            State state2;
            String string = state;
            if (string != null) {
                switch (string) {
                    case "Active": {
                        state2 = State.RUNNING;
                        return state2;
                    }
                    case "Cancelling": {
                        state2 = State.SUSPENDED_CANCELLING;
                        return state2;
                    }
                    case "Completing": {
                        state2 = State.SUSPENDED_COMPLETING;
                        return state2;
                    }
                    case "Cancelled": {
                        state2 = State.CANCELLED;
                        return state2;
                    }
                    case "Completed": {
                        state2 = State.COMPLETED;
                        return state2;
                    }
                    case "New": {
                        state2 = State.NEW;
                        return state2;
                    }
                }
            }
            state2 = State.UNKNOWN;
            return state2;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

