/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.coroutine.data;

import com.intellij.debugger.engine.JavaValue;
import com.intellij.openapi.diagnostic.Logger;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ThreadReference;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutineNameIdState;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutineStackFrameItem;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CreationCoroutineStackFrameItem;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.State;
import org.jetbrains.kotlin.idea.debugger.coroutine.util.ProvidersKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u0000 +2\u00020\u0001:\u0001+BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rJ\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\u000f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\b0\u0005H\u00c6\u0003J\u000b\u0010\u001a\u001a\u0004\u0018\u00010\nH\u00c6\u0003J\u000b\u0010\u001b\u001a\u0004\u0018\u00010\fH\u00c6\u0003JK\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010 \u001a\u00020!H\u00d6\u0001J\u0006\u0010\"\u001a\u00020\u001eJ\u0006\u0010#\u001a\u00020\u001eJ\u0006\u0010$\u001a\u00020\u001eJ\u0006\u0010%\u001a\u00020\u001eJ\t\u0010&\u001a\u00020'H\u00d6\u0001J\f\u0010(\u001a\b\u0012\u0004\u0012\u00020)0\u0005J\n\u0010*\u001a\u0004\u0018\u00010\u0006H\u0002R\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0011\u00a8\u0006,"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineInfoData;", "", "key", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineNameIdState;", "stackTrace", "", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineStackFrameItem;", "creationStackTrace", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CreationCoroutineStackFrameItem;", "activeThread", "Lcom/sun/jdi/ThreadReference;", "lastObservedFrame", "Lcom/sun/jdi/ObjectReference;", "(Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineNameIdState;Ljava/util/List;Ljava/util/List;Lcom/sun/jdi/ThreadReference;Lcom/sun/jdi/ObjectReference;)V", "getActiveThread", "()Lcom/sun/jdi/ThreadReference;", "getCreationStackTrace", "()Ljava/util/List;", "getKey", "()Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineNameIdState;", "getLastObservedFrame", "()Lcom/sun/jdi/ObjectReference;", "getStackTrace", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "isCreated", "isEmptyStack", "isRunning", "isSuspended", "toString", "", "topFrameVariables", "Lcom/intellij/debugger/engine/JavaValue;", "topRestoredFrame", "Companion", "kotlin.jvm-debugger.coroutines"})
public final class CoroutineInfoData {
    @NotNull
    private final CoroutineNameIdState key;
    @NotNull
    private final List<CoroutineStackFrameItem> stackTrace;
    @NotNull
    private final List<CreationCoroutineStackFrameItem> creationStackTrace;
    @Nullable
    private final ThreadReference activeThread;
    @Nullable
    private final ObjectReference lastObservedFrame;
    @NotNull
    private static final ReadOnlyProperty log$delegate;
    @NotNull
    public static final String DEFAULT_COROUTINE_NAME = "coroutine";
    @NotNull
    public static final String DEFAULT_COROUTINE_STATE = "UNKNOWN";
    @NotNull
    public static final Companion Companion;

    public final boolean isSuspended() {
        return this.key.getState() == State.SUSPENDED;
    }

    public final boolean isCreated() {
        return this.key.getState() == State.CREATED;
    }

    public final boolean isEmptyStack() {
        return this.stackTrace.isEmpty();
    }

    public final boolean isRunning() {
        return this.key.getState() == State.RUNNING;
    }

    private final CoroutineStackFrameItem topRestoredFrame() {
        return (CoroutineStackFrameItem)((Object)CollectionsKt.firstOrNull(this.stackTrace));
    }

    @NotNull
    public final List<JavaValue> topFrameVariables() {
        Object object = this.topRestoredFrame();
        if (object == null || (object = object.getSpilledVariables()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @NotNull
    public final CoroutineNameIdState getKey() {
        return this.key;
    }

    @NotNull
    public final List<CoroutineStackFrameItem> getStackTrace() {
        return this.stackTrace;
    }

    @NotNull
    public final List<CreationCoroutineStackFrameItem> getCreationStackTrace() {
        return this.creationStackTrace;
    }

    @Nullable
    public final ThreadReference getActiveThread() {
        return this.activeThread;
    }

    @Nullable
    public final ObjectReference getLastObservedFrame() {
        return this.lastObservedFrame;
    }

    public CoroutineInfoData(@NotNull CoroutineNameIdState key, @NotNull List<? extends CoroutineStackFrameItem> stackTrace, @NotNull List<CreationCoroutineStackFrameItem> creationStackTrace, @Nullable ThreadReference activeThread, @Nullable ObjectReference lastObservedFrame) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(stackTrace, (String)"stackTrace");
        Intrinsics.checkNotNullParameter(creationStackTrace, (String)"creationStackTrace");
        this.key = key;
        this.stackTrace = stackTrace;
        this.creationStackTrace = creationStackTrace;
        this.activeThread = activeThread;
        this.lastObservedFrame = lastObservedFrame;
    }

    public /* synthetic */ CoroutineInfoData(CoroutineNameIdState coroutineNameIdState, List list, List list2, ThreadReference threadReference, ObjectReference objectReference, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            threadReference = null;
        }
        if ((n & 0x10) != 0) {
            objectReference = null;
        }
        this(coroutineNameIdState, list, list2, threadReference, objectReference);
    }

    static {
        Companion = new Companion(null);
        log$delegate = ProvidersKt.getLogger();
    }

    @NotNull
    public final CoroutineNameIdState component1() {
        return this.key;
    }

    @NotNull
    public final List<CoroutineStackFrameItem> component2() {
        return this.stackTrace;
    }

    @NotNull
    public final List<CreationCoroutineStackFrameItem> component3() {
        return this.creationStackTrace;
    }

    @Nullable
    public final ThreadReference component4() {
        return this.activeThread;
    }

    @Nullable
    public final ObjectReference component5() {
        return this.lastObservedFrame;
    }

    @NotNull
    public final CoroutineInfoData copy(@NotNull CoroutineNameIdState key, @NotNull List<? extends CoroutineStackFrameItem> stackTrace, @NotNull List<CreationCoroutineStackFrameItem> creationStackTrace, @Nullable ThreadReference activeThread, @Nullable ObjectReference lastObservedFrame) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(stackTrace, (String)"stackTrace");
        Intrinsics.checkNotNullParameter(creationStackTrace, (String)"creationStackTrace");
        return new CoroutineInfoData(key, stackTrace, creationStackTrace, activeThread, lastObservedFrame);
    }

    public static /* synthetic */ CoroutineInfoData copy$default(CoroutineInfoData coroutineInfoData, CoroutineNameIdState coroutineNameIdState, List list, List list2, ThreadReference threadReference, ObjectReference objectReference, int n, Object object) {
        if ((n & 1) != 0) {
            coroutineNameIdState = coroutineInfoData.key;
        }
        if ((n & 2) != 0) {
            list = coroutineInfoData.stackTrace;
        }
        if ((n & 4) != 0) {
            list2 = coroutineInfoData.creationStackTrace;
        }
        if ((n & 8) != 0) {
            threadReference = coroutineInfoData.activeThread;
        }
        if ((n & 0x10) != 0) {
            objectReference = coroutineInfoData.lastObservedFrame;
        }
        return coroutineInfoData.copy(coroutineNameIdState, list, list2, threadReference, objectReference);
    }

    @NotNull
    public String toString() {
        return "CoroutineInfoData(key=" + this.key + ", stackTrace=" + this.stackTrace + ", creationStackTrace=" + this.creationStackTrace + ", activeThread=" + this.activeThread + ", lastObservedFrame=" + this.lastObservedFrame + ")";
    }

    public int hashCode() {
        CoroutineNameIdState coroutineNameIdState = this.key;
        List<CoroutineStackFrameItem> list = this.stackTrace;
        List<CreationCoroutineStackFrameItem> list2 = this.creationStackTrace;
        ThreadReference threadReference = this.activeThread;
        ObjectReference objectReference = this.lastObservedFrame;
        return ((((coroutineNameIdState != null ? ((Object)coroutineNameIdState).hashCode() : 0) * 31 + (list != null ? ((Object)list).hashCode() : 0)) * 31 + (list2 != null ? ((Object)list2).hashCode() : 0)) * 31 + (threadReference != null ? threadReference.hashCode() : 0)) * 31 + (objectReference != null ? ((Object)objectReference).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof CoroutineInfoData)) break block3;
                CoroutineInfoData coroutineInfoData = (CoroutineInfoData)object;
                if (!Intrinsics.areEqual((Object)this.key, (Object)coroutineInfoData.key) || !Intrinsics.areEqual(this.stackTrace, coroutineInfoData.stackTrace) || !Intrinsics.areEqual(this.creationStackTrace, coroutineInfoData.creationStackTrace) || !Intrinsics.areEqual((Object)this.activeThread, (Object)coroutineInfoData.activeThread) || !Intrinsics.areEqual((Object)this.lastObservedFrame, (Object)coroutineInfoData.lastObservedFrame)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\u00020\u00078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineInfoData$Companion;", "", "()V", "DEFAULT_COROUTINE_NAME", "", "DEFAULT_COROUTINE_STATE", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "getLog", "()Lcom/intellij/openapi/diagnostic/Logger;", "log$delegate", "Lkotlin/properties/ReadOnlyProperty;", "kotlin.jvm-debugger.coroutines"})
    public static final class Companion {
        static final /* synthetic */ KProperty[] $$delegatedProperties;

        static {
            $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl(Companion.class, "log", "getLog()Lcom/intellij/openapi/diagnostic/Logger;", 0))};
        }

        @NotNull
        public final Logger getLog() {
            return (Logger)log$delegate.getValue((Object)Companion, $$delegatedProperties[0]);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

