/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.coroutine.command;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.execution.filters.ExceptionFilters;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.impl.RunnerContentUi;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.content.Content;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.debugger.coroutine.KotlinDebuggerCoroutinesBundle;
import org.jetbrains.kotlin.idea.debugger.coroutine.command.CoroutineDumpAction;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutineInfoCache;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutineInfoData;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.CoroutineDebugProbesProxy;
import org.jetbrains.kotlin.idea.debugger.coroutine.view.CoroutineDumpPanel;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J,\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/command/CoroutineDumpAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "addCoroutineDump", "project", "Lcom/intellij/openapi/project/Project;", "coroutines", "", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineInfoData;", "ui", "Lcom/intellij/execution/ui/RunnerLayoutUi;", "searchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "update", "kotlin.jvm-debugger.coroutines"})
public final class CoroutineDumpAction
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"e.project ?: return");
        Project project2 = project;
        DebuggerManagerEx debuggerManagerEx = DebuggerManagerEx.getInstanceEx((Project)project2);
        Intrinsics.checkNotNullExpressionValue((Object)debuggerManagerEx, (String)"DebuggerManagerEx.getInstanceEx(project)");
        DebuggerContextImpl debuggerContextImpl = debuggerManagerEx.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)debuggerContextImpl, (String)"DebuggerManagerEx.getInstanceEx(project).context");
        DebuggerContextImpl context = debuggerContextImpl;
        DebuggerSession session = context.getDebuggerSession();
        if (session != null && session.isAttached()) {
            DebugProcessImpl debugProcessImpl = context.getDebugProcess();
            if (debugProcessImpl == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)debugProcessImpl, (String)"context.debugProcess ?: return");
            DebugProcessImpl process = debugProcessImpl;
            process.getManagerThread().schedule((DebuggerCommandImpl)new SuspendContextCommandImpl(this, session, project2, context, context.getSuspendContext()){
                final /* synthetic */ CoroutineDumpAction this$0;
                final /* synthetic */ DebuggerSession $session;
                final /* synthetic */ Project $project;
                final /* synthetic */ DebuggerContextImpl $context;

                public void contextAction(@NotNull SuspendContextImpl suspendContext) {
                    Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
                    CoroutineInfoCache states = new CoroutineDebugProbesProxy(suspendContext).dumpCoroutines();
                    if (states.isOk()) {
                        Function0 f2;
                        Function0 function0 = f2 = (Function0)new Function0<Unit>(this, states){
                            final /* synthetic */ actionPerformed.1 this$0;
                            final /* synthetic */ CoroutineInfoCache $states;

                            public final void invoke() {
                                XDebugSession xDebugSession = this.this$0.$session.getXDebugSession();
                                if (xDebugSession == null || (xDebugSession = xDebugSession.getUI()) == null) {
                                    return;
                                }
                                XDebugSession ui = xDebugSession;
                                CoroutineDumpAction coroutineDumpAction = this.this$0.this$0;
                                Project project = this.this$0.$project;
                                List<CoroutineInfoData> list = this.$states.getCache();
                                GlobalSearchScope globalSearchScope = this.this$0.$session.getSearchScope();
                                Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"session.searchScope");
                                coroutineDumpAction.addCoroutineDump(project, list, (RunnerLayoutUi)ui, globalSearchScope);
                            }
                            {
                                this.this$0 = var1_1;
                                this.$states = coroutineInfoCache;
                                super(0);
                            }
                        };
                        ApplicationManager.getApplication().invokeLater(new Runnable(function0){
                            private final /* synthetic */ Function0 function;
                            {
                                this.function = function0;
                            }

                            public final /* synthetic */ void run() {
                                Intrinsics.checkNotNullExpressionValue((Object)this.function.invoke(), (String)"invoke(...)");
                            }
                        }, ModalityState.NON_MODAL);
                    } else {
                        String message = KotlinDebuggerCoroutinesBundle.message("coroutine.dump.failed", new Object[0]);
                        NotificationGroup notificationGroup = XDebuggerManagerImpl.getNotificationGroup();
                        MessageType messageType = MessageType.ERROR;
                        Intrinsics.checkNotNullExpressionValue((Object)messageType, (String)"MessageType.ERROR");
                        notificationGroup.createNotification(message, messageType).notify(this.$project);
                    }
                }
                {
                    this.this$0 = this$0;
                    this.$session = $captured_local_variable$1;
                    this.$project = $captured_local_variable$2;
                    this.$context = $captured_local_variable$3;
                    super($super_call_param$4);
                }
            });
        }
    }

    public final void addCoroutineDump(@NotNull Project project, @NotNull List<CoroutineInfoData> coroutines, @NotNull RunnerLayoutUi ui, @NotNull GlobalSearchScope searchScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(coroutines, (String)"coroutines");
        Intrinsics.checkNotNullParameter((Object)ui, (String)"ui");
        Intrinsics.checkNotNullParameter((Object)searchScope, (String)"searchScope");
        TextConsoleBuilder textConsoleBuilder = TextConsoleBuilderFactory.getInstance().createBuilder(project);
        Intrinsics.checkNotNullExpressionValue((Object)textConsoleBuilder, (String)"TextConsoleBuilderFactor\u2026().createBuilder(project)");
        TextConsoleBuilder consoleBuilder = textConsoleBuilder;
        consoleBuilder.filters(ExceptionFilters.getFilters((GlobalSearchScope)searchScope));
        ConsoleView consoleView = consoleBuilder.getConsole();
        Intrinsics.checkNotNullExpressionValue((Object)consoleView, (String)"consoleBuilder.console");
        ConsoleView consoleView2 = consoleView;
        DefaultActionGroup toolbarActions = new DefaultActionGroup();
        consoleView2.allowHeavyFilters();
        CoroutineDumpPanel panel = new CoroutineDumpPanel(project, consoleView2, toolbarActions, coroutines);
        String id = "DumpKt " + DateFormatUtil.formatTimeWithSeconds((long)System.currentTimeMillis());
        Content content = ui.createContent(id, (JComponent)panel, id, null, null);
        boolean bl = false;
        boolean bl2 = false;
        Content $this$apply = content;
        boolean bl3 = false;
        $this$apply.putUserData(RunnerContentUi.LIGHTWEIGHT_CONTENT_MARKER, (Object)true);
        $this$apply.setCloseable(true);
        $this$apply.setDescription(KotlinDebuggerCoroutinesBundle.message("coroutine.dump.panel.title", new Object[0]));
        Content content2 = content;
        Intrinsics.checkNotNullExpressionValue((Object)content2, (String)"ui.createContent(id, pan\u2026p.panel.title\")\n        }");
        Content content3 = content2;
        ui.addContent(content3);
        ui.selectAndFocus(content3, true, true);
        Disposer.register((Disposable)((Disposable)content3), (Disposable)((Disposable)consoleView2));
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
        Presentation presentation2 = presentation;
        Project project = e.getProject();
        if (project == null) {
            presentation2.setEnabled(false);
            presentation2.setVisible(false);
            return;
        }
        DebuggerManagerEx debuggerManagerEx = DebuggerManagerEx.getInstanceEx((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)debuggerManagerEx, (String)"DebuggerManagerEx.getInstanceEx(project)");
        DebuggerContextImpl debuggerContextImpl = debuggerManagerEx.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)debuggerContextImpl, (String)"DebuggerManagerEx.getInstanceEx(project).context");
        if (debuggerContextImpl.getSuspendContext() == null) {
            presentation2.setEnabled(false);
            return;
        }
        DebuggerManagerEx debuggerManagerEx2 = DebuggerManagerEx.getInstanceEx((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)debuggerManagerEx2, (String)"DebuggerManagerEx.getInstanceEx(project)");
        DebuggerContextImpl debuggerContextImpl2 = debuggerManagerEx2.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)debuggerContextImpl2, (String)"DebuggerManagerEx.getInstanceEx(project).context");
        DebuggerSession debuggerSession = debuggerContextImpl2.getDebuggerSession();
        presentation2.setEnabled(debuggerSession != null && debuggerSession.isAttached());
        presentation2.setVisible(presentation2.isEnabled());
    }
}

