/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.coroutine;

import com.intellij.debugger.NoDataException;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.sun.jdi.Location;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.descriptors.DescriptorUtilsKt;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.debugger.KotlinPositionManager;
import org.jetbrains.kotlin.idea.search.usagesSearch.SearchHelpersKt;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.psi.KtVariableDeclaration;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u000e\u0010\f\u001a\u0004\u0018\u00010\r*\u00020\u000eH\u0002J\u0014\u0010\u000f\u001a\u00020\u0010*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J0\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\b*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u000e2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\r0\u0016H\u0002J\u0012\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\t0\b*\u00020\u0018H\u0002J\u0012\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b*\u00020\u000eH\u0002J\u0014\u0010\u0019\u001a\u00020\u001a*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\f\u0010\u001b\u001a\u00020\u001a*\u00020\u0010H\u0002J\u0014\u0010\u001c\u001a\u00020\u001a*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0014\u0010\u001d\u001a\u00020\u001a*\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0016\u0010\u001e\u001a\u0004\u0018\u00010\u001f*\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0014\u0010 \u001a\u00020\u001a*\u00020!2\u0006\u0010\"\u001a\u00020\u000eH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/KotlinVariableNameFinder;", "", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "(Lcom/intellij/debugger/engine/DebugProcessImpl;)V", "getDebugProcess", "()Lcom/intellij/debugger/engine/DebugProcessImpl;", "findVisibleVariableNames", "", "", "location", "Lcom/sun/jdi/Location;", "findEnclosingBlockExpression", "Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "Lcom/intellij/psi/PsiElement;", "findExpressionToStartAnalysisFrom", "Lorg/jetbrains/kotlin/psi/KtExpression;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "findVariableNames", "boundaryElement", "blocksToVisit", "Lkotlin/sequences/Sequence;", "findVariableNamesInParameterList", "Lorg/jetbrains/kotlin/psi/KtFunction;", "isCoroutineContextAvailable", "", "isCoroutineContextAvailableFromFunction", "isCoroutineContextAvailableFromLambda", "isInlined", "safeSourcePosition", "Lcom/intellij/debugger/SourcePosition;", "shouldBeFiltered", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "elementAtBreakpointPosition", "kotlin.jvm-debugger.coroutines"})
public final class KotlinVariableNameFinder {
    @NotNull
    private final DebugProcessImpl debugProcess;

    @RequiresReadLock
    @NotNull
    public final List<String> findVisibleVariableNames(@NotNull Location location2) {
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        SourcePosition sourcePosition = this.safeSourcePosition(location2, this.debugProcess);
        if (sourcePosition == null) {
            return CollectionsKt.emptyList();
        }
        SourcePosition sourcePosition2 = sourcePosition;
        ProgressManager.checkCanceled();
        PsiElement psiElement = sourcePosition2.getElementAt();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"sourcePosition.elementAt");
        return this.findVisibleVariableNames(psiElement);
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> findVisibleVariableNames(PsiElement $this$findVisibleVariableNames) {
        void $this$parentOfType$iv;
        KtBlockExpression ktBlockExpression = this.findEnclosingBlockExpression($this$findVisibleVariableNames);
        if (ktBlockExpression == null) {
            return CollectionsKt.emptyList();
        }
        KtBlockExpression enclosingBlockExpression = ktBlockExpression;
        PsiElement $this$parentsOfType$iv = (PsiElement)enclosingBlockExpression;
        boolean withSelf$iv = true;
        boolean $i$f$parentsOfType = false;
        Sequence blockParents = PsiTreeUtilKt.parentsOfType((PsiElement)$this$parentsOfType$iv, KtBlockExpression.class, (boolean)withSelf$iv);
        if (SequencesKt.none((Sequence)blockParents)) {
            return CollectionsKt.emptyList();
        }
        ProgressManager.checkCanceled();
        BindingContext bindingContext = ResolutionUtils.analyze((KtElement)((KtElement)SequencesKt.last((Sequence)blockParents)), (BodyResolveMode)BodyResolveMode.PARTIAL);
        ProgressManager.checkCanceled();
        KtExpression expressionToStartAnalysisFrom = this.findExpressionToStartAnalysisFrom((KtExpression)enclosingBlockExpression, bindingContext);
        if (!this.isCoroutineContextAvailable(expressionToStartAnalysisFrom, bindingContext)) {
            return CollectionsKt.emptyList();
        }
        ProgressManager.checkCanceled();
        PsiElement psiElement = (PsiElement)expressionToStartAnalysisFrom;
        boolean withSelf$iv2 = true;
        boolean $i$f$parentOfType = false;
        KtFunction parentFunction = (KtFunction)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, KtFunction.class, (boolean)false);
        Object object = parentFunction;
        if (object == null || (object = this.findVariableNamesInParameterList((KtFunction)object)) == null) {
            object = CollectionsKt.emptyList();
        }
        Object namesInParameterList = object;
        List<String> namesVisibleInExpression = this.findVariableNames(expressionToStartAnalysisFrom, bindingContext, $this$findVisibleVariableNames, (Sequence<? extends KtBlockExpression>)blockParents);
        return CollectionsKt.plus((Collection)namesVisibleInExpression, (Iterable)((Iterable)namesInParameterList));
    }

    private final List<String> findVariableNames(KtExpression $this$findVariableNames, BindingContext bindingContext, PsiElement boundaryElement, Sequence<? extends KtBlockExpression> blocksToVisit) {
        boolean bl = false;
        List names = new ArrayList();
        $this$findVariableNames.accept((PsiElementVisitor)new KtTreeVisitorVoid(this, bindingContext, blocksToVisit, boundaryElement, names){
            private boolean stopTraversal;
            final /* synthetic */ KotlinVariableNameFinder this$0;
            final /* synthetic */ BindingContext $bindingContext;
            final /* synthetic */ Sequence $blocksToVisit;
            final /* synthetic */ PsiElement $boundaryElement;
            final /* synthetic */ List $names;

            public final boolean getStopTraversal() {
                return this.stopTraversal;
            }

            public final void setStopTraversal(boolean bl) {
                this.stopTraversal = bl;
            }

            public void visitBlockExpression(@NotNull KtBlockExpression expression) {
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                if (KotlinVariableNameFinder.access$isInlined(this.this$0, expression, this.$bindingContext) || SequencesKt.contains((Sequence)this.$blocksToVisit, (Object)expression)) {
                    expression.acceptChildren((PsiElementVisitor)this);
                }
            }

            public void visitKtElement(@NotNull KtElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                ProgressManager.checkCanceled();
                if (this.stopTraversal) {
                    return;
                }
                if (PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)element)) >= PsiUtilsKt.getStartOffset((PsiElement)this.$boundaryElement)) {
                    this.stopTraversal = true;
                    return;
                }
                if (element instanceof KtVariableDeclaration && !KotlinVariableNameFinder.access$shouldBeFiltered(this.this$0, (KtDeclaration)element, this.$boundaryElement)) {
                    String string = ((KtVariableDeclaration)element).getName();
                    if (string != null) {
                        String string2 = string;
                        boolean bl = false;
                        boolean bl2 = false;
                        String it = string2;
                        boolean bl3 = false;
                        String string3 = it;
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"it");
                        this.$names.add(string3);
                    }
                }
                element.acceptChildren((PsiElementVisitor)this);
            }
            {
                this.this$0 = this$0;
                this.$bindingContext = $captured_local_variable$1;
                this.$blocksToVisit = $captured_local_variable$2;
                this.$boundaryElement = $captured_local_variable$3;
                this.$names = $captured_local_variable$4;
            }
        });
        return names;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> findVariableNamesInParameterList(KtFunction $this$findVariableNamesInParameterList) {
        void $this$mapNotNullTo$iv$iv;
        PsiElement $this$getChildOfType$iv = (PsiElement)$this$findVariableNamesInParameterList;
        boolean $i$f$getChildOfType = false;
        KtParameterList ktParameterList = (KtParameterList)PsiTreeUtil.getChildOfType((PsiElement)$this$getChildOfType$iv, KtParameterList.class);
        if (ktParameterList == null) {
            return CollectionsKt.emptyList();
        }
        KtParameterList parameterList = ktParameterList;
        List list = parameterList.getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"parameterList.parameters");
        Iterable $this$mapNotNull$iv = list;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String string;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            KtParameter it = (KtParameter)element$iv$iv;
            boolean bl2 = false;
            KtParameter ktParameter = it;
            Intrinsics.checkNotNullExpressionValue((Object)ktParameter, (String)"it");
            if (ktParameter.getName() == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            String it$iv$iv = string;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final KtExpression findExpressionToStartAnalysisFrom(KtExpression $this$findExpressionToStartAnalysisFrom, BindingContext bindingContext) {
        KtExpression lastSeenBlockExpression = $this$findExpressionToStartAnalysisFrom;
        for (PsiElement parent : PsiTreeUtilKt.parents((PsiElement)((PsiElement)$this$findExpressionToStartAnalysisFrom), (boolean)true)) {
            PsiElement psiElement = parent;
            if (psiElement instanceof KtNamedFunction) {
                return (KtExpression)parent;
            }
            if (!(psiElement instanceof KtBlockExpression)) continue;
            if (!this.isInlined((KtBlockExpression)parent, bindingContext) && !(((KtBlockExpression)parent).getParent() instanceof KtWhenEntry)) {
                return (KtExpression)parent;
            }
            lastSeenBlockExpression = (KtExpression)parent;
        }
        return lastSeenBlockExpression;
    }

    private final boolean isCoroutineContextAvailable(KtExpression $this$isCoroutineContextAvailable, BindingContext bindingContext) {
        return this.isCoroutineContextAvailableFromFunction($this$isCoroutineContextAvailable) || this.isCoroutineContextAvailableFromLambda($this$isCoroutineContextAvailable, bindingContext);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isCoroutineContextAvailableFromFunction(KtExpression $this$isCoroutineContextAvailableFromFunction) {
        void $this$parentOfType$iv;
        PsiElement psiElement = (PsiElement)$this$isCoroutineContextAvailableFromFunction;
        boolean withSelf$iv = true;
        boolean $i$f$parentOfType = false;
        KtFunction ktFunction = (KtFunction)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, KtFunction.class, (boolean)false);
        if (ktFunction == null) {
            return false;
        }
        KtFunction functionParent = ktFunction;
        DeclarationDescriptor declarationDescriptor = SearchHelpersKt.getDescriptor((KtDeclaration)((KtDeclaration)functionParent));
        if (!(declarationDescriptor instanceof CallableDescriptor)) {
            declarationDescriptor = null;
        }
        CallableDescriptor callableDescriptor = (CallableDescriptor)declarationDescriptor;
        if (callableDescriptor == null) {
            return false;
        }
        CallableDescriptor descriptor = callableDescriptor;
        return DescriptorUtilsKt.isSuspend((CallableDescriptor)descriptor);
    }

    private final boolean isCoroutineContextAvailableFromLambda(KtExpression $this$isCoroutineContextAvailableFromLambda, BindingContext bindingContext) {
        KotlinType kotlinType = CallUtilKt.getType((KtExpression)$this$isCoroutineContextAvailableFromLambda, (BindingContext)bindingContext);
        if (kotlinType == null) {
            return false;
        }
        KotlinType type = kotlinType;
        return FunctionTypesKt.isSuspendFunctionType((KotlinType)type);
    }

    private final KtBlockExpression findEnclosingBlockExpression(PsiElement $this$findEnclosingBlockExpression) {
        for (PsiElement parent : PsiTreeUtilKt.parents((PsiElement)$this$findEnclosingBlockExpression, (boolean)false)) {
            PsiElement psiElement = parent;
            if (psiElement instanceof KtFunction || psiElement instanceof KtWhenEntry || psiElement instanceof KtLambdaExpression) {
                PsiElement $this$getChildOfType$iv = parent;
                boolean $i$f$getChildOfType = false;
                return (KtBlockExpression)PsiTreeUtil.getChildOfType((PsiElement)$this$getChildOfType$iv, KtBlockExpression.class);
            }
            if (!(psiElement instanceof KtBlockExpression)) continue;
            return (KtBlockExpression)parent;
        }
        return null;
    }

    private final boolean shouldBeFiltered(KtDeclaration $this$shouldBeFiltered, PsiElement elementAtBreakpointPosition) {
        return $this$shouldBeFiltered.getParent() instanceof KtWhenExpression ? !SequencesKt.contains((Sequence)PsiTreeUtilKt.parents((PsiElement)elementAtBreakpointPosition, (boolean)false), (Object)$this$shouldBeFiltered.getParent()) : false;
    }

    private final boolean isInlined(KtBlockExpression $this$isInlined, BindingContext bindingContext) {
        PsiElement $this$parentOfType$iv = (PsiElement)$this$isInlined;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        KtFunction ktFunction = (KtFunction)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, KtFunction.class, (boolean)true);
        if (ktFunction == null) {
            return false;
        }
        KtFunction parentFunction = ktFunction;
        return InlineUtil.isInlinedArgument((KtFunction)parentFunction, (BindingContext)bindingContext, (boolean)false);
    }

    private final SourcePosition safeSourcePosition(Location $this$safeSourcePosition, DebugProcessImpl debugProcess) {
        SourcePosition sourcePosition;
        try {
            sourcePosition = new KotlinPositionManager((DebugProcess)debugProcess).getSourcePosition($this$safeSourcePosition);
        }
        catch (NoDataException ex) {
            sourcePosition = null;
        }
        return sourcePosition;
    }

    @NotNull
    public final DebugProcessImpl getDebugProcess() {
        return this.debugProcess;
    }

    public KotlinVariableNameFinder(@NotNull DebugProcessImpl debugProcess) {
        Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
        this.debugProcess = debugProcess;
    }

    public static final /* synthetic */ boolean access$isInlined(KotlinVariableNameFinder $this, KtBlockExpression $this$access_u24isInlined, BindingContext bindingContext) {
        return $this.isInlined($this$access_u24isInlined, bindingContext);
    }

    public static final /* synthetic */ boolean access$shouldBeFiltered(KotlinVariableNameFinder $this, KtDeclaration $this$access_u24shouldBeFiltered, PsiElement elementAtBreakpointPosition) {
        return $this.shouldBeFiltered($this$access_u24shouldBeFiltered, elementAtBreakpointPosition);
    }
}

