/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.coroutine;

import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.content.Content;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XDebuggerManagerListener;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.coroutine.CoroutineAgentConnector;
import org.jetbrains.kotlin.idea.debugger.coroutine.util.CreateContentParams;
import org.jetbrains.kotlin.idea.debugger.coroutine.util.CreateContentParamsProvider;
import org.jetbrains.kotlin.idea.debugger.coroutine.util.ProvidersKt;
import org.jetbrains.kotlin.idea.debugger.coroutine.view.XCoroutineView;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 (2\u00020\u00012\u00020\u0002:\u0001(B9\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0018\u001a\u00020\nH\u0002J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020 2\u0006\u0010\"\u001a\u00020#H\u0016J\u0012\u0010%\u001a\u0004\u0018\u00010\u00022\u0006\u0010&\u001a\u00020'H\u0002R\u0011\u0010\u000b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0005\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/DebuggerConnection;", "Lcom/intellij/xdebugger/XDebuggerManagerListener;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "configuration", "Lcom/intellij/execution/configurations/RunConfigurationBase;", "params", "Lcom/intellij/execution/configurations/JavaParameters;", "modifyArgs", "", "alwaysShowPanel", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/execution/configurations/RunConfigurationBase;Lcom/intellij/execution/configurations/JavaParameters;ZZ)V", "getAlwaysShowPanel", "()Z", "getConfiguration", "()Lcom/intellij/execution/configurations/RunConfigurationBase;", "connection", "Lcom/intellij/util/messages/MessageBusConnection;", "coroutineAgentAttached", "getParams", "()Lcom/intellij/execution/configurations/JavaParameters;", "getProject", "()Lcom/intellij/openapi/project/Project;", "coroutinesPanelShouldBeShown", "createContent", "Lcom/intellij/ui/content/Content;", "ui", "Lcom/intellij/execution/ui/RunnerLayoutUi;", "createContentParamProvider", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/util/CreateContentParamsProvider;", "dispose", "", "processStarted", "debugProcess", "Lcom/intellij/xdebugger/XDebugProcess;", "processStopped", "registerXCoroutinesPanel", "session", "Lcom/intellij/xdebugger/XDebugSession;", "Companion", "kotlin.jvm-debugger.coroutines"})
public final class DebuggerConnection
implements XDebuggerManagerListener,
Disposable {
    private MessageBusConnection connection;
    private final boolean coroutineAgentAttached;
    @NotNull
    private final Project project;
    @Nullable
    private final RunConfigurationBase<?> configuration;
    @Nullable
    private final JavaParameters params;
    private final boolean alwaysShowPanel;
    private static final ReadOnlyProperty log$delegate;
    @NotNull
    public static final Companion Companion;

    public void processStarted(@NotNull XDebugProcess debugProcess) {
        Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
        DebuggerInvocationUtil.swingInvokeLater((Project)this.project, (Runnable)new Runnable(this, debugProcess){
            final /* synthetic */ DebuggerConnection this$0;
            final /* synthetic */ XDebugProcess $debugProcess;

            public final void run() {
                block1: {
                    if (!(this.$debugProcess instanceof JavaDebugProcess) || Disposer.isDisposed((Disposable)this.this$0) || !DebuggerConnection.access$coroutinesPanelShouldBeShown(this.this$0)) break block1;
                    XDebugSession xDebugSession = ((JavaDebugProcess)this.$debugProcess).getSession();
                    Intrinsics.checkNotNullExpressionValue((Object)xDebugSession, (String)"debugProcess.session");
                    Disposable disposable = DebuggerConnection.access$registerXCoroutinesPanel(this.this$0, xDebugSession);
                    if (disposable != null) {
                        Disposable disposable2 = disposable;
                        boolean bl = false;
                        boolean bl2 = false;
                        Disposable it = disposable2;
                        boolean bl3 = false;
                        Disposer.register((Disposable)this.this$0, (Disposable)it);
                    }
                }
            }
            {
                this.this$0 = debuggerConnection;
                this.$debugProcess = xDebugProcess;
            }
        });
    }

    public void processStopped(@NotNull XDebugProcess debugProcess) {
        Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
        ApplicationManager.getApplication().invokeLater(new Runnable(this){
            final /* synthetic */ DebuggerConnection this$0;

            public final void run() {
                Disposer.dispose((Disposable)this.this$0);
            }
            {
                this.this$0 = debuggerConnection;
            }
        });
    }

    private final Disposable registerXCoroutinesPanel(XDebugSession session) {
        RunnerLayoutUi runnerLayoutUi = session.getUI();
        if (runnerLayoutUi == null) {
            return null;
        }
        RunnerLayoutUi ui = runnerLayoutUi;
        XDebugSession xDebugSession = session;
        if (xDebugSession == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.xdebugger.impl.XDebugSessionImpl");
        }
        XCoroutineView xCoroutineThreadView = new XCoroutineView(this.project, (XDebugSession)((XDebugSessionImpl)xDebugSession));
        Content framesContent = this.createContent(ui, xCoroutineThreadView);
        framesContent.setCloseable(false);
        ui.addContent(framesContent, 0, PlaceInGrid.right, false);
        session.addSessionListener((XDebugSessionListener)xCoroutineThreadView.debugSessionListener(session));
        session.rebuildViews();
        return xCoroutineThreadView;
    }

    private final boolean coroutinesPanelShouldBeShown() {
        return this.alwaysShowPanel || this.configuration instanceof ExternalSystemRunConfiguration || this.coroutineAgentAttached;
    }

    private final Content createContent(RunnerLayoutUi ui, CreateContentParamsProvider createContentParamProvider) {
        CreateContentParams param = createContentParamProvider.createContentParams();
        Content content = ui.createContent(param.getId(), param.getComponent(), param.getDisplayName(), param.getIcon(), param.getParentComponent());
        Intrinsics.checkNotNullExpressionValue((Object)content, (String)"ui.createContent(param.i\u2026n, param.parentComponent)");
        return content;
    }

    public void dispose() {
        MessageBusConnection messageBusConnection = this.connection;
        if (messageBusConnection != null) {
            messageBusConnection.disconnect();
        }
        this.connection = null;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public final RunConfigurationBase<?> getConfiguration() {
        return this.configuration;
    }

    @Nullable
    public final JavaParameters getParams() {
        return this.params;
    }

    public final boolean getAlwaysShowPanel() {
        return this.alwaysShowPanel;
    }

    public DebuggerConnection(@NotNull Project project, @Nullable RunConfigurationBase<?> configuration, @Nullable JavaParameters params, boolean modifyArgs, boolean alwaysShowPanel) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
            this.configuration = configuration;
            this.params = params;
            this.alwaysShowPanel = alwaysShowPanel;
            if (this.params instanceof JavaParameters && modifyArgs) {
                this.coroutineAgentAttached = CoroutineAgentConnector.INSTANCE.attachCoroutineAgent(this.project, this.params, this.configuration);
            } else {
                this.coroutineAgentAttached = false;
                DebuggerConnection.Companion.getLog().debug("Coroutine debugger disabled.");
            }
            MessageBusConnection messageBusConnection = this.connection = this.project.getMessageBus().connect();
            if (messageBusConnection == null) break block2;
            messageBusConnection.subscribe(XDebuggerManager.TOPIC, (Object)this);
        }
    }

    public /* synthetic */ DebuggerConnection(Project project, RunConfigurationBase runConfigurationBase, JavaParameters javaParameters, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = true;
        }
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        this(project, runConfigurationBase, javaParameters, bl, bl2);
    }

    static {
        Companion = new Companion(null);
        log$delegate = ProvidersKt.getLogger();
    }

    public static final /* synthetic */ boolean access$coroutinesPanelShouldBeShown(DebuggerConnection $this) {
        return $this.coroutinesPanelShouldBeShown();
    }

    public static final /* synthetic */ Disposable access$registerXCoroutinesPanel(DebuggerConnection $this, XDebugSession session) {
        return $this.registerXCoroutinesPanel(session);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/DebuggerConnection$Companion;", "", "()V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "getLog", "()Lcom/intellij/openapi/diagnostic/Logger;", "log$delegate", "Lkotlin/properties/ReadOnlyProperty;", "kotlin.jvm-debugger.coroutines"})
    public static final class Companion {
        static final /* synthetic */ KProperty[] $$delegatedProperties;

        static {
            $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl(Companion.class, "log", "getLog()Lcom/intellij/openapi/diagnostic/Logger;", 0))};
        }

        private final Logger getLog() {
            return (Logger)log$delegate.getValue((Object)Companion, $$delegatedProperties[0]);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

