/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.mpp.debugger;

import com.intellij.openapi.project.Project;
import com.jetbrains.mpp.MPPWorkspace;
import com.jetbrains.mpp.debugger.DebugExecutionAware;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.konan.target.HostManager;
import org.jetbrains.kotlin.konan.target.KonanTarget;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/jetbrains/mpp/debugger/MPPDebugExecutionAware;", "Lcom/jetbrains/mpp/debugger/DebugExecutionAware;", "()V", "getParams", "", "", "project", "Lcom/intellij/openapi/project/Project;", "kotlin-ultimate.ultimate-native"})
public final class MPPDebugExecutionAware
extends DebugExecutionAware {
    @NotNull
    public Map<String, String> getParams(@NotNull Project project) {
        HashMap params;
        block3: {
            KonanTarget konanTarget;
            File lldbHome;
            block2: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                if (!CollectionsKt.listOf((Object[])new KonanTarget[]{(KonanTarget)KonanTarget.MACOS_X64.INSTANCE, (KonanTarget)KonanTarget.LINUX_X64.INSTANCE}).contains(HostManager.Companion.getHost())) {
                    return MapsKt.emptyMap();
                }
                File file = MPPWorkspace.Companion.getInstance(project).getLldbHome();
                if (file == null) {
                    return MapsKt.emptyMap();
                }
                lldbHome = file;
                params = new HashMap();
                ((Map)params).put("PROJECT_PATH", String.valueOf(project.getBasePath()));
                konanTarget = HostManager.Companion.getHost();
                if (!Intrinsics.areEqual((Object)konanTarget, (Object)KonanTarget.MACOS_X64.INSTANCE)) break block2;
                Map map = params;
                String string = FilesKt.resolve((File)lldbHome, (String)"LLDB.framework/Resources/debugserver").toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"lldbHome.resolve(LOCAL_DEBUG_SERVER).toString()");
                map.put("DEBUG_SERVER_PATH", string);
                break block3;
            }
            if (!Intrinsics.areEqual((Object)konanTarget, (Object)KonanTarget.LINUX_X64.INSTANCE)) break block3;
            Map map = params;
            String string = FilesKt.resolve((File)lldbHome, (String)"bin/lldb-server").toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"lldbHome.resolve(\"bin/lldb-server\").toString()");
            map.put("DEBUG_SERVER_PATH", string);
            ((Map)params).put("DEBUG_SERVER_ARGS", "g");
        }
        return params;
    }
}

